/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product.config;

import fr.acksys.ndm.ig.ConfigDialog2;
import fr.acksys.ndm.ig.ConfigProgressThread;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ParamTableModel;
import fr.acksys.ndm.product.Product;
import fr.acksys.translation.TranslateEnum;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;

public class ConfigThread
extends Thread {
    public static final int TIMEOUT = -1;
    public static final int CONFIG_OK = 0;
    public static final int INVALID_PWD = 1;
    public static final int CONFIG_ERROR = 2;
    public static final int TIMEOUT_CHECK = 3;
    public static final int NO_CONFIG_HANDLER = 4;
    private Product product;
    private JTextArea logArea;
    private char[] pass;
    private ConfigProgressThread configProgress;
    private ConfigDialog2 config;

    public ConfigThread(Product product, JTextArea logArea, JPasswordField password, ConfigProgressThread configProgress, ConfigDialog2 config) {
        this.product = product;
        this.logArea = logArea;
        this.pass = password.getPassword();
        this.configProgress = configProgress;
        this.config = config;
    }

    @Override
    public void run() {
        TranslateEnum statusMessage;
        switch (this.product.configure(this.pass)) {
            case -1: {
                statusMessage = TranslateEnum.CFG_TIMEOUT_PRODUCT;
                break;
            }
            case 0: {
                statusMessage = TranslateEnum.CFG_CONFIG_OK;
                break;
            }
            case 1: {
                statusMessage = TranslateEnum.CFG_INVALID_PWD;
                break;
            }
            default: {
                statusMessage = TranslateEnum.CFG_CONFIG_ERROR;
                break;
            }
            case 3: {
                statusMessage = TranslateEnum.CFG_TIMEOUT_CHECK;
                break;
            }
            case 4: {
                statusMessage = TranslateEnum.CFG_CANNOT_CONFIG;
            }
        }
        final String messageString = String.valueOf(statusMessage.get()) + " : " + this.product.getUniqueIdString() + "\r\n";
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                ConfigThread.this.logArea.append(messageString);
            }
        });
        this.configProgress.decrementProduct();
        ArrayList<Product> selectList = new ArrayList<Product>();
        List<Product> productList = ((ParamTableModel)this.config.table.getModel()).getListproduct();
        int[] selection = this.config.table.getSelectedRows();
        int i = 0;
        while (i < selection.length) {
            selectList.add(productList.get(this.config.table.convertRowIndexToModel(selection[i])));
            ++i;
        }
        this.config.updateIG(selectList);
    }
}

