/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product.config;

import fr.acksys.ndm.Main;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.product.OpenWrtProduct;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.config.ConfigInterface;
import fr.acksys.ndm.product.config.TimeoutThread;
import fr.acksys.snmp.Oid;
import fr.acksys.snmp.SnmpReturnedTable;
import fr.acksys.udap.GetResponse;
import fr.acksys.udap.SetResponse;
import fr.acksys.udap.Udap;
import fr.acksys.udap.UdapResponse;
import fr.acksys.udap.UdapSocket;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class OpenWrtConfig
implements ConfigInterface {
    private static final int WLG_CONFIG_REBOOT_TIME = 40000;
    private static final int WLG_CONFIG_ASSOC_TIMEOUT = 2000;
    private static final int WLG_CONFIG_ASSOC_RETRY = 10;
    private static final int WLG_IDEN_RETRY = 3;
    private OpenWrtProduct targetProduct;
    private Thread updateConfigThread = null;
    private boolean rerunThread = false;
    private Object updateConfigThreadToken = new Object();
    private Runnable updateConfigCode = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SnmpReturnedTable table1 = null;
            SnmpReturnedTable table2 = null;
            SnmpReturnedTable table3 = null;
            SnmpReturnedTable table4 = null;
            boolean rerun = false;
            OpenWrtConfig.this.rerunThread = false;
            do {
                if (OpenWrtConfig.this.targetProduct.canUdap()) {
                    Udap.updateConfig(OpenWrtConfig.this.targetProduct, false);
                }
                if (((OpenWrtConfig)OpenWrtConfig.this).targetProduct.snmpVersion == 0) continue;
                ArrayList<Oid> oidList = new ArrayList<Oid>();
                oidList.add(Oid.SYSDESCR);
                oidList.add(Oid.SYSLOCATION);
                oidList.add(Oid.PRODUCT_CODE);
                oidList.add(Oid.WIFI_AP_CLIENTS);
                if (!OpenWrtConfig.this.targetProduct.canUdap()) {
                    oidList.add(Oid.IP_ADDRESS);
                    oidList.add(Oid.SUBNET_MASK);
                    oidList.add(Oid.GATEWAY);
                    oidList.add(Oid.DHCP_STATE);
                }
                oidList.add(Oid.STATUS_CHANGES);
                Main.snmpmanager.getSnmpString(OpenWrtConfig.this.targetProduct, oidList);
                table1 = Main.snmpmanager.getSnmpTable(OpenWrtConfig.this.targetProduct, Oid.RADIO_TABLE);
                table2 = Main.snmpmanager.getSnmpTable(OpenWrtConfig.this.targetProduct, Oid.WLAN_TABLE);
                table3 = Main.snmpmanager.getSnmpTable(OpenWrtConfig.this.targetProduct, Oid.ASSOC_TABLE);
                table4 = Main.snmpmanager.getSnmpTable(OpenWrtConfig.this.targetProduct, Oid.ASS_STA_TABLE);
                Object object = OpenWrtConfig.this.updateConfigThreadToken;
                synchronized (object) {
                    OpenWrtConfig.this.updateConfigThread = null;
                    rerun = OpenWrtConfig.this.rerunThread;
                    OpenWrtConfig.this.rerunThread = false;
                }
            } while (rerun);
            OpenWrtProduct openWrtProduct = OpenWrtConfig.this.targetProduct;
            synchronized (openWrtProduct) {
                if (table1 != null) {
                    OpenWrtConfig.this.targetProduct.changeStatusParamArray(table1.table, table1.columns, table1.nbLignesReponse);
                }
                if (table2 != null) {
                    OpenWrtConfig.this.targetProduct.changeStatusParamArray(table2.table, table2.columns, table2.nbLignesReponse);
                }
                if (table3 != null) {
                    OpenWrtConfig.this.targetProduct.changeStatusParamArray(table3.table, table3.columns, table3.nbLignesReponse);
                }
                if (table4 != null) {
                    OpenWrtConfig.this.targetProduct.changeStatusParamArray(table4.table, table4.columns, table4.nbLignesReponse);
                }
                if (OpenWrtConfig.this.targetProduct.getCurrentWirelessRole() == 2) {
                    OpenWrtConfig.this.targetProduct.setDefaultBridgeStatus();
                }
            }
            OpenWrtConfig.this.targetProduct.checkForDisplayChanges();
        }
    };

    public OpenWrtConfig(Product target) {
        this.targetProduct = (OpenWrtProduct)target;
    }

    @Override
    public void getConfig(final List<Oid> idList) {
        if (this.targetProduct.snmpVersion != 0) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.setName("getConfig " + OpenWrtConfig.this.targetProduct.toString());
                    if (idList.get(0) == Oid.WIFI_BRIDGE_RSSI) {
                        SnmpReturnedTable table = Main.snmpmanager.getSnmpTable(OpenWrtConfig.this.targetProduct, Oid.ASSOC_TABLE);
                        if (table != null) {
                            OpenWrtProduct openWrtProduct = OpenWrtConfig.this.targetProduct;
                            synchronized (openWrtProduct) {
                                OpenWrtConfig.this.targetProduct.changeStatusParamArray(table.table, table.columns, table.nbLignesReponse);
                                if (OpenWrtConfig.this.targetProduct.getCurrentWirelessRole() == 2) {
                                    OpenWrtConfig.this.targetProduct.setDefaultBridgeStatus();
                                }
                            }
                        }
                    } else if (idList.get(0) == Oid.ASS_STA_TABLE_MAC) {
                        SnmpReturnedTable table = Main.snmpmanager.getSnmpTable(OpenWrtConfig.this.targetProduct, Oid.ASS_STA_TABLE);
                        if (table != null) {
                            OpenWrtProduct openWrtProduct = OpenWrtConfig.this.targetProduct;
                            synchronized (openWrtProduct) {
                                OpenWrtConfig.this.targetProduct.changeStatusParamArray(table.table, table.columns, table.nbLignesReponse);
                            }
                        }
                    } else {
                        Main.snmpmanager.getSnmpString(OpenWrtConfig.this.targetProduct, idList);
                    }
                }
            }.start();
        }
    }

    @Override
    public int setConfig(List<Parameter> paramList, char[] password) {
        if (password != null && this.targetProduct.canUdap()) {
            boolean isConfigIp = true;
            for (Parameter param : paramList) {
                Oid oid = param.getId();
                switch (oid) {
                    case RESET: 
                    case DHCP_STATE: 
                    case IP_ADDRESS: 
                    case SUBNET_MASK: 
                    case GATEWAY: {
                        break;
                    }
                    case SYSLOCATION: {
                        if (this.targetProduct.locationchange && this.targetProduct.firmspec == "CA") {
                            try {
                                return this.setLocConfig();
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                                break;
                            }
                        }
                        isConfigIp = false;
                        break;
                    }
                    default: {
                        isConfigIp = false;
                    }
                }
            }
            if (isConfigIp) {
                return this.setUdapConfig(password);
            }
        }
        if (this.targetProduct.snmpVersion != 0) {
            ArrayList<Oid> oidList = new ArrayList<Oid>();
            boolean mustReset = false;
            for (Parameter param : paramList) {
                Oid oid = param.getId();
                if (oid == Oid.RESET) {
                    mustReset = true;
                    continue;
                }
                oidList.add(oid);
            }
            if (mustReset) {
                oidList.add(Oid.RESET);
            }
            return Main.snmpmanager.setSnmpString(this.targetProduct, oidList);
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setLocConfig() throws UnsupportedEncodingException {
        int configOk = 2;
        boolean setConfigOk = false;
        UdapResponse response = null;
        String macAddress = this.targetProduct.getUniqueIdString();
        String location = (String)this.targetProduct.getParam(Oid.SYSLOCATION).getNewValue();
        if (location == null) {
            location = (String)this.targetProduct.getParam(Oid.SYSLOCATION).getValue();
        }
        UdapSocket udap = new UdapSocket(macAddress);
        Object token = udap.getToken();
        TimeoutThread timeOut1 = new TimeoutThread(token, 2000);
        timeOut1.start();
        if (this.targetProduct.locationchange) {
            Object object = token;
            synchronized (object) {
                udap.startReception(12);
                udap.UDAPLocConfig_CAT(macAddress, location);
                try {
                    block5: do {
                        token.wait();
                        do {
                            if ((response = udap.getResponse()) == null) {
                                setConfigOk = true;
                                continue block5;
                            }
                            if (12 != response.getMethod()) continue;
                            configOk = 0;
                            setConfigOk = true;
                            continue block5;
                        } while (!udap.IsEmpty());
                    } while (!setConfigOk);
                    timeOut1.stopTimeout();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            udap.terminateReception(12);
        }
        return configOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int setUdapConfig(char[] password) {
        UdapResponse response;
        Object token;
        UdapSocket udap;
        int dhcpState;
        String gateway;
        String subnetMask;
        String ipAddress;
        String macAddress;
        int configOk;
        block31: {
            boolean setConfigOk = false;
            configOk = 2;
            macAddress = this.targetProduct.getUniqueIdString();
            ipAddress = (String)this.targetProduct.getParam(Oid.IP_ADDRESS).getNewValue();
            subnetMask = (String)this.targetProduct.getParam(Oid.SUBNET_MASK).getNewValue();
            gateway = (String)this.targetProduct.getParam(Oid.GATEWAY).getNewValue();
            try {
                dhcpState = (Integer)this.targetProduct.getParam(Oid.DHCP_STATE).getNewValue();
            }
            catch (Exception e) {
                dhcpState = -1;
            }
            if (ipAddress == null) {
                ipAddress = (String)this.targetProduct.getParam(Oid.IP_ADDRESS).getValue();
            }
            if (subnetMask == null) {
                subnetMask = (String)this.targetProduct.getParam(Oid.SUBNET_MASK).getValue();
            }
            if (gateway == null) {
                gateway = (String)this.targetProduct.getParam(Oid.GATEWAY).getValue();
            }
            if (dhcpState < 0) {
                dhcpState = (Integer)this.targetProduct.getParam(Oid.DHCP_STATE).getValue();
            }
            if (ipAddress == null || subnetMask == null || gateway == null || dhcpState < 0) {
                return 2;
            }
            udap = new UdapSocket(macAddress);
            token = udap.getToken();
            TimeoutThread timeOut1 = new TimeoutThread(token, 2000);
            timeOut1.setName("WLg-setConfig-tmo1 " + this.targetProduct.toString());
            timeOut1.start();
            Object object = token;
            synchronized (object) {
                udap.startReception(3);
                udap.setConfig(macAddress, ipAddress, subnetMask, gateway, dhcpState, null, null);
                try {}
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    break block31;
                }
                block17: do {
                    token.wait();
                    do {
                        if ((response = udap.getResponse()) == null) {
                            setConfigOk = true;
                            continue block17;
                        }
                        if (3 != response.getMethod()) continue;
                        SetResponse setResp = (SetResponse)response;
                        switch (setResp.getErrorCode()) {
                            case -1: 
                            case 0: {
                                setConfigOk = true;
                                break;
                            }
                            case 1: {
                                timeOut1.stopTimeout();
                                udap.terminateReception(3);
                                return 1;
                            }
                            case 2: {
                                udap.setConfig(macAddress, ipAddress, subnetMask, gateway, dhcpState, setResp.getHashCode(), password);
                                break;
                            }
                        }
                    } while (!udap.IsEmpty());
                } while (!setConfigOk);
                timeOut1.stopTimeout();
                int pause_time = 40000;
                if (this.targetProduct.firmspec == "CA") {
                    pause_time = 2000;
                }
                Thread.sleep(pause_time);
            }
        }
        udap.terminateReception(3);
        udap.startReception(2);
        int timeoutRetry = 10;
        while (timeoutRetry > 0) {
            TimeoutThread timeOut2 = new TimeoutThread(token, 2000);
            timeOut2.setName("tmo2 " + this.targetProduct.toString());
            timeOut2.start();
            Object object = token;
            synchronized (object) {
                udap.getConfig(macAddress);
                try {
                    token.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!udap.IsEmpty()) {
                    timeOut2.stopTimeout();
                    break;
                }
            }
            --timeoutRetry;
        }
        configOk = 3;
        while (!udap.IsEmpty() && (response = udap.getResponse()) != null) {
            GetResponse getResponse = (GetResponse)response;
            if (getResponse.getDhcpEnabled() == dhcpState && dhcpState == 2) {
                configOk = 0;
                continue;
            }
            if (!getResponse.getIpAddress().equals(ipAddress) || !getResponse.getSubnetMask().equals(subnetMask) || !getResponse.getGateway().equals(gateway)) continue;
            configOk = 0;
        }
        udap.terminateReception(2);
        return configOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfig() {
        Object object = this.updateConfigThreadToken;
        synchronized (object) {
            if (this.updateConfigThread == null) {
                this.updateConfigThread = new Thread(this.updateConfigCode);
                this.updateConfigThread.setName("OpenWrtConfigUpdate " + this.targetProduct);
                this.updateConfigThread.start();
            } else {
                this.rerunThread = true;
            }
        }
    }

    @Override
    public int getConfigurationTime() {
        if (this.targetProduct.firmspec == "CA") {
            return 22000;
        }
        return 60000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void idenUdapProduct(int timeout) {
        boolean setConfigOk = false;
        int compt_timeout = 0;
        String macAddress = this.targetProduct.getUniqueIdString();
        UdapSocket udap = new UdapSocket(macAddress);
        Object token = udap.getToken();
        TimeoutThread timeOut1 = new TimeoutThread(token, 1000);
        timeOut1.setName("WLg-setConfig-tmo1 " + this.targetProduct.toString());
        timeOut1.start();
        Object object = token;
        synchronized (object) {
            udap.startReception(10);
            udap.setIdent_udap(macAddress, timeout);
            try {
                token.wait();
                while (true) {
                    if (!udap.IsEmpty()) {
                        UdapResponse response = udap.getResponse();
                        if (response == null) {
                            setConfigOk = false;
                            this.targetProduct.is_respond = false;
                        } else {
                            if (response.getMethod() != 10) continue;
                            setConfigOk = true;
                            this.targetProduct.is_respond = true;
                            continue;
                        }
                    }
                    if (compt_timeout < 3) {
                        ++compt_timeout;
                    } else {
                        setConfigOk = true;
                        this.targetProduct.is_respond = false;
                    }
                    if (setConfigOk) break;
                }
                timeOut1.stopTimeout();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        udap.terminateReception(10);
    }
}

