/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product.config;

import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.config.ConfigInterface;
import fr.acksys.snmp.Oid;
import fr.acksys.udap.GetResponse;
import fr.acksys.udap.Udap;
import fr.acksys.udap.UdapResponse;
import fr.acksys.udap.UdapSocket;
import java.util.List;

public class SondeConfig
implements ConfigInterface {
    private Product targetProduct;
    private Thread updateConfigThread = null;
    private Object updateConfigThreadToken = new Object();
    private static final int SONDE_CONFIG_REBOOT_TIME = 6000;
    private Runnable updateConfigCode = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Udap.updateConfig(SondeConfig.this.targetProduct, false);
            Object object = SondeConfig.this.updateConfigThreadToken;
            synchronized (object) {
                SondeConfig.this.updateConfigThread = null;
            }
            SondeConfig.this.targetProduct.checkForDisplayChanges();
        }
    };

    public SondeConfig(Product target) {
        this.targetProduct = target;
    }

    @Override
    public void getConfig(List<Oid> idList) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setConfig(List<Parameter> paramList, char[] password) {
        int dhcpState;
        int configOk = 2;
        String macAddress = this.targetProduct.getUniqueIdString();
        String ipAddress = (String)this.targetProduct.getParam(Oid.IP_ADDRESS).getNewValue();
        String subnetMask = (String)this.targetProduct.getParam(Oid.SUBNET_MASK).getNewValue();
        String gateway = (String)this.targetProduct.getParam(Oid.GATEWAY).getNewValue();
        try {
            dhcpState = (Integer)this.targetProduct.getParam(Oid.DHCP_STATE).getNewValue();
        }
        catch (Exception e) {
            dhcpState = -1;
        }
        if (ipAddress == null) {
            ipAddress = (String)this.targetProduct.getParam(Oid.IP_ADDRESS).getValue();
        }
        if (subnetMask == null) {
            subnetMask = (String)this.targetProduct.getParam(Oid.SUBNET_MASK).getValue();
        }
        if (gateway == null) {
            gateway = (String)this.targetProduct.getParam(Oid.GATEWAY).getValue();
        }
        if (dhcpState < 0) {
            dhcpState = (Integer)this.targetProduct.getParam(Oid.DHCP_STATE).getValue();
        }
        UdapSocket udap = new UdapSocket(macAddress);
        udap.startReception(3);
        udap.setConfig(macAddress, ipAddress, subnetMask, gateway, dhcpState, null, null);
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        udap.terminateReception(3);
        udap.startReception(2);
        udap.getConfig(macAddress);
        final Object token = udap.getToken();
        try {
            Thread timeOut = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Object object = token;
                    synchronized (object) {
                        token.notify();
                    }
                }
            };
            timeOut.setName("timeoutSonde");
            timeOut.start();
            Object object = token;
            synchronized (object) {
                token.wait();
                block12: while (!udap.IsEmpty()) {
                    UdapResponse response = udap.getResponse();
                    switch (response.getMethod()) {
                        case 2: {
                            GetResponse getResponse = (GetResponse)response;
                            if (!getResponse.getIpAddress().equals(ipAddress) || !getResponse.getSubnetMask().equals(subnetMask) || !getResponse.getGateway().equals(gateway) || getResponse.getDhcpEnabled() != dhcpState) continue block12;
                            configOk = 0;
                        }
                    }
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        udap.terminateReception(2);
        return configOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfig() {
        Object object = this.updateConfigThreadToken;
        synchronized (object) {
            if (this.updateConfigThread == null) {
                this.updateConfigThread = new Thread(this.updateConfigCode);
                this.updateConfigThread.start();
            }
        }
    }

    @Override
    public int getConfigurationTime() {
        return 6000;
    }

    @Override
    public void idenUdapProduct(int timeout) {
    }
}

