/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product.config;

import fr.acksys.ndm.Main;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.config.ConfigInterface;
import fr.acksys.ndm.product.config.TimeoutThread;
import fr.acksys.snmp.Oid;
import fr.acksys.udap.GetResponse;
import fr.acksys.udap.SetResponse;
import fr.acksys.udap.Udap;
import fr.acksys.udap.UdapResponse;
import fr.acksys.udap.UdapSocket;
import java.util.ArrayList;
import java.util.List;

public class WlgConfig
implements ConfigInterface {
    private static final int WLG_CONFIG_REBOOT_TIME = 15000;
    private static final int WLG_CONFIG_ASSOC_TIMEOUT = 2000;
    private static final int WLG_CONFIG_ASSOC_RETRY = 10;
    private static final int WLG_IDEN_RETRY = 3;
    private Product targetProduct;
    private Thread updateConfigThread = null;
    private Object updateConfigThreadToken = new Object();
    private Runnable updateConfigCode = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (WlgConfig.this.targetProduct.canUdap()) {
                Udap.updateConfig(WlgConfig.this.targetProduct, false);
            }
            if (((WlgConfig)WlgConfig.this).targetProduct.snmpVersion != 0) {
                ArrayList<Oid> oidList = new ArrayList<Oid>();
                oidList.add(Oid.SYSDESCR);
                oidList.add(Oid.SYSLOCATION);
                oidList.add(Oid.PRODUCT_CODE);
                oidList.add(Oid.WIFI_BRIDGE_RSSI_dBm);
                oidList.add(Oid.WIFI_BRIDGE_RSSI);
                oidList.add(Oid.WIFI_SSID);
                oidList.add(Oid.WPA_VERSION);
                oidList.add(Oid.WIFI_SECURITY);
                oidList.add(Oid.WIFI_AP_CHANNEL);
                oidList.add(Oid.WIFI_AP_CLIENTS);
                oidList.add(Oid.WIFI_802);
                oidList.add(Oid.WIFI_BRIDGE_MAC_AP);
                oidList.add(Oid.WIFI_BRIDGE_STATUS);
                oidList.add(Oid.WIFI_BRIDGE_MODE);
                oidList.add(Oid.WIFI_AP_WDS_MODE);
                oidList.add(Oid.WIFI_MODE);
                if (!WlgConfig.this.targetProduct.canUdap()) {
                    oidList.add(Oid.IP_ADDRESS);
                    oidList.add(Oid.SUBNET_MASK);
                    oidList.add(Oid.GATEWAY);
                    oidList.add(Oid.DHCP_STATE);
                }
                Main.snmpmanager.getSnmpString(WlgConfig.this.targetProduct, oidList);
                Object object = WlgConfig.this.updateConfigThreadToken;
                synchronized (object) {
                    WlgConfig.this.updateConfigThread = null;
                }
            }
            WlgConfig.this.targetProduct.checkForDisplayChanges();
        }
    };

    public WlgConfig(Product target) {
        this.targetProduct = target;
    }

    @Override
    public void getConfig(final List<Oid> idList) {
        if (this.targetProduct.snmpVersion != 0) {
            new Thread(){

                @Override
                public void run() {
                    this.setName("getConfig " + WlgConfig.this.targetProduct.toString());
                    Main.snmpmanager.getSnmpString(WlgConfig.this.targetProduct, idList);
                }
            }.start();
        }
    }

    @Override
    public int setConfig(List<Parameter> paramList, char[] password) {
        if (password != null && this.targetProduct.canUdap()) {
            boolean isConfigIp = true;
            for (Parameter param : paramList) {
                Oid oid = param.getId();
                switch (oid) {
                    case RESET: 
                    case DHCP_STATE: 
                    case IP_ADDRESS: 
                    case SUBNET_MASK: 
                    case GATEWAY: {
                        break;
                    }
                    default: {
                        isConfigIp = false;
                    }
                }
            }
            if (isConfigIp) {
                return this.setUdapConfig(password);
            }
        }
        if (this.targetProduct.snmpVersion != 0) {
            ArrayList<Oid> oidList = new ArrayList<Oid>();
            boolean mustReset = false;
            for (Parameter param : paramList) {
                Oid oid = param.getId();
                if (oid == Oid.RESET) {
                    mustReset = true;
                    continue;
                }
                oidList.add(oid);
            }
            if (mustReset) {
                oidList.add(Oid.RESET);
            }
            return Main.snmpmanager.setSnmpString(this.targetProduct, oidList);
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void idenUdapProduct(int timeout) {
        boolean setConfigOk = false;
        int compt_timeout = 0;
        String macAddress = this.targetProduct.getUniqueIdString();
        UdapSocket udap = new UdapSocket(macAddress);
        Object token = udap.getToken();
        this.targetProduct.is_respond = false;
        TimeoutThread timeOut1 = new TimeoutThread(token, 1000);
        timeOut1.setName("WLg-setConfig-tmo1 " + this.targetProduct.toString());
        timeOut1.start();
        Object object = token;
        synchronized (object) {
            udap.startReception(10);
            udap.setIdent_udap(macAddress, timeout);
            try {
                token.wait();
                while (true) {
                    if (!udap.IsEmpty()) {
                        UdapResponse response = udap.getResponse();
                        if (response == null) {
                            setConfigOk = false;
                        } else {
                            if (response.getMethod() != 10) continue;
                            setConfigOk = true;
                            this.targetProduct.is_respond = true;
                            continue;
                        }
                    }
                    if (compt_timeout < 3) {
                        ++compt_timeout;
                    } else {
                        setConfigOk = true;
                        this.targetProduct.is_respond = false;
                    }
                    if (setConfigOk) break;
                }
                timeOut1.stopTimeout();
            }
            catch (InterruptedException e1) {
                System.out.println("catch");
            }
        }
        udap.terminateReception(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int setUdapConfig(char[] password) {
        Object token;
        UdapSocket udap;
        int dhcpState;
        String gateway;
        String subnetMask;
        String ipAddress;
        String macAddress;
        UdapResponse response;
        int configOk;
        block31: {
            boolean setConfigOk = false;
            configOk = 2;
            response = null;
            macAddress = this.targetProduct.getUniqueIdString();
            ipAddress = (String)this.targetProduct.getParam(Oid.IP_ADDRESS).getNewValue();
            subnetMask = (String)this.targetProduct.getParam(Oid.SUBNET_MASK).getNewValue();
            gateway = (String)this.targetProduct.getParam(Oid.GATEWAY).getNewValue();
            try {
                dhcpState = (Integer)this.targetProduct.getParam(Oid.DHCP_STATE).getNewValue();
            }
            catch (Exception e) {
                dhcpState = -1;
            }
            if (ipAddress == null) {
                ipAddress = (String)this.targetProduct.getParam(Oid.IP_ADDRESS).getValue();
            }
            if (subnetMask == null) {
                subnetMask = (String)this.targetProduct.getParam(Oid.SUBNET_MASK).getValue();
            }
            if (gateway == null) {
                gateway = (String)this.targetProduct.getParam(Oid.GATEWAY).getValue();
            }
            if (dhcpState < 0) {
                dhcpState = (Integer)this.targetProduct.getParam(Oid.DHCP_STATE).getValue();
            }
            if (ipAddress == null || subnetMask == null || gateway == null || dhcpState < 0) {
                return 2;
            }
            udap = new UdapSocket(macAddress);
            token = udap.getToken();
            TimeoutThread timeOut1 = new TimeoutThread(token, 3000);
            timeOut1.setName("WLg-setConfig-tmo1 " + this.targetProduct.toString());
            timeOut1.start();
            Object object = token;
            synchronized (object) {
                udap.startReception(3);
                udap.setConfig(macAddress, ipAddress, subnetMask, gateway, dhcpState, null, null);
                try {}
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    break block31;
                }
                block17: do {
                    token.wait();
                    do {
                        if ((response = udap.getResponse()) == null) {
                            setConfigOk = true;
                            continue block17;
                        }
                        if (3 != response.getMethod()) continue;
                        SetResponse setResp = (SetResponse)response;
                        switch (setResp.getErrorCode()) {
                            case -1: 
                            case 0: {
                                setConfigOk = true;
                                break;
                            }
                            case 1: {
                                timeOut1.stopTimeout();
                                udap.terminateReception(3);
                                return 1;
                            }
                            case 2: {
                                udap.setConfig(macAddress, ipAddress, subnetMask, gateway, dhcpState, setResp.getHashCode(), password);
                                break;
                            }
                        }
                    } while (!udap.IsEmpty());
                } while (!setConfigOk);
                timeOut1.stopTimeout();
                Thread.sleep(15000L);
            }
        }
        udap.terminateReception(3);
        udap.startReception(2);
        configOk = 3;
        int timeoutRetry = 10;
        while (timeoutRetry > 0) {
            TimeoutThread timeOut2 = new TimeoutThread(token, 2000);
            timeOut2.setName("tmo2 " + this.targetProduct.toString());
            timeOut2.start();
            Object object = token;
            synchronized (object) {
                udap.getConfig(macAddress);
                try {
                    token.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!udap.IsEmpty() && (response = udap.getResponse()) != null) {
                    GetResponse getResponse = (GetResponse)response;
                    if (getResponse.getDhcpEnabled() == dhcpState && dhcpState == 2) {
                        String new_ipAddress = getResponse.getIpAddress();
                        if (!new_ipAddress.equals(ipAddress)) {
                            this.targetProduct.setParam(new Parameter(Oid.IP_ADDRESS, new_ipAddress));
                        }
                        configOk = 0;
                        timeOut2.stopTimeout();
                        break;
                    }
                    if (getResponse.getIpAddress().equals(ipAddress) && getResponse.getSubnetMask().equals(subnetMask) && getResponse.getGateway().equals(gateway)) {
                        configOk = 0;
                        timeOut2.stopTimeout();
                        break;
                    }
                }
            }
            --timeoutRetry;
        }
        udap.terminateReception(2);
        return configOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfig() {
        Object object = this.updateConfigThreadToken;
        synchronized (object) {
            if (this.updateConfigThread == null) {
                this.updateConfigThread = new Thread(this.updateConfigCode);
                this.updateConfigThread.setName("WLgConfigUpdate " + this.targetProduct);
                this.updateConfigThread.start();
            }
        }
    }

    @Override
    public int getConfigurationTime() {
        return 35000;
    }
}

