/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product.upgrade;

import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.upgrade.MD5Encoder;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import org.apache.commons.net.tftp.TFTPClient;

public class WlgUpgradeThread
extends Thread {
    private char[] pwd;
    private String file;
    private Product product;
    private JProgressBar progress;
    private TFTPClient tftp = new TFTPClient();
    private JTextArea logArea;
    public static final int TFTP_DIRECT = 0;
    public static final int WLG_PASSWORD = 1;

    public WlgUpgradeThread(String file, char[] pwd, Product product, JProgressBar progress, JTextArea logArea) {
        this.pwd = pwd;
        this.file = file;
        this.product = product;
        this.progress = progress;
        this.logArea = logArea;
    }

    public int getCurrentPacket() {
        return this.tftp.getCurrentPacket();
    }

    @Override
    public void run() {
        if (this.file.equals("")) {
            JOptionPane.showMessageDialog(null, TranslateEnum.UPGRADE_NO_FIRMWARE.get(), TranslateEnum.ERROR.get(), 0);
            return;
        }
        this.progress.setStringPainted(true);
        this.progress.setString(TranslateEnum.STARTING.get());
        if (this.product.tftpActivationMethod == 1 && this.product.parameters.getPositiveValue(Oid.PRODUCT_CODE) != 0) {
            char[] fullStr = new char[this.pwd.length + 1];
            int i = 0;
            while (i < this.pwd.length) {
                fullStr[i] = this.pwd[i];
                ++i;
            }
            fullStr[this.pwd.length] = 84;
            String pwdMd5 = MD5Encoder.encode(fullStr);
            try {
                URL urlEnableTftp = new URL("http://" + this.product.getParam(Oid.IP_ADDRESS).getValue() + "/tftp_enable.cgi?pwd=" + pwdMd5.toUpperCase());
                urlEnableTftp.openStream();
            }
            catch (ConnectException e) {
                this.logArea.append(String.valueOf(TranslateEnum.UPGRADE_ERROR_ON_PRODUCT.get()) + this.product.getUniqueIdString() + " : " + TranslateEnum.UNREACHABLE.get() + "\r\n");
            }
            catch (IOException e) {
                this.logArea.append(String.valueOf(TranslateEnum.UPGRADE_ERROR_ON_PRODUCT.get()) + this.product.getUniqueIdString() + " : " + e.getLocalizedMessage() + "\r\n");
            }
        }
        try {
            File firm = new File(this.file);
            int size = (int)firm.length();
            this.progress.setMaximum(size / 512);
            FileInputStream firmware = new FileInputStream(this.file);
            this.tftp.open();
            this.progress.setString(TranslateEnum.TRANSFERING.get());
            this.tftp.sendFile("/", 1, (InputStream)firmware, InetAddress.getByName((String)this.product.getParam(Oid.IP_ADDRESS).getValue()));
            firmware.close();
            this.tftp.close();
            this.progress.setString(TranslateEnum.TRANSFERT_OK.get());
            this.logArea.append(String.valueOf(TranslateEnum.UPGRADE_OK.get()) + " : " + this.product.getUniqueIdString() + "\r\n");
            this.product.clearTTL();
        }
        catch (FileNotFoundException e) {
            this.progress.setString(TranslateEnum.TRANSFERT_ERROR.get());
            this.logArea.append(String.valueOf(TranslateEnum.UPGRADE_ERROR_ON_PRODUCT.get()) + this.product.getUniqueIdString() + " : " + TranslateEnum.UPGRADE_NO_FILE.get() + "\r\n");
        }
        catch (IOException e) {
            this.progress.setString(TranslateEnum.TRANSFERT_ERROR.get());
            String msg = e.getMessage().equals("Connection timed out.") ? TranslateEnum.UPGRADE_TIMEOUT.get() : e.getLocalizedMessage();
            this.logArea.append(String.valueOf(TranslateEnum.UPGRADE_ERROR_ON_PRODUCT.get()) + this.product.getUniqueIdString() + " : " + msg + "\r\n");
        }
    }
}

