/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.profiles;

import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ig.IpComparator;
import fr.acksys.snmp.Oid;

public class ProfileCriterion {
    private Parameter parameter;
    private String displayValue;
    public int comparator;
    public static final int COL_OID = 0;
    public static final int COL_STR = 1;
    public static final int COL_CMP = 2;
    public static final int COL_VAL = 3;
    public static final int CMP_MV = 0;
    public static final int CMP_LT = 1;
    public static final int CMP_LE = 2;
    public static final int CMP_EQ = 3;
    public static final int CMP_GE = 4;
    public static final int CMP_GT = 5;
    public static final int CMP_NE = 6;
    public static final int CMP_CT = 7;
    public static final int CMP_NC = 8;
    static final String[] cmpStrings;
    static final String[] cmpIpStrings;
    static final String[] cmpInts;
    static final String[] cmpEnums;
    static final int cmpCount = 9;

    static {
        String[] stringArray = new String[9];
        stringArray[3] = "=";
        stringArray[4] = "begins with";
        stringArray[6] = "\u2260";
        stringArray[7] = "containing";
        stringArray[8] = "not containing";
        cmpStrings = stringArray;
        String[] stringArray2 = new String[9];
        stringArray2[1] = "<";
        stringArray2[2] = "\u2264";
        stringArray2[3] = "=";
        stringArray2[4] = "\u2265";
        stringArray2[5] = ">";
        stringArray2[6] = "\u2260";
        stringArray2[7] = "containing";
        stringArray2[8] = "not containing";
        cmpIpStrings = stringArray2;
        String[] stringArray3 = new String[9];
        stringArray3[1] = "<";
        stringArray3[2] = "\u2264";
        stringArray3[3] = "=";
        stringArray3[4] = "\u2265";
        stringArray3[5] = ">";
        stringArray3[6] = "\u2260";
        cmpInts = stringArray3;
        String[] stringArray4 = new String[9];
        stringArray4[3] = "=";
        stringArray4[6] = "\u2260";
        cmpEnums = stringArray4;
    }

    private void setOidAndValues(Oid argOid, String argValue) {
        this.parameter = new Parameter(argOid, argValue);
        this.displayValue = argOid.convertValueFromInternalToDisplay(argValue);
    }

    public ProfileCriterion(Oid argOid, String argValue) {
        this.setOidAndValues(argOid, argValue);
        this.comparator = 0;
    }

    public ProfileCriterion(Oid argOid, String argComp, String argValue) {
        this.setOidAndValues(argOid, argValue);
        this.comparator = ProfileCriterion.toCmpCode(argOid, argComp);
    }

    public ProfileCriterion(Oid argOid, int argComp, String argValue) {
        this.setOidAndValues(argOid, argValue);
        this.comparator = argComp;
    }

    public void update(Oid argOid, String argComp, String argValue) {
        this.setOidAndValues(argOid, argValue);
        assert (this.comparator != 0);
        this.comparator = ProfileCriterion.toCmpCode(argOid, argComp);
    }

    public void update(Oid argOid, String argValue) {
        this.setOidAndValues(argOid, argValue);
        assert (this.comparator == 0);
    }

    public boolean isComparator() {
        return this.comparator != 0;
    }

    public static int toCmpCode(Oid oid, String s) {
        String[] cmplist = ProfileCriterion.getAllowedCriterions(oid);
        int i = 0;
        while (i < 9) {
            if (s.equals(cmplist[i])) {
                return i;
            }
            ++i;
        }
        assert (false);
        return -1;
    }

    public static String toCmpString(Oid oid, int i) {
        return ProfileCriterion.getAllowedCriterions(oid)[i];
    }

    public String getCmpString() {
        return ProfileCriterion.getAllowedCriterions(this.parameter.getId())[this.comparator];
    }

    public String toString() {
        return "[" + (Object)((Object)this.parameter.getId()) + " " + this.getCmpString() + " " + this.displayValue + "]";
    }

    public static String[] getAllowedCriterions(Oid oid) {
        switch (oid.getType()) {
            case INTEGER: 
            case GAUGE32: 
            case TIMETICKS: {
                return oid.getEnumLabels() == null ? cmpInts : cmpEnums;
            }
            case IP_ADDRESS: {
                return cmpIpStrings;
            }
        }
        return cmpStrings;
    }

    public Oid getOid() {
        return this.parameter.getId();
    }

    public Object getValue() {
        return this.parameter.getValue();
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public boolean compare(Object value) {
        if (value == null) {
            return false;
        }
        Oid oid = this.parameter.getId();
        switch (oid.getType()) {
            case INTEGER: 
            case GAUGE32: {
                return this.compareInteger((Integer)value);
            }
            case TIMETICKS: {
                return this.compareLong((Long)value);
            }
            case IP_ADDRESS: {
                return this.compareIpString((String)value);
            }
        }
        return this.compareString((String)value);
    }

    boolean compareInteger(int number) {
        switch (this.comparator) {
            case 3: {
                return number == (Integer)this.parameter.getValue();
            }
            case 6: {
                return number != (Integer)this.parameter.getValue();
            }
            case 1: {
                return number < (Integer)this.parameter.getValue();
            }
            case 2: {
                return number <= (Integer)this.parameter.getValue();
            }
            case 5: {
                return number > (Integer)this.parameter.getValue();
            }
            case 4: {
                return number >= (Integer)this.parameter.getValue();
            }
        }
        return false;
    }

    boolean compareLong(long number) {
        switch (this.comparator) {
            case 3: {
                return number == (Long)this.parameter.getValue();
            }
            case 6: {
                return number != (Long)this.parameter.getValue();
            }
            case 1: {
                return number < (Long)this.parameter.getValue();
            }
            case 2: {
                return number <= (Long)this.parameter.getValue();
            }
            case 5: {
                return number > (Long)this.parameter.getValue();
            }
            case 4: {
                return number >= (Long)this.parameter.getValue();
            }
        }
        return false;
    }

    boolean compareString(String string) {
        switch (this.comparator) {
            case 3: {
                return string.equals((String)this.parameter.getValue());
            }
            case 6: {
                return !string.equals((String)this.parameter.getValue());
            }
            default: {
                return false;
            }
            case 4: {
                return string.startsWith((String)this.parameter.getValue());
            }
            case 7: {
                return string.contains((String)this.parameter.getValue());
            }
            case 8: 
        }
        return !string.contains((String)this.parameter.getValue());
    }

    boolean compareIpString(String string) {
        IpComparator ipCmp = new IpComparator();
        switch (this.comparator) {
            case 3: {
                return ipCmp.compare(string, (String)this.parameter.getValue()) == 0;
            }
            case 6: {
                return ipCmp.compare(string, (String)this.parameter.getValue()) != 0;
            }
            case 1: {
                return ipCmp.compare(string, (String)this.parameter.getValue()) < 0;
            }
            case 2: {
                return ipCmp.compare(string, (String)this.parameter.getValue()) <= 0;
            }
            case 5: {
                return ipCmp.compare(string, (String)this.parameter.getValue()) > 0;
            }
            case 4: {
                return ipCmp.compare(string, (String)this.parameter.getValue()) >= 0;
            }
            case 7: {
                return string.contains((String)this.parameter.getValue());
            }
            case 8: {
                return !string.contains((String)this.parameter.getValue());
            }
        }
        return false;
    }
}

