/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.profiles;

import fr.acksys.custom.Company;
import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.NdmDb;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.CenterRenderer;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.ndm.ig.ParamTableModel;
import fr.acksys.ndm.ig.RememberableDialog;
import fr.acksys.ndm.product.OpenWrtProduct;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.profiles.ProfileCriterion;
import fr.acksys.ndm.profiles.ProfileTableModel;
import fr.acksys.ndm.profiles.SaveProfileDialog;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class ProfileDialog
extends JDialog {
    private static final long serialVersionUID = -5382620721590688572L;
    private static final boolean debugSelect = false;
    private static final boolean debugCriteres = false;
    private static final boolean debugValeurs = false;
    private static final boolean debugSaveDelete = false;
    private ProfileDialog owner = this;
    private List<ProfileCriterion> listSel = new ArrayList<ProfileCriterion>();
    private List<ProfileCriterion> listVal = new ArrayList<ProfileCriterion>();
    final LinkedList<Product> selectedProductsList = new LinkedList();
    private TitledBorder selectedProductsCaption = new TitledBorder("");
    private static String profileName = "";
    private boolean hasChanged = false;
    private JComboBox pfList = new JComboBox();
    private JTable tableSel = new JTable(new ProfileTableModel(this.listSel, 0));
    private JTable tableVal = new JTable(new ProfileTableModel(this.listVal, 1));
    private ParamTableModel paramModel = null;
    private JButton clrSel = new JButton(TranslateEnum.PFSEL_CLR.get());
    private JButton addSel = new JButton(TranslateEnum.PFSEL_ADD.get());
    private JButton delSel = new JButton(TranslateEnum.PFSEL_DEL.get());
    private final JComboBox oidSel = new JComboBox();
    private final JComboBox cmpSel = new JComboBox();
    private final JComboBox valSel = new JComboBox();
    private Oid[] knownSelOidsList = new Oid[]{Oid.SYSLOCATION, Oid.IP_ADDRESS, Oid.WIFI_MODE, Oid.WIFI_BRIDGE_MODE, Oid.WIFI_802, Oid.WIFI_SSID, Oid.WIFI_AP_CHANNEL, Oid.WIFI_SECURITY, Oid.WPA_VERSION, Oid.WIFI_BRIDGE_MAC_AP, Oid.WIFI_BRIDGE_STATUS, Oid.WIFI_BRIDGE_RSSI, Oid.WIFI_BRIDGE_RSSI_dBm, Oid.WIFI_AP_CLIENTS, Oid.WIFI_AP_WDS_MODE, Oid.SYSDESCR, Oid.FIRMWARE_VERSION, Oid.SUBNET_MASK, Oid.GATEWAY, Oid.DHCP_STATE};
    private JButton clrVal = new JButton(TranslateEnum.PFVAL_CLR.get());
    private JButton addVal = new JButton(TranslateEnum.PFVAL_ADD.get());
    private JButton delVal = new JButton(TranslateEnum.PFVAL_DEL.get());
    private final JComboBox oidVal = new JComboBox();
    private final JComboBox valVal = new JComboBox();
    private Oid[] knownValOidsList = new Oid[]{Oid.WIFI_MODE, Oid.WIFI_BRIDGE_MODE, Oid.WIFI_802, Oid.WIFI_SSID, Oid.WIFI_AP_AUTO_CHANNEL, Oid.WIFI_AP_CHANNEL, Oid.SYSLOCATION, Oid.DHCP_STATE, Oid.SUBNET_MASK, Oid.GATEWAY, Oid.IP_ADDRESS, Oid.WIFI_SECURITY, Oid.WPA_VERSION, Oid.WPA_CIPHER, Oid.WPA_UPDATE_INTERVAL, Oid.WPA_PSK, Oid.WPA_RADIUS_TIMEOUT, Oid.WPA_RADIUS_IP, Oid.WPA_RADIUS_PORT, Oid.WPA_RADIUS_SECRET, Oid.WIFI_AP_WDS_MODE, Oid.WEP_KEYLEN, Oid.WEP_KEY_TO_USE, Oid.WEP_KEY1, Oid.WEP_KEY2, Oid.WEP_KEY3, Oid.WEP_KEY4, Oid.WIFI_TXPOWER, Oid.WIFI_REGION, Oid.WIFI_ANTENNA, Oid.WIFI_TXRATE, Oid.WIFI_AP_VISIBLE, Oid.WIFI_BRIDGE_CHANLIST, Oid.RESET_FACTORY, Oid.RESET};
    private JCheckBox wantResetCheckbox = new JCheckBox(TranslateEnum.PF_WANT_RESET.get());
    private boolean originalWantReset;
    private JButton saveButton = new JButton(TranslateEnum.PFBTN_SAVEAS.get());
    private JButton applyButton = new JButton(TranslateEnum.PFBTN_APPLY.get());
    private JButton deleteButton = new JButton(TranslateEnum.PFBTN_DELETE.get());
    private JButton cancelButton = new JButton(TranslateEnum.CANCEL.get());
    private ActionListener onProfileSelect = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent a) {
            Object selection = ProfileDialog.this.pfList.getSelectedItem();
            if (selection == null) {
                return;
            }
            profileName = selection.toString();
            ProfileDialog.this.hasChanged = false;
            NdmDb db = NdmDb.getInstance();
            String nom = profileName.replace("'", "''");
            try {
                int pf_code;
                ResultSet query;
                ProfileTableModel model = (ProfileTableModel)ProfileDialog.this.tableSel.getModel();
                NdmDb ndmDb = db;
                synchronized (ndmDb) {
                    query = db.st.executeQuery("select pf_code,pf_reset from profiles where pf_name = '" + nom + "';");
                    if (!query.next()) {
                        throw new SQLException();
                    }
                    pf_code = query.getInt(1);
                    ProfileDialog.this.originalWantReset = query.getInt(2) == 1;
                    ProfileDialog.this.wantResetCheckbox.setSelected(ProfileDialog.this.originalWantReset);
                    query = db.st.executeQuery("select oid_str,pfc_comp,pfc_val from oids,pf_crits  where pfc_profile = " + pf_code + " and oid_code=pfc_oid;");
                    model.clearAll();
                    while (query.next()) {
                        ProfileCriterion crit = new ProfileCriterion(Oid.getOidByOidString(query.getString(1)), query.getInt(2), query.getString(3));
                        model.insert(crit);
                    }
                }
                ndmDb = db;
                synchronized (ndmDb) {
                    query = db.st.executeQuery("select oid_str,pfv_val from oids,pf_vals  where pfv_profile = " + pf_code + " and oid_code=pfv_oid " + "order by pfv_index;");
                    model = (ProfileTableModel)ProfileDialog.this.tableVal.getModel();
                    model.clearAll();
                    while (query.next()) {
                        Oid oid = Oid.getOidByOidString(query.getString(1));
                        String value = query.getString(2);
                        ProfileCriterion crit = new ProfileCriterion(oid, value);
                        model.insert(crit);
                    }
                    query.close();
                }
                ProfileDialog.this.buildUpdateMatchingProductsList();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    };
    private ActionListener onProfileSave = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveProfileDialog dlg = new SaveProfileDialog(ProfileDialog.this.owner, profileName);
            dlg.setVisible(true);
        }
    };
    private ActionListener onWindowCancel = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ProfileDialog.this.owner.closeChecks();
        }
    };
    private ActionListener onProfileApply = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            List productsList = ProfileDialog.this.buildUpdateMatchingProductsList();
            for (Product product : productsList) {
                boolean isAlive;
                boolean bl = isAlive = product.getTTL() > 0;
                if (!isAlive) continue;
                if (product.getClass() == OpenWrtProduct.class) {
                    System.out.println("DONTAPPLY (WLn- series not yet supported): " + product);
                    continue;
                }
                if (ProductManager.getInstance().hasConflictingIp(product)) continue;
                for (ProfileCriterion assign : ProfileDialog.this.listVal) {
                    System.out.println("APPLY '" + (Object)((Object)assign.getOid()) + "' to " + product);
                    product.updateParam(assign.getOid(), assign.getValue());
                }
                if (ProfileDialog.this.wantResetCheckbox.isSelected()) {
                    product.updateParam(Oid.RESET, 1);
                }
                product.configure(null);
            }
        }
    };
    private ActionListener onProfileDelete = new ActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent a) {
            if (ProfileDialog.this.pfList.getSelectedIndex() == 0) {
                new RememberableDialog(TranslateEnum.PF_DELTEMPLATE.get(), TranslateEnum.PF_DELTITLE).setVisible(true);
                return;
            }
            Object[] args = new Object[]{profileName};
            if (JOptionPane.showConfirmDialog(ProfileDialog.this.owner, new MessageFormat(TranslateEnum.PF_DELCONFIRM.get()).format(args), TranslateEnum.PF_DELTITLE.get(), 0, 2) == 0) {
                NdmDb db = NdmDb.getInstance();
                boolean canLoadList = false;
                NdmDb ndmDb = db;
                synchronized (ndmDb) {
                    try {
                        ResultSet query = db.st.executeQuery("select pf_code from profiles where pf_name = '" + profileName + "';");
                        if (query.next()) {
                            int pf_code = query.getInt(1);
                            db.begin();
                            db.st.execute("delete from pf_crits where pfc_profile=" + pf_code + ";");
                            db.st.execute("delete from pf_vals where pfv_profile=" + pf_code + ";");
                            db.st.execute("delete from profiles where pf_code=" + pf_code + ";");
                            db.commit();
                            canLoadList = true;
                            profileName = "";
                        }
                        query.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        db.rollback();
                    }
                    if (canLoadList) {
                        ProfileDialog.this.loadList(ProfileDialog.this.pfList);
                    }
                }
            }
        }
    };
    productDistance productComparator = new productDistance();

    public ProfileDialog(Frame owner) {
        Oid oid;
        this.setModal(true);
        IgUtils.SetIconImage(this);
        this.setTitle(TranslateEnum.PF_CAPTION_MULTIEDIT.get());
        Oid[] oidArray = this.knownSelOidsList;
        int n = this.knownSelOidsList.length;
        int n2 = 0;
        while (n2 < n) {
            oid = oidArray[n2];
            this.oidSel.addItem(oid.getShortDescription());
            ++n2;
        }
        this.updateCmpAndValComponents(this.knownSelOidsList, this.oidSel, this.valSel, this.cmpSel);
        this.oidSel.addActionListener(this.onChangeOid(this.knownSelOidsList, this.oidSel, this.valSel, this.cmpSel));
        oidArray = this.knownValOidsList;
        n = this.knownValOidsList.length;
        n2 = 0;
        while (n2 < n) {
            oid = oidArray[n2];
            this.oidVal.addItem(oid.getShortDescription());
            ++n2;
        }
        this.updateCmpAndValComponents(this.knownValOidsList, this.oidVal, this.valVal, null);
        this.oidVal.addActionListener(this.onChangeOid(this.knownValOidsList, this.oidVal, this.valVal, null));
        this.add(this.setupDialogGridbagLayout());
        this.addSel.addActionListener(this.onAddSel(this.tableSel));
        this.delSel.addActionListener(this.onDelete(this.tableSel));
        this.clrSel.addActionListener(this.onClearAll(this.tableSel));
        this.addVal.addActionListener(this.onAddVal(this.tableVal));
        this.delVal.addActionListener(this.onDelete(this.tableVal));
        this.clrVal.addActionListener(this.onClearAll(this.tableVal));
        this.pfList.addActionListener(this.onProfileSelect);
        this.saveButton.addActionListener(this.onProfileSave);
        this.applyButton.addActionListener(this.onProfileApply);
        this.deleteButton.addActionListener(this.onProfileDelete);
        this.cancelButton.addActionListener(this.onWindowCancel);
        this.loadList(this.pfList);
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.pack();
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
        this.addWindowListener(this.onClose());
        this.buildUpdateMatchingProductsList();
    }

    private JPanel setupDialogGridbagLayout() {
        GridBagConstraints cAreaTable = new GridBagConstraints();
        cAreaTable.gridx = 0;
        cAreaTable.gridy = 0;
        cAreaTable.fill = 1;
        cAreaTable.insets = new Insets(3, 5, 0, 5);
        GridBagConstraints cAreaButtons = new GridBagConstraints();
        cAreaButtons.gridx = 0;
        cAreaButtons.gridy = 1;
        cAreaButtons.insets = new Insets(3, 5, 0, 5);
        GridBagConstraints cAreaReset = new GridBagConstraints();
        cAreaReset.gridx = 0;
        cAreaReset.gridy = 2;
        cAreaReset.insets = new Insets(3, 5, 0, 5);
        JPanel pfListBox = new JPanel();
        this.pfList.setPreferredSize(new Dimension(200, 20));
        pfListBox.add(new JLabel(TranslateEnum.DISPLAY_PROFILE.get()));
        pfListBox.add(this.pfList);
        JScrollPane selScrollPane = this.makeTable(this.tableSel);
        JPanel selButtons = this.makeAddDeleteClear(this.oidSel, this.cmpSel, this.valSel, this.addSel, this.delSel, this.clrSel);
        this.oidSel.setPreferredSize(new Dimension(200, 20));
        this.valSel.setPreferredSize(new Dimension(200, 20));
        JPanel selPanel = new JPanel(new GridBagLayout());
        selPanel.setBorder(new TitledBorder(TranslateEnum.PFSEL_CAPTION.get()));
        selPanel.add((Component)selScrollPane, cAreaTable);
        selPanel.add((Component)selButtons, cAreaButtons);
        JScrollPane valScrollPane = this.makeTable(this.tableVal);
        JPanel valButtons = this.makeAddDeleteClear(this.oidVal, null, this.valVal, this.addVal, this.delVal, this.clrVal);
        this.oidVal.setPreferredSize(new Dimension(200, 20));
        this.valVal.setPreferredSize(new Dimension(200, 20));
        JPanel valPanel = new JPanel(new GridBagLayout());
        valPanel.setBorder(new TitledBorder(TranslateEnum.PFVAL_CAPTION.get()));
        valPanel.add((Component)valScrollPane, cAreaTable);
        valPanel.add((Component)this.wantResetCheckbox, cAreaReset);
        valPanel.add((Component)valButtons, cAreaButtons);
        JScrollPane selectedScrollPane = this.makeSelectedTable();
        JPanel selectedPanel = new JPanel(new GridBagLayout());
        selectedPanel.setBorder(this.selectedProductsCaption);
        selectedPanel.add((Component)selectedScrollPane, cAreaTable);
        JPanel prfPanel = new JPanel();
        prfPanel.add(this.applyButton);
        prfPanel.add(this.saveButton);
        prfPanel.add(this.deleteButton);
        prfPanel.add(this.cancelButton);
        JPanel all = new JPanel(new GridBagLayout());
        GridBagConstraints cSelected = new GridBagConstraints();
        GridBagConstraints cCentered = new GridBagConstraints();
        cSelected.gridx = 0;
        cSelected.gridy = -1;
        cSelected.weightx = 0.1;
        cSelected.gridheight = 0;
        cSelected.fill = 1;
        cSelected.insets = new Insets(5, 0, 5, 0);
        cCentered.gridx = 0;
        cCentered.gridy = -1;
        cCentered.weightx = 0.7;
        cCentered.fill = 1;
        cCentered.anchor = 10;
        cCentered.insets = new Insets(5, 5, 5, 5);
        all.add((Component)pfListBox, cCentered);
        all.add((Component)selPanel, cCentered);
        all.add((Component)valPanel, cCentered);
        all.add((Component)prfPanel, cCentered);
        all.add((Component)selectedPanel, cCentered);
        pfListBox.setOpaque(false);
        selPanel.setOpaque(false);
        valPanel.setOpaque(false);
        prfPanel.setOpaque(false);
        selectedPanel.setOpaque(false);
        this.pfList.setOpaque(false);
        this.wantResetCheckbox.setOpaque(false);
        all.setOpaque(false);
        return all;
    }

    public JScrollPane makeTable(JTable table) {
        table.setPreferredScrollableViewportSize(new Dimension(650, 60));
        table.setDefaultRenderer(Object.class, new CenterRenderer());
        table.setFillsViewportHeight(true);
        table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBorder(new BevelBorder(1));
        return scrollPane;
    }

    public JScrollPane makeSelectedTable() {
        this.paramModel = new ParamTableModel(new ArrayList<Product>());
        JTable table = new JTable(this.paramModel);
        table.setPreferredScrollableViewportSize(new Dimension(650, 80));
        table.setDefaultRenderer(Object.class, new SelectedRenderer());
        table.setFillsViewportHeight(true);
        table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBorder(new BevelBorder(1));
        return scrollPane;
    }

    private JPanel makeAddDeleteClear(JComboBox oidCombo, JComboBox cmpCombo, JComboBox valCombo, JButton add, JButton del, JButton clr) {
        this.cancelButton.addActionListener(ListenerFactory.getCancelDialoglListener(this));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(oidCombo);
        if (cmpCombo != null) {
            buttonPanel.add(cmpCombo);
        }
        buttonPanel.add(valCombo);
        buttonPanel.add(add);
        buttonPanel.add(del);
        buttonPanel.add(clr);
        oidCombo.setPreferredSize(new Dimension(200, 20));
        valCombo.setPreferredSize(new Dimension(200, 20));
        buttonPanel.setOpaque(false);
        return buttonPanel;
    }

    public static void colle(JComponent interieur, JComponent exterieur, boolean north, boolean south, boolean west, boolean east) {
        SpringLayout layout = (SpringLayout)exterieur.getLayout();
        if (west) {
            layout.putConstraint("West", (Component)interieur, 5, "West", (Component)exterieur);
        }
        if (east) {
            layout.putConstraint("East", (Component)interieur, -5, "East", (Component)exterieur);
        }
        if (north) {
            layout.putConstraint("North", (Component)interieur, 5, "North", (Component)exterieur);
        }
        if (south) {
            layout.putConstraint("South", (Component)interieur, -5, "South", (Component)exterieur);
        }
    }

    public static void alignUnder(JComponent whatToAlign, JComponent underWhat, int howMuch, int hAlignSize) {
        JComponent parent = (JComponent)underWhat.getParent();
        SpringLayout layout = (SpringLayout)parent.getLayout();
        parent.add(whatToAlign);
        layout.putConstraint("Baseline", (Component)whatToAlign, howMuch, "South", (Component)underWhat);
        if (hAlignSize > 0) {
            int prec = parent.getComponentCount() - 2;
            layout.putConstraint("West", (Component)whatToAlign, hAlignSize, "East", parent.getComponent(prec));
        } else if (hAlignSize < 0) {
            layout.putConstraint("West", (Component)whatToAlign, -hAlignSize, "West", (Component)parent);
        }
    }

    private void updateCmpAndValComponents(Oid[] knownOids, JComboBox oidCombo, JComboBox valCombo, JComboBox cmpCombo) {
        Oid selected = knownOids[oidCombo.getSelectedIndex()];
        LinkedList<String> legalValues = selected.getEnumLabels();
        valCombo.removeAllItems();
        if (legalValues != null) {
            valCombo.setEditable(false);
            for (String s : legalValues) {
                valCombo.addItem(s);
            }
        } else {
            valCombo.setEditable(true);
        }
        if (cmpCombo != null) {
            cmpCombo.removeAllItems();
            String[] stringArray = ProfileCriterion.getAllowedCriterions(selected);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s;
                s = stringArray[n2];
                if (s != null) {
                    cmpCombo.addItem(s);
                }
                ++n2;
            }
        }
        this.pack();
    }

    private String readValComponent(Oid selected, JComboBox valCombo) {
        String internalValue = selected.convertValueFromInputToInternal(valCombo.getSelectedIndex(), valCombo.getSelectedItem(), valCombo == this.valSel);
        if (internalValue == null) {
            RememberableDialog remember = new RememberableDialog(TranslateEnum.PF_BAD_VALUE.get(), TranslateEnum.ERROR);
            remember.setVisible(true);
        }
        return internalValue;
    }

    private int readCmpComponent(Oid selected, JComboBox cmpCombo) {
        String[] legalValues = ProfileCriterion.getAllowedCriterions(selected);
        int selIndex = cmpCombo.getSelectedIndex();
        int i = 0;
        String[] stringArray = legalValues;
        int n = legalValues.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                if (i == selIndex) {
                    return i;
                }
            } else {
                ++selIndex;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    private ActionListener onChangeOid(final Oid[] knownOids, final JComboBox oidCombo, final JComboBox valCombo, final JComboBox cmpCombo) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileDialog.this.updateCmpAndValComponents(knownOids, oidCombo, valCombo, cmpCombo);
            }
        };
    }

    private ActionListener onAddSel(JTable table) {
        return new ActionListener(table){
            ProfileTableModel model;
            {
                this.model = (ProfileTableModel)jTable.getModel();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Oid oid = ProfileDialog.this.knownSelOidsList[ProfileDialog.this.oidSel.getSelectedIndex()];
                String value = ProfileDialog.this.readValComponent(oid, ProfileDialog.this.valSel);
                if (value == null) {
                    return;
                }
                ProfileCriterion crit = new ProfileCriterion(oid, ProfileDialog.this.readCmpComponent(oid, ProfileDialog.this.cmpSel), value);
                this.model.insert(crit);
                ProfileDialog.this.hasChanged = true;
                ProfileDialog.this.buildUpdateMatchingProductsList();
            }
        };
    }

    private ActionListener onAddVal(JTable table) {
        return new ActionListener(table){
            ProfileTableModel model;
            {
                this.model = (ProfileTableModel)jTable.getModel();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String value;
                Oid oid = ProfileDialog.this.knownValOidsList[ProfileDialog.this.oidVal.getSelectedIndex()];
                if (oid == Oid.WIFI_MODE) {
                    if (ProfileDialog.this.listVal.size() != 0) {
                        JOptionPane.showMessageDialog(ProfileDialog.this.owner, TranslateEnum.PF_ROLE_PARAM_CONFLICT.get(), TranslateEnum.ERROR.get(), 0);
                        return;
                    }
                } else {
                    for (ProfileCriterion pc : ProfileDialog.this.listVal) {
                        if (pc.getOid() != Oid.WIFI_MODE) continue;
                        JOptionPane.showMessageDialog(ProfileDialog.this.owner, TranslateEnum.PF_ROLE_PARAM_CONFLICT.get(), TranslateEnum.ERROR.get(), 0);
                        return;
                    }
                }
                if ((value = ProfileDialog.this.readValComponent(oid, ProfileDialog.this.valVal)) == null) {
                    return;
                }
                ProfileCriterion crit = new ProfileCriterion(oid, value);
                this.model.insert(crit);
                ProfileDialog.this.hasChanged = true;
            }
        };
    }

    private ActionListener onDelete(final JTable table) {
        return new ActionListener(){
            ProfileTableModel model;
            {
                this.model = (ProfileTableModel)jTable.getModel();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.getSelectedRow();
                if (row >= 0) {
                    this.model.delete(row);
                    ProfileDialog.this.hasChanged = true;
                    if (table == ProfileDialog.this.tableSel) {
                        ProfileDialog.this.buildUpdateMatchingProductsList();
                    }
                }
            }
        };
    }

    private ActionListener onClearAll(final JTable table) {
        return new ActionListener(){
            ProfileTableModel model;
            {
                this.model = (ProfileTableModel)jTable.getModel();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.model.clearAll();
                ProfileDialog.this.hasChanged = true;
                if (table == ProfileDialog.this.tableSel) {
                    ProfileDialog.this.buildUpdateMatchingProductsList();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmProfileSave(String nom) {
        NdmDb db = NdmDb.getInstance();
        if (nom.equals(this.pfList.getItemAt(0))) {
            return false;
        }
        String nomSql = nom.replace("'", "''");
        boolean inserting = false;
        boolean canLoadList = false;
        NdmDb ndmDb = db;
        synchronized (ndmDb) {
            block13: {
                try {
                    int pf_code;
                    ResultSet query = db.st.executeQuery("select pf_code from profiles where pf_name = '" + nomSql + "';");
                    boolean pf_reset = this.wantResetCheckbox.isSelected();
                    if (!query.next()) {
                        db.st.execute(String.format("insert into profiles (pf_code,pf_name,pf_reset) values(null,'%s',%d);", nomSql, pf_reset ? 1 : 0));
                        query = db.st.executeQuery("select pf_code from profiles where pf_name = '" + nomSql + "';");
                        pf_code = query.getInt(1);
                    } else {
                        pf_code = query.getInt(1);
                        db.st.execute(String.format("update profiles set pf_reset=%d where pf_code=%d;", pf_reset ? 1 : 0, pf_code));
                    }
                    this.originalWantReset = pf_reset;
                    db.begin();
                    db.st.execute("delete from pf_crits where pfc_profile=" + pf_code + ";");
                    db.st.execute("delete from pf_vals where pfv_profile=" + pf_code + ";");
                    PreparedStatement prep = db.prepare("insert into pf_crits (pfc_profile,pfc_group,pfc_oid,pfc_comp,pfc_val) values (" + pf_code + ",0,(select oid_code from oids where oid_str=?),?,?);");
                    for (ProfileCriterion p : this.listSel) {
                        prep.setString(1, p.getOid().getOid());
                        prep.setInt(2, p.comparator);
                        prep.setString(3, p.getValue().toString());
                        prep.addBatch();
                    }
                    inserting = true;
                    prep.executeBatch();
                    inserting = false;
                    prep = db.prepare("insert into pf_vals (pfv_profile,pfv_index,pfv_oid,pfv_val) values (" + pf_code + ",?,(select oid_code from oids where oid_str=?),?);");
                    int pfv_index = 0;
                    for (ProfileCriterion p : this.listVal) {
                        prep.setInt(1, pfv_index++);
                        prep.setString(2, p.getOid().getOid());
                        prep.setString(3, p.getValue().toString());
                        prep.addBatch();
                    }
                    inserting = true;
                    prep.executeBatch();
                    inserting = false;
                    db.commit();
                    profileName = nom;
                    canLoadList = true;
                    query.close();
                    this.hasChanged = false;
                }
                catch (SQLException e) {
                    db.rollback();
                    if (inserting) break block13;
                    e.printStackTrace();
                }
            }
        }
        if (inserting) {
            JOptionPane.showConfirmDialog(this, TranslateEnum.PF_SAVEDUPS.get(), TranslateEnum.ERROR.get(), 0, 0);
        } else if (canLoadList) {
            this.loadList(this.pfList);
        }
        return true;
    }

    private void closeChecks() {
        if (this.hasChanged || this.wantResetCheckbox.isSelected() != this.originalWantReset) {
            SaveProfileDialog dlg = new SaveProfileDialog(this, profileName);
            dlg.setVisible(true);
        }
        this.dispose();
    }

    public WindowListener onClose() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProfileDialog.this.owner.closeChecks();
            }
        };
    }

    private List<Product> buildUpdateMatchingProductsList() {
        this.selectedProductsList.clear();
        ProductManager pm = ProductManager.getInstance();
        pm.iterateManagedProductsInGUIThread(new NdmCallback(){

            @Override
            public void callback(Object ob) {
                Product product = (Product)ob;
                boolean matchall = true;
                for (ProfileCriterion crit : ProfileDialog.this.listSel) {
                    Oid oid;
                    if (crit.compare(product.getParam(oid = crit.getOid()).getValue())) continue;
                    matchall = false;
                    break;
                }
                if (matchall) {
                    ProfileDialog.this.selectedProductsList.add(product);
                }
            }
        });
        int unreachable = 0;
        int conflict = 0;
        for (Product product : this.selectedProductsList) {
            if (product.getTTL() <= 0) {
                ++unreachable;
                continue;
            }
            if (!pm.hasConflictingIp(product)) continue;
            ++conflict;
        }
        int selected = this.selectedProductsList.size();
        int filteredOut = pm.sizeProduct() - selected;
        int useable = selected - unreachable - conflict;
        String summary = String.format(TranslateEnum.PF_SELECTED_INFO.get(), filteredOut, selected, useable, unreachable, conflict);
        Collections.sort(this.selectedProductsList, this.productComparator);
        this.paramModel.changeProductsList(this.selectedProductsList);
        this.selectedProductsCaption.setTitle(summary);
        this.repaint();
        return this.selectedProductsList;
    }

    private void loadList(JComboBox combo) {
        combo.removeActionListener(this.onProfileSelect);
        combo.removeAllItems();
        this.originalWantReset = false;
        List<String> profilesList = NdmDb.getProfilesList();
        if (profilesList.size() < 1) {
            NdmDb.Fatal(TranslateEnum.DB_NEWTEMPLATE);
        }
        for (String s : profilesList) {
            combo.addItem(s);
        }
        combo.addActionListener(this.onProfileSelect);
        if (profileName.isEmpty()) {
            profileName = profilesList.get(0);
        }
        combo.setSelectedItem(profileName);
    }

    private static void dumpOidsList(String string, Oid[] oidsList) {
        System.out.println(string);
        Oid[] oidArray = oidsList;
        int n = oidsList.length;
        int n2 = 0;
        while (n2 < n) {
            Oid oid = oidArray[n2];
            System.out.print(String.valueOf(oid.getShortDescription()) + ": ");
            String sep = "\t\t";
            LinkedList<String> legalValues = oid.getEnumLabels();
            if (legalValues != null) {
                for (String s : legalValues) {
                    System.out.print(String.valueOf(sep) + s);
                    sep = ", ";
                }
                System.out.println();
            } else {
                System.out.println(String.valueOf(sep) + "<string>");
            }
            ++n2;
        }
    }

    public static void main() {
        ImageManager.initMapImage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfileDialog j = new ProfileDialog(null);
                Oid.getOidByOidString("");
                j.setVisible(true);
            }
        });
    }

    private class SelectedRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 2655300188749227424L;

        public SelectedRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int viewRow, int column) {
            int modelRow = table.convertRowIndexToModel(viewRow);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, viewRow, column);
            Product product = ProfileDialog.this.selectedProductsList.get(modelRow);
            if (product.getTTL() <= 0) {
                if (isSelected) {
                    this.setBackground(UserParameters.deadProductSelectedBgColor);
                } else {
                    this.setBackground(UserParameters.deadProductUnselectedBgColor);
                }
            } else if (product.getClass() == OpenWrtProduct.class) {
                if (isSelected) {
                    this.setBackground(UserParameters.deadProductSelectedBgColor);
                } else {
                    this.setBackground(UserParameters.deadProductUnselectedBgColor);
                }
            } else if (ProductManager.getInstance().hasConflictingIp(product)) {
                this.setFont(UserParameters.ipConflictFont);
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(UserParameters.ipConflictSelectedFgColor);
                } else {
                    this.setBackground(UserParameters.ipConflictUnselectedBgColor);
                    this.setForeground(UserParameters.ipConflictUnselectedFgColor);
                }
            } else if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            return this;
        }
    }

    class productDistance
    implements Comparator<Product> {
        productDistance() {
        }

        @Override
        public int compare(Product one, Product two) {
            int oneDistance = one.getTTL() == 0 ? -1 : one.getDistance();
            int twoDistance = two.getTTL() == 0 ? -1 : two.getDistance();
            return twoDistance - oneDistance;
        }
    }
}

