/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.profiles;

import fr.acksys.ndm.profiles.ProfileCriterion;
import fr.acksys.translation.TranslateEnum;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ProfileTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4114070749967955446L;
    private List<ProfileCriterion> list;
    private int tableType;
    static final int TABLE_SEL = 0;
    static final int TABLE_VAL = 1;

    public ProfileTableModel(List<ProfileCriterion> list, int tableType) {
        this.list = list;
        this.tableType = tableType;
    }

    public void insert(ProfileCriterion crit) {
        this.list.add(crit);
        int index = this.list.indexOf(crit);
        this.fireTableRowsInserted(index, index);
    }

    public void delete(int index) {
        this.list.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void clearAll() {
        int len = this.list.size();
        if (len > 0) {
            this.fireTableRowsDeleted(0, len - 1);
        }
        this.list.clear();
    }

    @Override
    public int getColumnCount() {
        return this.tableType == 0 ? 3 : 2;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ProfileCriterion crit = this.list.get(rowIndex);
        if (this.tableType == 0) {
            switch (columnIndex) {
                case 0: {
                    return crit.getOid().getShortDescription();
                }
                case 1: {
                    return crit.getCmpString();
                }
                case 2: {
                    return crit.getDisplayValue();
                }
            }
        } else {
            switch (columnIndex) {
                case 0: {
                    return crit.getOid().getShortDescription();
                }
                case 1: {
                    return crit.getDisplayValue();
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.tableType == 0) {
            switch (columnIndex) {
                case 0: {
                    return TranslateEnum.PFCOL_STR.get();
                }
                case 1: {
                    return TranslateEnum.PFCOL_CMP.get();
                }
                case 2: {
                    return TranslateEnum.PFCOL_VAL.get();
                }
            }
        } else {
            switch (columnIndex) {
                case 0: {
                    return TranslateEnum.PFCOL_STR.get();
                }
                case 1: {
                    return TranslateEnum.PFCOL_VAL.get();
                }
            }
        }
        return "";
    }

    public ProfileCriterion getSelectedItem(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.list.size()) {
            return this.list.get(rowIndex);
        }
        return null;
    }
}

