/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.profiles;

import fr.acksys.custom.Company;
import fr.acksys.ndm.NdmDb;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.ndm.profiles.ProfileDialog;
import fr.acksys.translation.TranslateEnum;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class SaveProfileDialog
extends JDialog {
    private static final long serialVersionUID = 9021890141549362186L;
    private final JLabel nameLabel = new JLabel(TranslateEnum.PF_NAME.get());
    private final JComboBox nom = new JComboBox();
    private JButton applyButton = new JButton(TranslateEnum.SAVE_BTN.get());
    private JButton cancelButton = new JButton(TranslateEnum.CANCEL.get());
    private ProfileDialog owner;

    SaveProfileDialog(ProfileDialog owner, String profileName) {
        this.owner = owner;
        Container pane = this.getContentPane();
        this.setModal(true);
        IgUtils.SetIconImage(this);
        this.setTitle(TranslateEnum.PF_CAPTION_MULTIEDIT_SAVE.get());
        SpringLayout hlayout = new SpringLayout();
        JPanel hpane = new JPanel(hlayout);
        hpane.add(this.nameLabel);
        this.nom.setPreferredSize(new Dimension(200, 20));
        for (String s : NdmDb.getProfilesList()) {
            this.nom.addItem(s);
            if (!s.equals(profileName)) continue;
            this.nom.setSelectedItem(s);
        }
        this.nom.setEditable(true);
        hpane.add(this.nom);
        hlayout.putConstraint("West", (Component)this.nameLabel, 0, "West", (Component)hpane);
        hlayout.putConstraint("West", (Component)this.nom, 10, "East", (Component)this.nameLabel);
        hlayout.putConstraint("Baseline", (Component)this.nom, 25, "North", (Component)hpane);
        hlayout.putConstraint("Baseline", (Component)this.nameLabel, 25, "North", (Component)hpane);
        hlayout.putConstraint("South", (Component)hpane, 0, "South", (Component)this.nom);
        hlayout.putConstraint("East", (Component)hpane, 0, "East", (Component)this.nom);
        this.applyButton.addActionListener(this.onSave());
        this.cancelButton.addActionListener(ListenerFactory.getCancelDialoglListener(this));
        SpringLayout layout = new SpringLayout();
        pane.setLayout(layout);
        this.add(hpane);
        ProfileDialog.colle(hpane, (JPanel)pane, true, false, true, true);
        ProfileDialog.alignUnder(this.applyButton, hpane, 30, 0);
        layout.putConstraint("East", (Component)this.applyButton, 10, "HorizontalCenter", (Component)hpane);
        ProfileDialog.alignUnder(this.cancelButton, hpane, 30, 10);
        layout.putConstraint("South", (Component)pane, 10, "South", (Component)this.cancelButton);
        hpane.setOpaque(false);
        pane.setBackground(Company.BACK_COLOR);
        this.pack();
        this.setSize(new Dimension(400, 120));
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
        this.addWindowListener(this.onClose());
    }

    private ActionListener onSave() {
        final SaveProfileDialog dlg = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName;
                Object selectedItem = SaveProfileDialog.this.nom.getSelectedItem();
                String string = newName = selectedItem == null ? "" : selectedItem.toString();
                if (SaveProfileDialog.this.owner.confirmProfileSave(newName)) {
                    dlg.dispose();
                }
            }
        };
    }

    public WindowListener onClose() {
        final SaveProfileDialog owner = this;
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                owner.dispose();
            }
        };
    }

    public static void main(String[] args) {
        ImageManager.initMapImage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveProfileDialog j = new SaveProfileDialog(null, "totoprofil");
                j.setVisible(true);
            }
        });
    }
}

