/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.rssi;

import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.product.Product;
import fr.acksys.rssi.Data;
import fr.acksys.rssi.TraceDialog;
import fr.acksys.snmp.Oid;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import sun.awt.Mutex;

public class RSSIProductData {
    private static final Mutex refreshLock = new Mutex();
    static int val_RSSI;
    static int val_RSSI_db;
    static String val_SSID;
    static String val_BSSID;
    static String Adress_MAC;
    static String val_location;
    public static Data[] data_1s;
    private static final int wlanSsidIndex;
    private static final int assocQualityIndex;
    private static final int assocBssidIndex;
    private static final int assocBeaconSigIndex;
    private static ProductManager pm;

    static {
        val_location = "";
        wlanSsidIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_SSID);
        assocQualityIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_QUALITY);
        assocBssidIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_BSSID);
        assocBeaconSigIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_BEACON_SIGNAL);
        pm = ProductManager.getInstance();
    }

    public static void refreshRssiProductList(List<Product> SelectedproductList) {
        data_1s = new Data[TraceDialog.total_client];
        refreshLock.lock();
        int cnt_client = 0;
        int cnt_pro = 0;
        while (cnt_pro < SelectedproductList.size()) {
            Product Spr = SelectedproductList.get(cnt_pro);
            ArrayList<Oid> paramsList = new ArrayList();
            paramsList = Arrays.asList(Oid.WIFI_BRIDGE_RSSI, Oid.WIFI_BRIDGE_RSSI_dBm, Oid.WIFI_SSID, Oid.WIFI_BRIDGE_MAC_AP);
            Spr.refreshState(paramsList);
            Date date = new Date();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = df.format(date);
            if (Spr.canMultifunction) {
                int cnt_role_1wln = 0;
                while (cnt_role_1wln < Spr.getmaxWlans()) {
                    if (Spr.getClientFlag()[cnt_role_1wln]) {
                        val_BSSID = (String)Spr.parameters.get(Oid.ASSOC_TABLE).getParameterValue(assocBssidIndex).getValue(cnt_role_1wln);
                        val_RSSI = TraceDialog.isRSSI_dBm ? (val_BSSID.equals("00:00:00:00:00:00") ? -100 : (Integer)Spr.parameters.get(Oid.ASSOC_TABLE).getParameterValue(assocBeaconSigIndex).getValue(cnt_role_1wln)) : (Integer)Spr.parameters.get(Oid.ASSOC_TABLE).getParameterValue(assocQualityIndex).getValue(cnt_role_1wln);
                        val_SSID = (String)Spr.parameters.get(Oid.WLAN_TABLE).getParameterValue(wlanSsidIndex).getValue(cnt_role_1wln);
                        val_location = "";
                        pm.iterateManagedProductsInGUIThread(new NdmCallback(){

                            @Override
                            public void callback(Object ob) {
                                Product product = (Product)ob;
                                String macAddress = product.getUniqueIdString();
                                if (macAddress.equalsIgnoreCase(val_BSSID)) {
                                    val_location = product.toDisplayMac();
                                }
                            }
                        });
                        Adress_MAC = Spr.getUniqueIdString();
                        RSSIProductData.data_1s[cnt_client] = new Data(val_RSSI, val_SSID, val_BSSID, Adress_MAC, val_location);
                        if (!TraceDialog.pastext && Spr.is_snmprespond) {
                            try {
                                TraceDialog.out.write(String.valueOf(time) + "\t" + Adress_MAC + "\t" + val_RSSI + "\t" + val_BSSID + "\t" + val_SSID);
                                TraceDialog.out.newLine();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        ++cnt_client;
                    }
                    ++cnt_role_1wln;
                }
            } else {
                val_RSSI = TraceDialog.isRSSI_dBm ? Spr.parameters.getIntegerValue(Oid.WIFI_BRIDGE_RSSI_dBm) : Spr.parameters.getIntegerValue(Oid.WIFI_BRIDGE_RSSI);
                val_SSID = Spr.parameters.getStringValue(Oid.WIFI_SSID);
                val_BSSID = Spr.parameters.getStringValue(Oid.WIFI_BRIDGE_MAC_AP);
                Adress_MAC = Spr.parameters.getStringValue(Oid.GENERIC_PRODUCT_ID);
                val_location = "";
                pm.iterateManagedProductsInGUIThread(new NdmCallback(){

                    @Override
                    public void callback(Object ob) {
                        Product product = (Product)ob;
                        String macAddress = product.getUniqueIdString();
                        if (macAddress.equalsIgnoreCase(val_BSSID)) {
                            val_location = product.toDisplayMac();
                        }
                    }
                });
                RSSIProductData.data_1s[cnt_client] = new Data(val_RSSI, val_SSID, val_BSSID, Adress_MAC, val_location);
                if (!TraceDialog.pastext && Spr.is_snmprespond) {
                    try {
                        TraceDialog.out.write(String.valueOf(time) + "\t" + Adress_MAC + "\t" + val_RSSI + "\t" + val_BSSID + "\t" + val_SSID);
                        TraceDialog.out.newLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++cnt_client;
            }
            ++cnt_pro;
        }
        refreshLock.unlock();
    }
}

