/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.rssi;

import fr.acksys.ndm.product.Product;
import fr.acksys.rssi.Bssid_colr;
import fr.acksys.rssi.RSSIProductData;
import fr.acksys.rssi.TraceDialog;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.EmptyBlock;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;

public class TraceThread
extends Thread {
    private final int MAXWAIT = 3000;
    private boolean continu;
    public int delay;
    private int maxWait;
    private int compt;
    private List<Product> selectedList;

    public TraceThread(int delay, List<Product> selectedList) {
        this.selectedList = selectedList;
        this.setDelay(delay);
    }

    @Override
    public void run() {
        while (this.continu) {
            try {
                int i = 0;
                while (i <= this.compt) {
                    Thread.sleep(this.maxWait);
                    ++i;
                }
                Thread.sleep(this.delay);
                Runnable TraceRssiRunable = new Runnable(){

                    @Override
                    public void run() {
                        RSSIProductData.refreshRssiProductList(TraceThread.this.selectedList);
                    }
                };
                SwingUtilities.invokeLater(TraceRssiRunable);
                if (this.delay == 100) {
                    Thread.sleep(100L);
                } else {
                    Thread.sleep(1000L);
                }
                Runnable AffichageRunable = new Runnable(){

                    @Override
                    public void run() {
                        Millisecond millisecond = new Millisecond();
                        int cnt_client = 0;
                        int cnt_pro = 0;
                        while (cnt_pro < TraceThread.this.selectedList.size()) {
                            Product Spr = (Product)TraceThread.this.selectedList.get(cnt_pro);
                            if (Spr.canMultifunction) {
                                int cnt_clt_1wln = 0;
                                while (cnt_clt_1wln < Spr.getClientCount()) {
                                    String new_bssid = RSSIProductData.data_1s[cnt_pro + cnt_clt_1wln].val_BSSID;
                                    if (Spr.is_snmprespond) {
                                        TraceDialog.timeserie[cnt_client].add((RegularTimePeriod)millisecond, RSSIProductData.data_1s[cnt_pro + cnt_clt_1wln].val_RSSI);
                                        if (!TraceDialog.timeserie[cnt_client].isEmpty()) {
                                            TextTitle log = new TextTitle(String.valueOf(Spr.toDisplayMac()) + " (" + Spr.getUniqueIdString().toUpperCase() + ")  ||  SSID= " + RSSIProductData.data_1s[cnt_pro + cnt_clt_1wln].val_SSID + "  ||  BSSID= " + new_bssid + "  (client." + (cnt_clt_1wln + 1) + ")");
                                            if (new_bssid.equals("00:00:00:00:00:00")) {
                                                log = new TextTitle(String.valueOf(Spr.toDisplayMac()) + " (" + Spr.getUniqueIdString().toUpperCase() + ")  ||  SSID= " + RSSIProductData.data_1s[cnt_pro + cnt_clt_1wln].val_SSID + "  ||  Disconnected");
                                            }
                                            TraceDialog.les_charts[cnt_client].setTitle(log);
                                            TraceDialog.les_charts[cnt_client].getTitle().setBackgroundPaint(Color.YELLOW);
                                            if (!TraceDialog.old_BSSID[cnt_client].equals(new_bssid)) {
                                                Color handover_color = TraceDialog.createRandomColor();
                                                boolean is_list = false;
                                                ArrayList<Bssid_colr> bssid_list_un = TraceDialog.bssid_list_client.get(cnt_client);
                                                Iterator iterator = bssid_list_un.iterator();
                                                while (iterator.hasNext()) {
                                                    Bssid_colr val = (Bssid_colr)iterator.next();
                                                    if (!val.BSSID.equals(TraceDialog.old_BSSID[cnt_client])) continue;
                                                    handover_color = val.get_color(TraceDialog.old_BSSID[cnt_client]);
                                                    is_list = true;
                                                    break;
                                                }
                                                if (!is_list) {
                                                    if (TraceDialog.old_BSSID[cnt_client].equals("00:00:00:00:00:00")) {
                                                        handover_color = Color.RED;
                                                    }
                                                    bssid_list_un.add(new Bssid_colr(TraceDialog.old_BSSID[cnt_client], handover_color));
                                                    TraceDialog.bssid_list_client.set(cnt_client, bssid_list_un);
                                                }
                                                IntervalMarker mrk = new IntervalMarker(TraceDialog.currentTime[cnt_client], millisecond.getLastMillisecond(), handover_color);
                                                TraceDialog.currentTime[cnt_client] = millisecond.getLastMillisecond();
                                                TraceDialog.les_charts[cnt_client].getXYPlot().addDomainMarker(mrk, Layer.BACKGROUND);
                                                if (!is_list || bssid_list_un.size() == 1) {
                                                    TextTitle left = new TextTitle("BSSID : " + TraceDialog.old_BSSID[cnt_client]);
                                                    if (TraceDialog.old_BSSID[cnt_client].equals("00:00:00:00:00:00")) {
                                                        left.setText("BSSID disconnected          ");
                                                    }
                                                    TextTitle right = new TextTitle("                    ");
                                                    right.setBackgroundPaint(handover_color);
                                                    BorderArrangement arrangement = new BorderArrangement();
                                                    BlockContainer container = new BlockContainer(arrangement);
                                                    container.add(left, RectangleEdge.LEFT);
                                                    container.add(right, RectangleEdge.RIGHT);
                                                    container.add(new EmptyBlock(20.0, 1.0));
                                                    CompositeTitle main = new CompositeTitle(container);
                                                    main.setPosition(RectangleEdge.BOTTOM);
                                                    TraceDialog.les_charts[cnt_client].addSubtitle(main);
                                                }
                                                TraceDialog.old_BSSID[cnt_client] = new_bssid;
                                            }
                                        }
                                    } else {
                                        TraceDialog.timeserie[cnt_client].add((RegularTimePeriod)millisecond, null);
                                        TextTitle log_nosignal = new TextTitle(String.valueOf(Spr.toDisplayMac()) + " (" + Spr.getUniqueIdString().toUpperCase() + ") SNMP : Timeout");
                                        TraceDialog.les_charts[cnt_client].setTitle(log_nosignal);
                                        TraceDialog.les_charts[cnt_client].getTitle().setPaint(Color.gray);
                                    }
                                    ++cnt_client;
                                    ++cnt_clt_1wln;
                                }
                            } else {
                                if (Spr.is_snmprespond) {
                                    TraceDialog.timeserie[cnt_client].add((RegularTimePeriod)millisecond, RSSIProductData.data_1s[cnt_client].val_RSSI);
                                    if (!TraceDialog.timeserie[cnt_client].isEmpty()) {
                                        String new_bssid = RSSIProductData.data_1s[cnt_client].val_BSSID;
                                        if (!new_bssid.equals("00:00:00:00:00:00")) {
                                            TraceDialog.les_charts[cnt_client].setTitle(new TextTitle(String.valueOf(Spr.toDisplayMac()) + " (" + Spr.getUniqueIdString().toUpperCase() + ")  ||  SSID= " + RSSIProductData.data_1s[cnt_client].val_SSID + "  ||  BSSID= " + RSSIProductData.data_1s[cnt_client].location + " (" + new_bssid + ")"));
                                        } else {
                                            TraceDialog.les_charts[cnt_client].setTitle(new TextTitle(String.valueOf(Spr.toDisplayMac()) + " (" + Spr.getUniqueIdString().toUpperCase() + ")  ||  SSID= " + RSSIProductData.data_1s[cnt_client].val_SSID + "  ||  Disconnected"));
                                        }
                                        TraceDialog.les_charts[cnt_client].getTitle().setBackgroundPaint(Color.YELLOW);
                                        if (!TraceDialog.old_BSSID[cnt_client].equals(new_bssid)) {
                                            Color handover_color = TraceDialog.createRandomColor();
                                            boolean is_list = false;
                                            ArrayList<Bssid_colr> bssid_list_un = TraceDialog.bssid_list_client.get(cnt_client);
                                            for (Bssid_colr val : bssid_list_un) {
                                                if (!val.BSSID.equals(TraceDialog.old_BSSID[cnt_client])) continue;
                                                handover_color = val.get_color(TraceDialog.old_BSSID[cnt_client]);
                                                is_list = true;
                                                break;
                                            }
                                            if (!is_list) {
                                                if (TraceDialog.old_BSSID[cnt_client].equals("00:00:00:00:00:00")) {
                                                    handover_color = Color.RED;
                                                }
                                                bssid_list_un.add(new Bssid_colr(TraceDialog.old_BSSID[cnt_client], handover_color));
                                                TraceDialog.bssid_list_client.set(cnt_client, bssid_list_un);
                                            }
                                            IntervalMarker mrk = new IntervalMarker(TraceDialog.currentTime[cnt_client], millisecond.getLastMillisecond(), handover_color);
                                            TraceDialog.currentTime[cnt_client] = millisecond.getLastMillisecond();
                                            TraceDialog.les_charts[cnt_client].getXYPlot().addDomainMarker(mrk, Layer.BACKGROUND);
                                            if (!is_list || bssid_list_un.size() == 1) {
                                                TextTitle left = new TextTitle("BSSID : " + TraceDialog.old_BSSID[cnt_client]);
                                                if (TraceDialog.old_BSSID[cnt_client].equals("00:00:00:00:00:00")) {
                                                    left.setText("BSSID disconnected          ");
                                                }
                                                TextTitle right = new TextTitle("                    ");
                                                right.setBackgroundPaint(handover_color);
                                                BorderArrangement arrangement = new BorderArrangement();
                                                BlockContainer container = new BlockContainer(arrangement);
                                                container.add(left, RectangleEdge.LEFT);
                                                container.add(right, RectangleEdge.RIGHT);
                                                container.add(new EmptyBlock(20.0, 1.0));
                                                CompositeTitle main = new CompositeTitle(container);
                                                main.setPosition(RectangleEdge.BOTTOM);
                                                TraceDialog.les_charts[cnt_client].addSubtitle(main);
                                            }
                                            TraceDialog.old_BSSID[cnt_client] = new_bssid;
                                        }
                                    }
                                } else {
                                    TraceDialog.timeserie[cnt_client].add((RegularTimePeriod)millisecond, null);
                                    TextTitle log_nosignal = new TextTitle(String.valueOf(Spr.toDisplayMac()) + " (" + Spr.getUniqueIdString().toUpperCase() + ") SNMP : Timeout");
                                    TraceDialog.les_charts[cnt_client].setTitle(log_nosignal);
                                    TraceDialog.les_charts[cnt_client].getTitle().setPaint(Color.gray);
                                }
                                ++cnt_client;
                            }
                            ++cnt_pro;
                        }
                    }
                };
                SwingUtilities.invokeLater(AffichageRunable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException("Interrupted", e);
            }
        }
    }

    public void setDelay(int delay) {
        if (delay == 0) {
            this.continu = false;
            this.maxWait = 3000;
            this.compt = 0;
            this.delay = 0;
        } else if (delay == 100) {
            this.continu = true;
            this.maxWait = 0;
            this.compt = 0;
            this.delay = delay;
        } else {
            this.continu = true;
            if (delay - 1000 > 3000) {
                this.maxWait = 3000;
                this.compt = (delay - 1000) / 3000;
                this.delay = (delay - 1000) % 3000;
            } else {
                this.maxWait = 0;
                this.compt = 0;
                this.delay = delay - 1000;
            }
        }
    }
}

