/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.snmp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.UdpTransportMapping;
import org.snmp4j.util.WorkerTask;

public class DebuggedDefaultUdpTransportMapping
extends UdpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(DebuggedDefaultUdpTransportMapping.class);
    protected DatagramSocket socket = null;
    protected WorkerTask listener;
    protected ListenThread listenerThread;
    private int socketTimeout = 0;
    private int receiveBufferSize = 0;

    public DebuggedDefaultUdpTransportMapping() throws IOException {
        super(new UdpAddress(InetAddress.getLocalHost(), 0));
        this.socket = new DatagramSocket(this.udpAddress.getPort());
    }

    public DebuggedDefaultUdpTransportMapping(UdpAddress udpAddress, boolean reuseAddress) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(null);
        this.socket.setReuseAddress(reuseAddress);
        InetSocketAddress addr = new InetSocketAddress(udpAddress.getInetAddress(), udpAddress.getPort());
        this.socket.bind(addr);
    }

    public DebuggedDefaultUdpTransportMapping(UdpAddress udpAddress) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(udpAddress.getPort(), udpAddress.getInetAddress());
    }

    @Override
    public void sendMessage(UdpAddress targetAddress, byte[] message, TransportStateReference tmStateReference) throws IOException {
        InetSocketAddress targetSocketAddress = new InetSocketAddress(targetAddress.getInetAddress(), targetAddress.getPort());
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Sending message to " + targetAddress + " with length " + message.length + ": " + new OctetString(message).toHexString())));
        }
        DatagramSocket s = this.ensureSocket();
        s.send(new DatagramPacket(message, message.length, targetSocketAddress));
    }

    @Override
    public void close() throws IOException {
        DatagramSocket closingSocket;
        boolean interrupted = false;
        WorkerTask l = this.listener;
        if (l != null) {
            l.terminate();
            l.interrupt();
            if (this.socketTimeout > 0) {
                try {
                    l.join();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    logger.warn(ex);
                }
            }
            this.listener = null;
        }
        if ((closingSocket = this.socket) != null && !closingSocket.isClosed()) {
            closingSocket.close();
        }
        this.socket = null;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void listen() throws IOException {
        if (this.listener != null) {
            throw new SocketException("Port already listening");
        }
        this.ensureSocket();
        this.listenerThread = new ListenThread();
        this.listener = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultUDPTransportMapping_" + this.getAddress(), this.listenerThread, true);
        this.listener.run();
    }

    private synchronized DatagramSocket ensureSocket() throws SocketException {
        DatagramSocket s = this.socket;
        if (s == null) {
            s = new DatagramSocket(this.udpAddress.getPort());
            s.setSoTimeout(this.socketTimeout);
            this.socket = s;
        }
        return s;
    }

    public void setPriority(int newPriority) {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setPriority(newPriority);
        }
    }

    public int getPriority() {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getPriority();
        }
        return 5;
    }

    public void setThreadName(String name) {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setName(name);
        }
    }

    public String getThreadName() {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getName();
        }
        return null;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(socketTimeout);
            }
            catch (SocketException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public boolean isListening() {
        return this.listener != null;
    }

    protected DatagramSocket renewSocketAfterException(SocketException socketException, DatagramSocket failedSocket) throws SocketException {
        if (failedSocket != null && !failedSocket.isClosed()) {
            failedSocket.close();
        }
        DatagramSocket s = new DatagramSocket(this.udpAddress.getPort());
        s.setSoTimeout(this.socketTimeout);
        return s;
    }

    class ListenThread
    implements WorkerTask {
        private byte[] buf;
        private volatile boolean stop = false;

        public ListenThread() throws SocketException {
            this.buf = new byte[DebuggedDefaultUdpTransportMapping.this.getMaxInboundMessageSize()];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DatagramSocket socketCopy = DebuggedDefaultUdpTransportMapping.this.socket;
                if (socketCopy != null) {
                    try {
                        socketCopy.setSoTimeout(DebuggedDefaultUdpTransportMapping.this.getSocketTimeout());
                        if (DebuggedDefaultUdpTransportMapping.this.receiveBufferSize > 0) {
                            socketCopy.setReceiveBufferSize(Math.max(DebuggedDefaultUdpTransportMapping.this.receiveBufferSize, DebuggedDefaultUdpTransportMapping.this.maxInboundMessageSize));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("UDP receive buffer size for socket " + DebuggedDefaultUdpTransportMapping.this.getAddress() + " is set to: " + socketCopy.getReceiveBufferSize())));
                        }
                    }
                    catch (SocketException ex) {
                        logger.error(ex);
                        DebuggedDefaultUdpTransportMapping.this.setSocketTimeout(0);
                    }
                }
                while (!this.stop) {
                    Object stateReference;
                    DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length, DebuggedDefaultUdpTransportMapping.this.udpAddress.getInetAddress(), DebuggedDefaultUdpTransportMapping.this.udpAddress.getPort());
                    try {
                        ByteBuffer bis;
                        socketCopy = DebuggedDefaultUdpTransportMapping.this.socket;
                        try {
                            if (socketCopy == null) {
                                this.stop = true;
                                continue;
                            }
                            socketCopy.receive(packet);
                        }
                        catch (InterruptedIOException iiox) {
                            if (iiox.bytesTransferred <= 0) continue;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Received message from " + packet.getAddress() + "/" + packet.getPort() + " with length " + packet.getLength() + ": " + new OctetString(packet.getData(), 0, packet.getLength()).toHexString())));
                        }
                        if (DebuggedDefaultUdpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                            byte[] bytes = new byte[packet.getLength()];
                            System.arraycopy(packet.getData(), 0, bytes, 0, bytes.length);
                            bis = ByteBuffer.wrap(bytes);
                        } else {
                            bis = ByteBuffer.wrap(packet.getData());
                        }
                        stateReference = new TransportStateReference(DebuggedDefaultUdpTransportMapping.this, DebuggedDefaultUdpTransportMapping.this.udpAddress, null, SecurityLevel.undefined, SecurityLevel.undefined, false, socketCopy);
                        DebuggedDefaultUdpTransportMapping.this.fireProcessMessage(new UdpAddress(packet.getAddress(), packet.getPort()), bis, (TransportStateReference)stateReference);
                    }
                    catch (SocketTimeoutException bis) {
                    }
                    catch (PortUnreachableException purex) {
                        stateReference = DebuggedDefaultUdpTransportMapping.this;
                        synchronized (stateReference) {
                            DebuggedDefaultUdpTransportMapping.this.listener = null;
                        }
                        logger.error(purex);
                        if (logger.isDebugEnabled()) {
                            purex.printStackTrace();
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) break;
                        throw new RuntimeException(purex);
                    }
                    catch (SocketException soex) {
                        if (!this.stop) {
                            logger.warn((Serializable)((Object)("Socket for transport mapping " + this.toString() + " error: " + soex.getMessage())));
                        }
                        if (SNMP4JSettings.isForwardRuntimeExceptions()) {
                            this.stop = true;
                            throw new RuntimeException(soex);
                        }
                        try {
                            DatagramSocket newSocket = DebuggedDefaultUdpTransportMapping.this.renewSocketAfterException(soex, socketCopy);
                            if (newSocket == null) {
                                throw soex;
                            }
                            DebuggedDefaultUdpTransportMapping.this.socket = newSocket;
                        }
                        catch (SocketException e) {
                            this.stop = true;
                            DebuggedDefaultUdpTransportMapping.this.socket = null;
                            logger.error("Socket renewal for transport mapping " + this.toString() + " failed with: " + e.getMessage(), e);
                        }
                    }
                    catch (IOException iox) {
                        logger.warn(iox);
                        if (logger.isDebugEnabled()) {
                            iox.printStackTrace();
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(iox);
                    }
                }
                DebuggedDefaultUdpTransportMapping debuggedDefaultUdpTransportMapping = DebuggedDefaultUdpTransportMapping.this;
                synchronized (debuggedDefaultUdpTransportMapping) {
                    DebuggedDefaultUdpTransportMapping.this.listener = null;
                    this.stop = true;
                    DatagramSocket closingSocket = DebuggedDefaultUdpTransportMapping.this.socket;
                    if (closingSocket != null && !closingSocket.isClosed()) {
                        closingSocket.close();
                    }
                    DebuggedDefaultUdpTransportMapping.this.socket = null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Worker task stopped:" + this.getClass().getName())));
                }
            }
            catch (Exception ex) {
                System.out.println("whole try" + ex);
            }
        }

        public void close() {
            this.stop = true;
        }

        @Override
        public void terminate() {
            this.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Terminated worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void join() throws InterruptedException {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Joining worker task: " + this.getClass().getName())));
            }
        }

        @Override
        public void interrupt() {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Interrupting worker task: " + this.getClass().getName())));
            }
            this.close();
        }
    }
}

