/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.snmp;

import fr.acksys.ndm.NdmCallback;
import fr.acksys.translation.TranslateEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public enum Oid {
    CON_PANEL(Type.NOT_SNMP, "subtree", "subtree", ""),
    TRAY_PANEL(Type.INTEGER, "tooltip", "tooltip", ""),
    FIRMWARE_DESCRIPTION(Type.NOT_SNMP, "firmdesc", "Firmware description", ""),
    FIRMWARE_ID(Type.NOT_SNMP, "firmId", "Firmware id code", ""),
    FIRMWARE_VERSION(Type.NOT_SNMP, "firmvers", "Firmware version", ""),
    GENERIC_PRODUCT_ID(Type.NOT_SNMP, "pid", "Unique product identifier", ""),
    SYSDESCR(Type.DISPLAY_STRING, "1.3.6.1.2.1.1.1.0", "SNMP sysDescr", ""),
    SYSUPTIME(Type.TIMETICKS, "1.3.6.1.2.1.1.3.0", "SNMP sysUptime", ""),
    SYSLOCATION(Type.DISPLAY_STRING, "1.3.6.1.2.1.1.6.0", "Name/sysLocation", ""),
    MAC_ADDRESS(Type.PHYS_ADDRESS, "1.3.6.1.2.1.2.2.1.6.2", "MAC address", ""),
    MAC_ADDRESS_S(Type.PHYS_ADDRESS, "1.3.6.1.2.1.2.2.1.6.1", "MAC address", ""),
    MAC_TYPE(Type.INTEGER, "1.3.6.1.2.1.2.2.1.3.1", "RADIO/ETHERNET", ""),
    UNIQUE_ID(Type.PHYS_ADDRESS, "1.3.6.1.4.1.28097.2.1.0", "Product ID", "Unique product ID for NDM"),
    STATUS_CHANGES(Type.INTEGER, "1.3.6.1.4.1.28097.2.3.0", "Status changes bitmask", ""),
    WIFI_SSID(Type.DISPLAY_STRING, "1.3.6.1.4.1.28097.1.1.1.1.0", "Wi-Fi SSID", ""),
    WIFI_MODE(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.2.0", "Wi-Fi role", ""),
    WIFI_AP_CHANNEL(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.3.0", "Wi-Fi AP channel", ""),
    WIFI_802(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.4.0", "Wi-Fi subprotocol", ""),
    WIFI_TXPOWER(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.7.0", "Wi-Fi transmit power", ""),
    WIFI_REGION(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.8.0", "Wi-Fi region", ""),
    WIFI_ANTENNA(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.10.0", "Wi-Fi antenna", ""),
    WIFI_TXRATE(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.11.0", "Wi-Fi speed", ""),
    WIFI_SECURITY(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.1.0", "Wi-Fi Security scheme", ""),
    WEP_KEYLEN(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.2.1.0", "WEP key length", ""),
    WEP_KEY1(Type.OCTET_STRING, "1.3.6.1.4.1.28097.1.1.1.9.2.2.0", "WEP key 1", ""),
    WEP_KEY2(Type.OCTET_STRING, "1.3.6.1.4.1.28097.1.1.1.9.2.3.0", "WEP key 2", ""),
    WEP_KEY3(Type.OCTET_STRING, "1.3.6.1.4.1.28097.1.1.1.9.2.4.0", "WEP key 3", ""),
    WEP_KEY4(Type.OCTET_STRING, "1.3.6.1.4.1.28097.1.1.1.9.2.5.0", "WEP key 4", ""),
    WEP_KEY_TO_USE(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.2.6.0", "WEP key number", ""),
    WEP_KEY_SHARED(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.2.7.0", "AP open WEP key", ""),
    WPA_PSK(Type.DISPLAY_STRING, "1.3.6.1.4.1.28097.1.1.1.9.3.1.1.0", "WPA-PSK key", ""),
    WPA_RADIUS_TIMEOUT(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.3.2.1.0", "RADIUS timeout", ""),
    WPA_RADIUS_IP(Type.IP_ADDRESS, "1.3.6.1.4.1.28097.1.1.1.9.3.2.2.0", "RADIUS IP address", ""),
    WPA_RADIUS_PORT(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.3.2.3.0", "RADIUS port", ""),
    WPA_RADIUS_SECRET(Type.DISPLAY_STRING, "1.3.6.1.4.1.28097.1.1.1.9.3.2.4.0", "RADIUS secret key", ""),
    WPA_RADIUS_MAC(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.3.2.5.0", "RADIUS MAC authentication", ""),
    WPA_VERSION(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.3.4.0", "WPA version", ""),
    WPA_CIPHER(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.3.5.0", "WPA cipher", ""),
    WPA_UPDATE_INTERVAL(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.1.9.3.6.0", "Key update interval (s)", ""),
    WIFI_BRIDGE_MAC_AP(Type.PHYS_ADDRESS, "1.3.6.1.4.1.28097.1.1.2.2.0", "Associated access point", ""),
    WIFI_BRIDGE_STATUS(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.2.1.0", "Wi-Fi Connection status", ""),
    WIFI_BRIDGE_RSSI(Type.GAUGE32, "1.3.6.1.4.1.28097.1.1.2.5.0", "Wi-Fi Signal Level (%)", ""),
    WIFI_BRIDGE_RSSI_dBm(Type.GAUGE32, "1.3.6.1.4.1.28097.1.1.2.4.0", "Wi-Fi Signal Level (dBm)", ""),
    WIFI_BRIDGE_MODE(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.2.7.0", "Wi-Fi mode Infra/adhoc", ""),
    WIFI_BRIDGE_CHANLIST(Type.OCTET_STRING, "1.3.6.1.4.1.28097.1.1.2.10.0", "Wi-Fi scan channels list", ""),
    WIFI_AP_AUTO_CHANNEL(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.3.2.0", "Wi-Fi AP auto channel", ""),
    WIFI_AP_CLIENTS(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.3.3.0", "AP clients count", ""),
    WIFI_AP_WDS_MODE(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.3.5.1.0", "WDS (repeater) mode", ""),
    WIFI_AP_VISIBLE(Type.INTEGER, "1.3.6.1.4.1.28097.1.1.3.6.0", "SSID visibility", ""),
    RESET(Type.INTEGER, "1.3.6.1.4.1.28097.1.2.1.0", "Reset", ""),
    RESET_FACTORY(Type.INTEGER, "1.3.6.1.4.1.28097.1.2.2.0", "Reset factory settings", ""),
    DHCP_STATE(Type.INTEGER, "1.3.6.1.4.1.28097.1.5.1.0", "DHCP client", ""),
    IP_ADDRESS(Type.IP_ADDRESS, "1.3.6.1.4.1.28097.1.5.2.0", "IP address", ""),
    SUBNET_MASK(Type.IP_ADDRESS, "1.3.6.1.4.1.28097.1.5.3.0", "Subnet mask", ""),
    GATEWAY(Type.IP_ADDRESS, "1.3.6.1.4.1.28097.1.5.4.0", "Gateway", ""),
    PRODUCT_CODE(Type.INTEGER, "1.3.6.1.4.1.28097.3.0", "Product code", ""),
    WLAN_TABLE(Type.SEQUENCE, "Radio interfaces", "Radio interfaces", ""),
    WLAN_TABLE_INDEX(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.1", "Wlan index", ""),
    WLAN_TABLE_SSID(Type.DISPLAY_STRING, "1.3.6.1.4.1.28097.7.2.1.2", "SSID", ""),
    WLAN_TABLE_ROLE(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.3", "STA role", ""),
    WLAN_TABLE_BAND(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.4", "Radio band", ""),
    WLAN_TABLE_CHANNEL(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.5", "Radio channel", ""),
    WLAN_TABLE_FREQ(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.6", "Radio frequence", ""),
    WLAN_TABLE_ENABLE(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.7", "Wlan in use", ""),
    WLAN_TABLE_PHYINDEX(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.8", "Radio card", ""),
    WLAN_TABLE_SECURITY(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.9", "Security policy", ""),
    WLAN_TABLE_WPA(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.10", "WPA version", ""),
    WLAN_TABLE_NPEERS(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.11", "Clients count", ""),
    WLAN_TABLE_QUALITY(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.12", "Radio link quality indicator (%)", ""),
    WLAN_TABLE_BSSID(Type.PHYS_ADDRESS, "1.3.6.1.4.1.28097.7.2.1.13", "BSSID", ""),
    WLAN_TABLE_STATE(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.14", "Connection state", ""),
    WLAN_TABLE_BEACON_SIGNAL(Type.INTEGER, "1.3.6.1.4.1.28097.7.2.1.16", " Signal level of the last beacon received (dBm)", ""),
    ASSOC_TABLE(Type.SEQUENCE, "Association info", "Association info", ""),
    RADIO_TABLE(Type.SEQUENCE, "Radio devices", "Radio devices", ""),
    RADIO_TABLE_INDEX(Type.INTEGER, "1.3.6.1.4.1.28097.7.3.1.1", "Radio index", ""),
    RADIO_TABLE_NAME(Type.DISPLAY_STRING, "1.3.6.1.4.1.28097.7.3.1.2", "Friendly name", ""),
    RADIO_TABLE_ENABLE(Type.INTEGER, "1.3.6.1.4.1.28097.7.3.1.3", "Radio in use", ""),
    ASS_STA_TABLE(Type.SEQUENCE, "Association list", "Association list", ""),
    ASS_STA_TABLE_INDEX(Type.INTEGER, "1.3.6.1.4.1.28097.7.9.1.1", "Association index", ""),
    ASS_STA_TABLE_MAC(Type.PHYS_ADDRESS, "1.3.6.1.4.1.28097.7.9.1.2", "Association MAC", ""),
    ASS_STA_TABLE_SSID(Type.DISPLAY_STRING, "1.3.6.1.4.1.28097.7.9.1.3", "Association SSID", ""),
    ASS_STA_TABLE_BSSID(Type.PHYS_ADDRESS, "1.3.6.1.4.1.28097.7.9.1.4", "Association BSSID", ""),
    ASS_STA_TABLE_PHY(Type.DISPLAY_STRING, "1.3.6.1.4.1.28097.7.9.1.5", "Association Phy name", ""),
    ASS_STA_TABLE_RSSI(Type.INTEGER, "1.3.6.1.4.1.28097.7.9.1.6", "Association RSSI", ""),
    ASS_STA_TABLE_NOISE(Type.INTEGER, "1.3.6.1.4.1.28097.7.9.1.7", "Association noise", ""),
    ASS_STA_TABLE_SNR(Type.INTEGER, "1.3.6.1.4.1.28097.7.9.1.8", "Association SNR", ""),
    RADIO_PHY_TABLE_MAC(Type.PHYS_ADDRESS, "1.3.6.1.4.1.28097.8.2.1.1.4", "Radio phy mac", "");

    String oid;
    String shortDescription;
    String longDescription;
    Type type;
    String[] enumLabels = null;
    String[] enumValues = null;
    private static Map<String, Oid> oidsMap;

    static {
        oidsMap = null;
    }

    private Oid(Type argType, String argOid, String argShortDesc, String argLongDesc) {
        this.oid = argOid;
        this.shortDescription = argShortDesc;
        this.longDescription = argLongDesc;
        this.type = argType;
    }

    public void initEnums() {
        if (this.type == Type.INTEGER) {
            switch (this) {
                case WIFI_MODE: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "Station";
                    stringArray[2] = "Access point";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_802: {
                    String[] stringArray = new String[8];
                    stringArray[1] = "802.11B only";
                    stringArray[2] = "802.11G only";
                    stringArray[3] = "Mixed 802.11B/G";
                    stringArray[4] = "802.11A/H (5 GHz)";
                    stringArray[5] = "900 MHz DSS";
                    stringArray[6] = "900 MHz OFDM";
                    stringArray[7] = "900 MHz mixed DSS/OFDM";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_TXPOWER: {
                    String[] stringArray = new String[4];
                    stringArray[1] = "High";
                    stringArray[2] = "Medium";
                    stringArray[3] = "Low";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_REGION: {
                    String[] stringArray = new String[21];
                    stringArray[2] = "israel";
                    stringArray[4] = "usa";
                    stringArray[5] = "hong-kong";
                    stringArray[6] = "canada";
                    stringArray[7] = "australia";
                    stringArray[10] = "france outdoor";
                    stringArray[14] = "europe";
                    stringArray[17] = "japan";
                    stringArray[18] = "singapore";
                    stringArray[20] = "korea";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_ANTENNA: {
                    String[] stringArray = new String[4];
                    stringArray[1] = "Diversity";
                    stringArray[2] = "Main";
                    stringArray[3] = "Aux";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_TXRATE: {
                    this.enumLabels = new String[]{"Automatic", "54 [802.11a&g]", "48 [802.11a&g]", "36 [802.11a&g]", "24 [802.11a&g]", "18 [802.11a&g]", "12 [802.11a&g]", "9 [802.11a&g]", "6 [802.11a&g]", "108 [SuperAG]", "96 [SuperAG]", "72 [SuperAG]", "48 [SuperAG]", "36 [SuperAG]", "24 [SuperAG]", "18 [SuperAG]", "12 [SuperAG]", "11 [802.11b]", "5.5 [802.11b]", "2 [802.11b]", "1 [802.11b]"};
                    this.enumValues = new String[]{"0", "54", "48", "36", "24", "18", "12", "9", "6", "108", "96", "72", "48", "36", "24", "18", "12", "11", "5", "2", "1"};
                    break;
                }
                case WIFI_SECURITY: {
                    String[] stringArray = new String[5];
                    stringArray[1] = "None";
                    stringArray[2] = "WEP";
                    stringArray[3] = "WPA/WPA2-PSK";
                    stringArray[4] = "WPA/WPA2/RADIUS";
                    this.enumLabels = stringArray;
                    break;
                }
                case WPA_VERSION: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "WPA";
                    stringArray[2] = "WPA2";
                    this.enumLabels = stringArray;
                    break;
                }
                case WPA_CIPHER: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "TKIP";
                    stringArray[2] = "AES";
                    this.enumLabels = stringArray;
                    break;
                }
                case WPA_RADIUS_MAC: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "Disabled";
                    stringArray[2] = "Enabled";
                    this.enumLabels = stringArray;
                    break;
                }
                case WEP_KEYLEN: {
                    this.enumLabels = new String[]{"64", "128"};
                    this.enumValues = new String[]{"64", "128"};
                    break;
                }
                case WEP_KEY_TO_USE: {
                    this.enumLabels = new String[]{"1", "2", "3", "4"};
                    this.enumValues = new String[]{"1", "2", "3", "4"};
                    break;
                }
                case WEP_KEY_SHARED: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "open";
                    stringArray[2] = "shared";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_BRIDGE_STATUS: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "Up";
                    stringArray[2] = "Down";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_BRIDGE_MODE: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "Infrastructure";
                    stringArray[2] = "Ad-hoc";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_AP_WDS_MODE: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "Disabled";
                    stringArray[2] = "Enabled";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_AP_AUTO_CHANNEL: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "User defined";
                    stringArray[2] = "Automatic";
                    this.enumLabels = stringArray;
                    break;
                }
                case WIFI_AP_VISIBLE: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "Visible";
                    stringArray[2] = "Invisible";
                    this.enumLabels = stringArray;
                    break;
                }
                case RESET: {
                    this.enumLabels = new String[]{"No operation", "Reset"};
                    break;
                }
                case RESET_FACTORY: {
                    this.enumLabels = new String[]{"No operation", "Factory settings"};
                    break;
                }
                case DHCP_STATE: {
                    String[] stringArray = new String[3];
                    stringArray[1] = "Disabled/static IP";
                    stringArray[2] = "Enabled/dynamic IP";
                    this.enumLabels = stringArray;
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String toString() {
        return this.shortDescription;
    }

    public String getOid() {
        return this.oid;
    }

    public Type getType() {
        return this.type;
    }

    public LinkedList<String> getEnumLabels() {
        LinkedList<String> displayList = new LinkedList<String>();
        if (this.enumLabels == null) {
            return null;
        }
        String[] stringArray = this.enumLabels;
        int n = this.enumLabels.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                displayList.add(s);
            }
            ++n2;
        }
        return displayList;
    }

    public String convertValueFromInternalToDisplay(String argValue) {
        if (this.enumValues != null) {
            int i = 0;
            while (i < this.enumValues.length) {
                if (this.enumValues[i].equals(argValue)) {
                    return this.enumLabels[i];
                }
                ++i;
            }
            return TranslateEnum.PF_BAD_VALUE.get();
        }
        if (this.enumLabels == null) {
            return argValue;
        }
        return this.enumLabels[Integer.parseInt(argValue)];
    }

    public String convertValueFromInputToInternal(int externalIndex, Object externalItem, boolean isSelector) {
        if (this == WIFI_BRIDGE_CHANLIST) {
            String inputString = String.valueOf(externalItem.toString()) + " ";
            String output = "";
            String number = "";
            char[] cArray = inputString.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                Character c = Character.valueOf(cArray[n2]);
                if (Character.isDigit(c.charValue())) {
                    number = String.valueOf(number) + c.toString();
                } else if (!number.equals("")) {
                    if (Integer.parseInt(number) > 175) {
                        return null;
                    }
                    if (output.length() > 0) {
                        output = String.valueOf(output) + ",";
                    }
                    output = String.valueOf(output) + number;
                    number = "";
                }
                ++n2;
            }
            return output;
        }
        if (this.enumValues != null) {
            return this.enumValues[externalIndex];
        }
        if (this.enumLabels == null) {
            String output = externalItem == null ? "" : externalItem.toString();
            switch (this.type) {
                case INTEGER: 
                case GAUGE32: {
                    try {
                        Integer.parseInt(output);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                }
                case IP_ADDRESS: {
                    if (isSelector) {
                        if (output.length() == 0) {
                            return null;
                        }
                        if (!output.matches("^(?:\\d+\\.){0,3}\\d*$")) {
                            return null;
                        }
                    } else if (!output.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$")) {
                        return null;
                    }
                    String[] stringArray = output.split("\\.");
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String b = stringArray[n3];
                        if (Integer.parseInt(b) > 255) {
                            return null;
                        }
                        ++n3;
                    }
                    break;
                }
            }
            return output;
        }
        int i = 0;
        String[] stringArray = this.enumLabels;
        int n = this.enumLabels.length;
        int n4 = 0;
        while (n4 < n) {
            String s = stringArray[n4];
            if (s != null) {
                if (i == externalIndex) {
                    return Integer.toString(i);
                }
            } else {
                ++externalIndex;
            }
            ++i;
            ++n4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Oid getOidByOidString(String oidString) {
        Class<Oid> clazz = Oid.class;
        synchronized (Oid.class) {
            if (oidsMap == null) {
                oidsMap = new HashMap<String, Oid>();
                Oid.iterateKnownOids(new NdmCallback(){

                    @Override
                    public void callback(Object ob) {
                        Oid oid = (Oid)((Object)ob);
                        oidsMap.put(oid.oid, oid);
                        oid.initEnums();
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Oid oid = oidsMap.get(oidString);
            return oid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Oid getOidByRawOid(String rawoid) {
        Class<Oid> clazz = Oid.class;
        synchronized (Oid.class) {
            if (oidsMap == null) {
                oidsMap = new HashMap<String, Oid>();
                Oid.iterateKnownOids(new NdmCallback(){

                    @Override
                    public void callback(Object ob) {
                        Oid oid = (Oid)((Object)ob);
                        oidsMap.put(oid.oid, oid);
                        oid.initEnums();
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (Map.Entry<String, Oid> entry : oidsMap.entrySet()) {
                if (!rawoid.startsWith(String.valueOf(entry.getKey()) + ".")) continue;
                return entry.getValue();
            }
            return null;
        }
    }

    public static void iterateKnownOids(NdmCallback code) {
        Oid[] oidArray = Oid.values();
        int n = oidArray.length;
        int n2 = 0;
        while (n2 < n) {
            Oid item = oidArray[n2];
            code.callback((Object)item);
            ++n2;
        }
    }

    public List<Oid> getSequence() {
        switch (this) {
            case RADIO_TABLE: {
                return Arrays.asList(RADIO_TABLE_INDEX, RADIO_TABLE_NAME, RADIO_TABLE_ENABLE, RADIO_PHY_TABLE_MAC);
            }
            case WLAN_TABLE: {
                return Arrays.asList(WLAN_TABLE_INDEX, WLAN_TABLE_SSID, WLAN_TABLE_ROLE, WLAN_TABLE_BAND, WLAN_TABLE_CHANNEL, WLAN_TABLE_FREQ, WLAN_TABLE_ENABLE, WLAN_TABLE_PHYINDEX, WLAN_TABLE_SECURITY, WLAN_TABLE_WPA, WLAN_TABLE_STATE, WLAN_TABLE_BSSID);
            }
            case ASSOC_TABLE: {
                return Arrays.asList(WLAN_TABLE_ROLE, WLAN_TABLE_BSSID, WLAN_TABLE_CHANNEL, WLAN_TABLE_QUALITY, WLAN_TABLE_STATE, WLAN_TABLE_NPEERS, WLAN_TABLE_BEACON_SIGNAL);
            }
            case ASS_STA_TABLE: {
                return Arrays.asList(ASS_STA_TABLE_MAC, ASS_STA_TABLE_BSSID, ASS_STA_TABLE_RSSI);
            }
        }
        return null;
    }

    public int getColumnIndex(Oid oid) {
        return this.getSequence().indexOf((Object)oid);
    }

    public static enum Type {
        INTEGER,
        DISPLAY_STRING,
        OCTET_STRING,
        IP_ADDRESS,
        PHYS_ADDRESS,
        GAUGE32,
        TIMETICKS,
        NOT_SNMP,
        SEQUENCE;

    }
}

