/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.snmp;

import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.RememberableDialog;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.config.TimeoutThread;
import fr.acksys.snmp.DebuggedDefaultUdpTransportMapping;
import fr.acksys.snmp.Oid;
import fr.acksys.snmp.SnmpReturnedTable;
import fr.acksys.translation.TranslateEnum;
import fr.acksys.udap.GetResponse;
import fr.acksys.udap.UdapResponse;
import fr.acksys.udap.UdapSocket;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;

public class SnmpManager {
    private static Snmp snmp;

    public SnmpManager() {
        try {
            DebuggedDefaultUdpTransportMapping transport = new DebuggedDefaultUdpTransportMapping();
            snmp = new Snmp(transport);
            snmp.listen();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void closesnmp() {
        try {
            if (snmp != null) {
                snmp.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getSnmpString(final Product product, List<Oid> oidList) {
        Address targetAddress = GenericAddress.parse("udp:" + product.getIpString() + "/161");
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(product.getCommunityRead()));
        target.setAddress(targetAddress);
        UserParameters userParam = UserParameters.getInstance();
        int snmpRetry = Integer.parseInt(userParam.getParam("SNMP_RETRY_VALUE"));
        int snmpTimeout = Integer.parseInt(userParam.getParam("SNMP_TIMEOUT_VALUE"));
        target.setRetries(snmpRetry);
        target.setTimeout(snmpTimeout);
        target.setVersion(0);
        Oid uniqueIdOid = product.getUniqueIdOid();
        try {
            PDUv1 pdu = new PDUv1();
            pdu.add(new VariableBinding(new OID(uniqueIdOid.getOid())));
            pdu.add(new VariableBinding(new OID(Oid.SYSUPTIME.getOid())));
            Iterator<Oid> iterator = oidList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    pdu.setType(-96);
                    try {
                        PDU responsePDU = null;
                        try {
                            ResponseEvent response = snmp.send(pdu, target);
                            responsePDU = response.getResponse();
                        }
                        catch (IllegalStateException ex) {
                            ex.printStackTrace();
                        }
                        if (responsePDU != null && responsePDU.getErrorStatus() == 0) {
                            Vector<? extends VariableBinding> responseBindings = responsePDU.getVariableBindings();
                            for (VariableBinding variableBinding : responseBindings) {
                                if (Oid.getOidByOidString(variableBinding.getOid().toString()) != uniqueIdOid) continue;
                                String val = variableBinding.getVariable().toString();
                                String mac = product.parameters.getStringValue(Oid.GENERIC_PRODUCT_ID);
                                if (mac == null || mac.equalsIgnoreCase(val)) break;
                                throw new MessageException("");
                            }
                            Product product2 = product;
                            synchronized (product2) {
                                Iterator<? extends VariableBinding> iterator2 = responseBindings.iterator();
                                while (iterator2.hasNext()) {
                                    VariableBinding variableBinding = iterator2.next();
                                    Oid oid = Oid.getOidByOidString(variableBinding.getOid().toString());
                                    SnmpManager.setProductParameter(product, oid, variableBinding, uniqueIdOid);
                                }
                            }
                            product.checkForDisplayChanges();
                            product.resetTTL();
                            product.canMultiSnmpConfig = true;
                            product.cannotMultiSnmpWarning = false;
                            product.is_snmprespond = true;
                            return true;
                        }
                        if (product.canMultiSnmpConfig) {
                            product.cannotMultiSnmpWarning = true;
                            return false;
                        }
                        boolean gotSomething = false;
                        pdu.clear();
                        pdu.add(new VariableBinding(new OID(uniqueIdOid.getOid())));
                        pdu.setType(-96);
                        responsePDU = null;
                        try {
                            ResponseEvent responseEvent = snmp.send(pdu, target);
                            responsePDU = responseEvent.getResponse();
                        }
                        catch (IllegalStateException illegalStateException) {
                            System.out.println("getSnmpString2");
                            illegalStateException.printStackTrace();
                        }
                        if (responsePDU != null && responsePDU.getErrorStatus() == 0) {
                            VariableBinding variableBinding = responsePDU.getVariableBindings().firstElement();
                            Product product3 = product;
                            synchronized (product3) {
                                SnmpManager.setProductParameter(product, uniqueIdOid, variableBinding, uniqueIdOid);
                            }
                            gotSomething = true;
                            for (Oid oid : oidList) {
                                int[] oidTab = SnmpManager.stringToOid(oid.getOid());
                                pdu.clear();
                                pdu.add(new VariableBinding(new OID(oidTab)));
                                pdu.setType(-96);
                                responsePDU = null;
                                try {
                                    ResponseEvent response = snmp.send(pdu, target);
                                    responsePDU = response.getResponse();
                                }
                                catch (IllegalStateException ex) {
                                    System.out.println("getSnmpString2");
                                    ex.printStackTrace();
                                }
                                if (responsePDU == null || responsePDU.getErrorStatus() != 0) continue;
                                VariableBinding value_oid = responsePDU.getVariableBindings().firstElement();
                                Product product4 = product;
                                synchronized (product4) {
                                    SnmpManager.setProductParameter(product, oid, value_oid, uniqueIdOid);
                                }
                            }
                        } else {
                            gotSomething = false;
                        }
                        if (!gotSomething) {
                            product.is_snmprespond = false;
                            IgUtils.ExecuteOnSwingThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (UserParameters.getInstance().getParam("SNMP_DISABLED_WARNING").equals("0")) {
                                        MessageFormat form = new MessageFormat(TranslateEnum.NOT_SNMP_MANAGEABLE.get());
                                        Object[] args = new Object[]{product.getIpString()};
                                        RememberableDialog remember = new RememberableDialog("SNMP_DISABLED_WARNING", form.format(args));
                                        remember.setVisible(true);
                                    }
                                }
                            });
                            return false;
                        }
                        product.resetTTL();
                        product.checkForDisplayChanges();
                        if (!product.cannotMultiSnmpWarning) {
                            product.cannotMultiSnmpWarning = true;
                        }
                        product.is_snmprespond = true;
                        return true;
                    }
                    catch (MessageException e) {
                        product.cannotMultiSnmpWarning = true;
                        return false;
                    }
                }
                Oid oid = iterator.next();
                int[] nArray = SnmpManager.stringToOid(oid.getOid());
                pdu.add(new VariableBinding(new OID(nArray)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public SnmpReturnedTable getSnmpTable(Product product, Oid oidTable) {
        if (product.cannotMultiSnmpWarning) {
            return null;
        }
        Address targetAddress = GenericAddress.parse("udp:" + product.getIpString() + "/161");
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(product.getCommunityRead()));
        target.setAddress(targetAddress);
        UserParameters userParam = UserParameters.getInstance();
        int snmpRetry = Integer.parseInt(userParam.getParam("SNMP_RETRY_VALUE"));
        int snmpTimeout = Integer.parseInt(userParam.getParam("SNMP_TIMEOUT_VALUE"));
        target.setRetries(snmpRetry);
        target.setTimeout(snmpTimeout);
        target.setVersion(0);
        TableUtils tableGetter = new TableUtils(snmp, new DefaultPDUFactory());
        Parameter paramTable = product.parameters.get(oidTable);
        int nboids = paramTable.columnCount();
        Parameter[] columns = (Parameter[])paramTable.getValue();
        OID[] snmpOidsList = new OID[nboids];
        int i = 0;
        while (i < nboids) {
            snmpOidsList[i] = new OID(columns[i].getId().getOid());
            ++i;
        }
        List<TableEvent> list = tableGetter.getTable(target, snmpOidsList, null, null);
        int nbLignesReponse = list.size();
        Parameter[] columnsTable = new Parameter[nboids];
        i = 0;
        while (i < nboids) {
            Parameter param = new Parameter(columns[i].getId());
            param.setArrayValue(new Object[nbLignesReponse]);
            columnsTable[i] = param;
            ++i;
        }
        i = 0;
        boolean gotSomething = false;
        for (TableEvent row : list) {
            if (row.getStatus() == 0) {
                gotSomething = true;
                VariableBinding[] variableBindingArray = row.getColumns();
                int n = variableBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OID boid;
                    Oid oid;
                    VariableBinding binding = variableBindingArray[n2];
                    if (binding != null && (oid = Oid.getOidByRawOid((boid = binding.getOid()).toString())) != null) {
                        String val;
                        Variable snmpValue = binding.getVariable();
                        switch (binding.getSyntax()) {
                            case 67: {
                                val = Integer.toString(((TimeTicks)snmpValue).toInt());
                                break;
                            }
                            default: {
                                if (oid.type == Oid.Type.DISPLAY_STRING) {
                                    try {
                                        val = new String(((OctetString)snmpValue).toByteArray(), "UTF-8");
                                    }
                                    catch (UnsupportedEncodingException uee) {
                                        uee.printStackTrace();
                                        val = snmpValue.toString();
                                    }
                                    break;
                                }
                                val = snmpValue.toString();
                            }
                        }
                        if (val.equals("Null")) {
                            val = TranslateEnum.UNAVAILABLE.get();
                        } else if (oid.getType() == Oid.Type.PHYS_ADDRESS) {
                            val = val.toUpperCase();
                        }
                        i = 0;
                        while (i < nboids) {
                            Parameter param = columnsTable[i];
                            if (param.getId() == oid) {
                                param.setValue(param.rowCount(), val);
                                break;
                            }
                            ++i;
                        }
                        if (i >= nboids) {
                            System.out.println("not found oid=" + (Object)((Object)oid));
                        }
                    }
                    ++n2;
                }
            } else {
                gotSomething = false;
            }
            ++i;
        }
        if (gotSomething) {
            product.is_snmprespond = true;
            product.resetTTL();
        } else {
            product.is_snmprespond = false;
        }
        product.canMultiSnmpConfig = true;
        return new SnmpReturnedTable(paramTable, columnsTable, nbLignesReponse);
    }

    private static void setProductParameter(Product product, Oid oid, VariableBinding binding, Oid uniqueIdOid) throws MessageException {
        String val;
        Variable snmpValue = binding.getVariable();
        switch (binding.getSyntax()) {
            case 67: {
                val = Integer.toString(((TimeTicks)snmpValue).toInt());
                break;
            }
            default: {
                val = snmpValue.toString();
            }
        }
        if (val.equals("Null")) {
            val = TranslateEnum.UNAVAILABLE.get();
        } else if (oid.getType() == Oid.Type.PHYS_ADDRESS) {
            val = val.toUpperCase();
        }
        if (oid == uniqueIdOid) {
            String mac = product.parameters.getStringValue(Oid.GENERIC_PRODUCT_ID);
            if (mac != null && !mac.equalsIgnoreCase(val)) {
                throw new MessageException("");
            }
            product.setParam(new Parameter(Oid.GENERIC_PRODUCT_ID, val));
        } else if (oid.type == Oid.Type.DISPLAY_STRING) {
            try {
                val = new String(((OctetString)binding.getVariable()).toByteArray(), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
                val = binding.getVariable().toString();
            }
            product.setParam(new Parameter(oid, val));
        } else if (oid == Oid.IP_ADDRESS) {
            product.getParam(oid).setNewValue(val);
        } else {
            if (oid == Oid.WIFI_BRIDGE_CHANLIST && val.endsWith(",")) {
                val = val.substring(0, val.length() - 1);
            }
            try {
                product.setParam(new Parameter(oid, val));
            }
            catch (Exception ex) {
                System.out.println("ERROR(snmp): " + product + ": " + (Object)((Object)oid) + "=" + val + "//" + snmpValue);
            }
        }
    }

    private static VariableBinding createOidBinding(Product product, Oid oid) {
        AbstractVariable value;
        Parameter p = product.getParam(oid);
        Object s = p.getNewValue();
        if (s == null) {
            s = p.getValue();
        }
        switch (oid.getType()) {
            case IP_ADDRESS: {
                value = new IpAddress((String)s);
                break;
            }
            case DISPLAY_STRING: 
            case OCTET_STRING: {
                value = new OctetString((String)s);
                break;
            }
            case INTEGER: {
                value = new Integer32((Integer)s);
                break;
            }
            case TIMETICKS: {
                value = new TimeTicks((Long)s);
                break;
            }
            case GAUGE32: {
                value = new Gauge32((long)((Integer)s).intValue());
                break;
            }
            default: {
                return null;
            }
        }
        int[] oidTab = SnmpManager.stringToOid(oid.getOid());
        return new VariableBinding(new OID(oidTab), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setSnmpString(Product product, List<Oid> oidList) {
        String macAddress = product.getUniqueIdString();
        String ipAddress = (String)product.getParam(Oid.IP_ADDRESS).getValue();
        int dhcpState = (Integer)product.getParam(Oid.DHCP_STATE).getValue();
        int gotSomething = 2;
        UdapSocket udap = new UdapSocket(macAddress);
        Object token = udap.getToken();
        UdapResponse response_udap = null;
        if (ipAddress.equals("0.0.0.0") && dhcpState == 2) {
            udap.startReception(2);
            int timeoutRetry = 5;
            while (timeoutRetry > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                TimeoutThread timeOut_snmp = new TimeoutThread(token, 1000);
                timeOut_snmp.setName("tmo snmp " + product.toString());
                timeOut_snmp.start();
                Object object = token;
                synchronized (object) {
                    GetResponse getResponse;
                    udap.getConfig(macAddress);
                    try {
                        token.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (!udap.IsEmpty() && (response_udap = udap.getResponse()) != null && !(ipAddress = (getResponse = (GetResponse)response_udap).getIpAddress()).equals("0.0.0.0")) {
                        product.setParam(new Parameter(Oid.IP_ADDRESS, ipAddress));
                        timeOut_snmp.stopTimeout();
                        gotSomething = 0;
                        break;
                    }
                }
                if (timeoutRetry == 1) {
                    udap.terminateReception(2);
                    return gotSomething;
                }
                --timeoutRetry;
            }
            udap.terminateReception(2);
        }
        Address targetAddress = GenericAddress.parse("udp:" + ipAddress + "/161");
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString(product.getCommunityWrite()));
        target.setAddress(targetAddress);
        UserParameters userParam = UserParameters.getInstance();
        int snmpRetry = Integer.parseInt(userParam.getParam("SNMP_RETRY_VALUE"));
        int snmpTimeout = Integer.parseInt(userParam.getParam("SNMP_TIMEOUT_VALUE"));
        target.setRetries(snmpRetry);
        target.setTimeout(snmpTimeout);
        target.setVersion(0);
        try {
            PDUv1 pdu = new PDUv1();
            Iterator<Oid> iterator = oidList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    pdu.setType(-93);
                    try {
                        PDU responsePDU = null;
                        try {
                            ResponseEvent response = snmp.send(pdu, target);
                            responsePDU = response.getResponse();
                        }
                        catch (IllegalStateException ex) {
                            System.out.println("setSnmpString1");
                            ex.printStackTrace();
                        }
                        if (responsePDU != null && responsePDU.getErrorStatus() == 0) {
                            return 0;
                        }
                        if (product.canMultiSnmpConfig) {
                            if (responsePDU != null) return 2;
                            return -1;
                        }
                        Iterator<Oid> iterator2 = oidList.iterator();
                        while (true) {
                            if (!iterator2.hasNext()) {
                                return gotSomething;
                            }
                            Oid oid = iterator2.next();
                            VariableBinding vb = SnmpManager.createOidBinding(product, oid);
                            if (vb == null) continue;
                            pdu.clear();
                            pdu.add(vb);
                            pdu.setType(-93);
                            responsePDU = null;
                            try {
                                ResponseEvent response = snmp.send(pdu, target);
                                responsePDU = response.getResponse();
                            }
                            catch (IllegalStateException ex) {
                                System.out.println("setSnmpString2");
                                ex.printStackTrace();
                            }
                            if (responsePDU != null && responsePDU.getErrorStatus() == 0) {
                                gotSomething = 0;
                                continue;
                            }
                            gotSomething = 2;
                        }
                    }
                    catch (MessageException e) {
                        return 2;
                    }
                }
                Oid oid = iterator.next();
                VariableBinding vb = SnmpManager.createOidBinding(product, oid);
                if (vb == null) continue;
                pdu.add(vb);
            }
        }
        catch (IOException e) {
            gotSomething = 2;
            e.printStackTrace();
        }
        return gotSomething;
    }

    private static int[] stringToOid(String oidString) {
        String[] tab = oidString.split("\\.");
        int[] oid = new int[tab.length];
        int i = 0;
        while (i < tab.length) {
            oid[i] = Integer.parseInt(tab[i]);
            ++i;
        }
        return oid;
    }
}

