/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.translation;

import fr.acksys.translation.AvailableLanguages;
import fr.acksys.translation.LocaleListener;
import fr.acksys.translation.TranslateEnum;
import java.util.ArrayList;
import java.util.Locale;

public class LocaleState {
    private static Locale locale = Locale.ENGLISH;
    private static LocaleState instance = null;
    private ArrayList<LocaleListener> listeners = new ArrayList();

    private LocaleState() {
    }

    public static LocaleState getInstance() {
        if (instance == null) {
            instance = new LocaleState();
        }
        return instance;
    }

    public Locale getLocale() {
        return locale;
    }

    public void setLocale(Locale loc) {
        locale = loc;
        TranslateEnum.setLanguage(AvailableLanguages.get(loc));
        this.FireLocaleChanged();
    }

    public String toString() {
        return AvailableLanguages.get(locale).toString();
    }

    public void addLocaleListener(LocaleListener l) {
        this.listeners.add(l);
    }

    public void removeLocaleListener(LocaleListener l) {
        this.listeners.remove(l);
    }

    private void FireLocaleChanged() {
        for (LocaleListener l : this.listeners) {
            l.localeChanged(locale);
        }
    }
}

