/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.udap;

import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.udap.FrameBuilder;
import fr.acksys.udap.UdapResponse;

public class DiscoverResponse
implements UdapResponse {
    String ipAddress;
    String macAddress;
    String deviceName;
    String sysDescr;
    String firmwareId;
    private int productCode = -1;
    boolean standardNdm;
    boolean canUdap = false;
    private int distance = 0;

    public DiscoverResponse(FrameBuilder frame) {
        this.ipAddress = frame.getInetAddress().getHostAddress();
        this.macAddress = frame.getUdapDatagram().getSourceMacAddress();
        this.sysDescr = frame.getUcpDatagram().getDeviceTypeName();
        this.deviceName = frame.getUcpDatagram().getDeviceName();
        this.firmwareId = frame.getUcpDatagram().getFirmwareId();
        this.productCode = frame.getUcpDatagram().getProductCode();
        this.standardNdm = frame.getUcpDatagram().IsStandardNdm();
        this.canUdap = true;
    }

    public DiscoverResponse(String mac, String ip, String sysdescr, String devname, String firmwareId, int productCode, boolean isStdNdm) {
        this.ipAddress = ip;
        this.macAddress = mac;
        this.sysDescr = sysdescr;
        this.deviceName = devname;
        this.firmwareId = firmwareId;
        this.productCode = productCode;
        this.standardNdm = isStdNdm;
        this.canUdap = false;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getSysDescr() {
        return this.sysDescr;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getFirmwareId() {
        return this.firmwareId;
    }

    public int getProductCode() {
        return this.productCode == -1 ? 21 : this.productCode;
    }

    public void SetProductCode(int i) {
        this.productCode = i;
    }

    public boolean isStandardNdm() {
        return this.standardNdm;
    }

    @Override
    public int getMethod() {
        return 1;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setProductDiscoverParams(Product product) {
        String[] desc;
        product.setUniqueIdString(this.getMacAddress());
        product.setDistance(this.distance);
        product.setParam(new Parameter(Oid.IP_ADDRESS, this.getIpAddress()));
        product.setParam(new Parameter(Oid.SYSDESCR, this.getSysDescr()));
        product.setParam(new Parameter(Oid.SYSLOCATION, this.getDeviceName()));
        product.setParam(new Parameter(Oid.FIRMWARE_DESCRIPTION, this.getFirmwareId()));
        Integer newProductCode = this.getProductCode();
        if (newProductCode != 21) {
            product.setParam(new Parameter(Oid.PRODUCT_CODE, newProductCode));
        }
        if ((desc = this.getSysDescr().split("_")).length > 0) {
            product.setDeviceType(desc[0]);
        } else {
            product.setDeviceType(this.getSysDescr());
        }
        if (!product.canUdap() && this.canUdap) {
            product.setCanUdap(true);
            product.updateConfig();
        }
        product.checkForDisplayChanges();
    }
}

