/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.udap;

import fr.acksys.udap.FrameBuilder;
import fr.acksys.udap.UdapResponse;

public class GetResponse
implements UdapResponse {
    private String ipAddress;
    private String subnetMask;
    private String gateway;
    private String sourceAddress;
    boolean dhcpEnabled;

    public GetResponse(FrameBuilder frame) {
        this.sourceAddress = frame.getUdapDatagram().getSourceMacAddress();
        this.ipAddress = frame.getInetAddress().getHostAddress();
        this.subnetMask = frame.getUcpDatagram().getSubnetMask();
        this.gateway = frame.getUcpDatagram().getGateway();
        this.dhcpEnabled = frame.getUcpDatagram().IsDhcpEnable();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public int getDhcpEnabled() {
        return this.dhcpEnabled ? 2 : 1;
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    @Override
    public int getMethod() {
        return 2;
    }
}

