/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.udap;

import fr.acksys.ndm.Main;
import fr.acksys.ndm.NdmCallback;
import fr.acksys.udap.UdapSocket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class SocketedNetworkInterface {
    private static ArrayList<SocketedNetworkInterface> ifList = new ArrayList();
    private static int broadcastPort;
    private static int socketTimeout;
    private static SocketAddress genericDestBroadcast;
    private NetworkInterface netInterface;
    private DatagramSocket txsocket;
    private DatagramSocket rxsocket;
    private InetAddress inaddr;
    private String ip;
    private Thread receiveThread;
    private SocketAddress destBroadcast;
    private boolean isUp;

    public SocketedNetworkInterface(NetworkInterface netint, InetAddress ifaddr) throws SocketException {
        this.netInterface = netint;
        this.destBroadcast = genericDestBroadcast;
        this.inaddr = ifaddr;
        this.ip = this.inaddr.getHostAddress();
        this.txsocket = new DatagramSocket(null);
        this.txsocket.bind(new InetSocketAddress(this.inaddr, 0));
        if (Main.os_name.equals("Linux")) {
            this.rxsocket = new DatagramSocket(null);
            int tx_port = this.txsocket.getLocalPort();
            try {
                InetSocketAddress rxBroadcast = new InetSocketAddress(InetAddress.getByName("255.255.255.255"), tx_port);
                this.rxsocket.bind(rxBroadcast);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else {
            this.rxsocket = this.txsocket;
        }
        this.rxsocket.setBroadcast(true);
        this.rxsocket.setSoTimeout(socketTimeout);
        this.receiveThread = UdapSocket.getReceiveThread(this);
        this.isUp = true;
    }

    private SocketedNetworkInterface() throws IOException {
        this.netInterface = null;
        this.destBroadcast = genericDestBroadcast;
        this.inaddr = InetAddress.getByName("255.255.255.255");
        this.ip = this.inaddr.getHostAddress();
        this.txsocket = this.rxsocket = new DatagramSocket(0);
        this.rxsocket.setBroadcast(true);
        this.rxsocket.setSoTimeout(socketTimeout);
        this.receiveThread = UdapSocket.getReceiveThread(this);
        this.isUp = true;
    }

    private void bindSocket(InterfaceAddress ifaddr) throws SocketException {
        this.destBroadcast = genericDestBroadcast;
        this.inaddr = ifaddr.getAddress();
        this.ip = this.inaddr.getHostAddress();
        this.txsocket = new DatagramSocket(null);
        this.txsocket.bind(new InetSocketAddress(this.inaddr, 0));
        if (Main.os_name.equals("Linux")) {
            this.rxsocket = new DatagramSocket(null);
            int z = this.txsocket.getLocalPort();
            try {
                InetSocketAddress rxBroadcast = new InetSocketAddress(InetAddress.getByName("255.255.255.255"), z);
                this.rxsocket.bind(rxBroadcast);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else {
            this.rxsocket = this.txsocket;
        }
        this.rxsocket.setBroadcast(true);
        this.rxsocket.setSoTimeout(socketTimeout);
        this.receiveThread = UdapSocket.getReceiveThread(this);
        this.isUp = true;
    }

    private void tryRebind(InterfaceAddress ifaddr) throws SocketException {
        this.bindSocket(ifaddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterateKnownInterfaces(NdmCallback code) {
        ArrayList<SocketedNetworkInterface> arrayList = ifList;
        synchronized (arrayList) {
            for (SocketedNetworkInterface item : ifList) {
                code.callback(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String afficherKnownInterfaces() {
        String netlist = "";
        int i = 1;
        ArrayList<SocketedNetworkInterface> arrayList = ifList;
        synchronized (arrayList) {
            for (SocketedNetworkInterface item : ifList) {
                NetworkInterface inet = item.getnetInterface();
                netlist = String.valueOf(netlist) + "-----------------------------<b>Net " + i + "</b>-----------------------------";
                netlist = String.valueOf(netlist) + "<br>Local Address = " + item.getLocalAddress();
                if (inet != null) {
                    netlist = String.valueOf(netlist) + "<br>" + inet;
                }
                if (inet != null) {
                    for (InterfaceAddress ifAddress : inet.getInterfaceAddresses()) {
                        netlist = String.valueOf(netlist) + "<br>";
                        netlist = String.valueOf(netlist) + "<br>Interface Address = " + ifAddress.getAddress();
                        if (ifAddress.getBroadcast() != null) {
                            netlist = String.valueOf(netlist) + "<br>Broadcast Address = " + ifAddress.getBroadcast();
                        }
                        netlist = String.valueOf(netlist) + "<br>NetworkPrefixLength = " + ifAddress.getNetworkPrefixLength();
                    }
                }
                netlist = String.valueOf(netlist) + "<br><br>";
                ++i;
            }
        }
        return netlist;
    }

    public static void initSocketsList() {
        byte[] bcast = new byte[]{-1, -1, -1, -1};
        try {
            genericDestBroadcast = new InetSocketAddress(InetAddress.getByAddress(bcast), broadcastPort);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildSocketsList() {
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            while (nets.hasMoreElements()) {
                NetworkInterface netint = nets.nextElement();
                if (netint.isLoopback() || !netint.isUp()) continue;
                for (InterfaceAddress ifAddress : netint.getInterfaceAddresses()) {
                    if (ifAddress == null || ifAddress.getBroadcast() == null) continue;
                    ArrayList<SocketedNetworkInterface> arrayList = ifList;
                    synchronized (arrayList) {
                        SocketedNetworkInterface found = SocketedNetworkInterface.findInNetworkInterfaceList(netint);
                        try {
                            if (found == null) {
                                ifList.add(new SocketedNetworkInterface(netint, ifAddress.getAddress()));
                            } else if (!found.isUp) {
                                found.tryRebind(ifAddress);
                            }
                        }
                        catch (SocketException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SocketedNetworkInterface findInNetworkInterfaceList(NetworkInterface netint) {
        ArrayList<SocketedNetworkInterface> arrayList = ifList;
        synchronized (arrayList) {
            for (SocketedNetworkInterface netif : ifList) {
                if (netif.netInterface == null || !netif.netInterface.equals(netint)) continue;
                return netif;
            }
        }
        return null;
    }

    public void send(DatagramPacket datagram) throws IOException {
        try {
            if (!this.receiveThread.isAlive()) {
                this.receiveThread.start();
            }
            this.txsocket.send(datagram);
        }
        catch (IOException e) {
            this.isUp = false;
            System.out.printf("=============SEND EXCEPTION isUp = false==================\n", new Object[0]);
            e.printStackTrace();
            throw e;
        }
    }

    public DatagramSocket getTxSocket() {
        return this.txsocket;
    }

    public DatagramSocket getRxSocket() {
        return this.rxsocket;
    }

    public String getLocalAddress() {
        return this.ip;
    }

    public InetAddress getinaddr() {
        return this.inaddr;
    }

    public NetworkInterface getnetInterface() {
        return this.netInterface;
    }

    public SocketAddress getDestBroadcast() {
        return this.destBroadcast;
    }

    public Thread getReceiveThread() {
        return this.receiveThread;
    }

    public static void main(String[] args) {
        SocketedNetworkInterface.setDefaultBroadcastPort(17784);
        SocketedNetworkInterface.setDefaultSocketTimeout(1000);
        int i = 0;
        while (i < 100) {
            SocketedNetworkInterface.buildSocketsList();
            ++i;
        }
    }

    public static void setDefaultBroadcastPort(int port) {
        broadcastPort = port;
    }

    public static void setDefaultSocketTimeout(int timeout) {
        socketTimeout = timeout;
    }
}

