/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.udap;

import java.io.UnsupportedEncodingException;

public class UcpDatagram {
    private byte[] header = new byte[7];
    private byte[] argument = new byte[14];
    private byte[] Iden_arg = new byte[6];
    private byte[] Loc_arg = new byte[33];
    private int userNameLength = 0;
    private byte[] Username;
    private boolean UsernameUsed = false;
    private byte[] Password;
    boolean PasswordUsed = false;
    private static final int ARGUMENT_MAC_ADDRESS = 1;
    private static final int ARGUMENT_DEVICE_NAME = 2;
    private static final int ARGUMENT_DEVICE_TYPE_NAME = 3;
    private static final int ARGUMENT_DHCP = 4;
    private static final int ARGUMENT_IP_ADDRESS = 5;
    private static final int ARGUMENT_SUBNET_MASK = 6;
    private static final int ARGUMENT_GATEWAY = 7;
    private static final int ARGUMENT_FIRMWARE_ID = 8;
    private static final int ARGUMENT_PRODUCT_CODE = 9;
    private static final int ARGUMENT_STANDARD_NDM = 10;
    private static final int ARGUMENT_ERROR_CODE = 11;
    private static final int ARGUMENT_HASH_CODE = 12;
    private static final int ARGUMENT_USERNAME = 13;
    private static final int ARGUMENT_PASSWORD = 14;
    private static final int ARGUMENT_IDEN_PRODUCT = 15;
    private static final int PASSWORD_LENGTH = 16;
    private static final int ARGUMENT_ROLE = 17;

    public void setBytes(byte[] buffer) {
        int i = 0;
        while (i < 7) {
            this.header[i] = buffer[i];
            ++i;
        }
        int length = buffer.length - 7;
        this.argument = new byte[length];
        int i2 = 0;
        while (i2 < length) {
            this.argument[i2] = buffer[i2 + 7];
            ++i2;
        }
    }

    public void setFlag(boolean requestDiscovery) {
        this.header[0] = requestDiscovery ? (byte)1 : 0;
    }

    public void setInterfaceClass(int interfaceClass) {
        this.header[1] = (byte)((interfaceClass & 0xFF000000) >> 24);
        this.header[2] = (byte)((interfaceClass & 0xFF0000) >> 16);
        this.header[3] = (byte)((interfaceClass & 0xFF00) >> 8);
        this.header[4] = (byte)(interfaceClass & 0xFF);
    }

    public void setMethod(int method, String userName) {
        this.header[5] = (byte)((method & 0xFF00) >> 8);
        this.header[6] = (byte)(method & 0xFF);
        if ((method == 3 || method == 11) && userName != null) {
            this.setUsername(userName.getBytes());
        }
    }

    public int getMethod() {
        int method = this.header[5] << 8;
        return method += this.header[6] & 0xFF;
    }

    public byte[] getBytes() {
        int BufferLen = this.header.length;
        BufferLen += 13;
        BufferLen = this.UsernameUsed ? (BufferLen += this.Username.length + 2) : (BufferLen += 2);
        if (this.PasswordUsed) {
            BufferLen += this.Password.length + 2;
        }
        byte[] buffer = new byte[BufferLen];
        int index = 0;
        int i = 0;
        while (i < this.header.length) {
            buffer[index] = this.header[i];
            ++index;
            ++i;
        }
        i = 0;
        while (i < 13) {
            buffer[index] = this.argument[i];
            ++index;
            ++i;
        }
        if (this.UsernameUsed) {
            buffer[index] = 13;
            buffer[++index] = (byte)this.Username.length;
            ++index;
            i = 0;
            while (i < this.Username.length) {
                buffer[index] = this.Username[i];
                ++index;
                ++i;
            }
        } else {
            buffer[index] = 13;
            buffer[++index] = 0;
            ++index;
        }
        if (this.PasswordUsed) {
            buffer[index] = 14;
            buffer[++index] = (byte)this.Password.length;
            ++index;
            i = 0;
            while (i < this.Password.length) {
                buffer[index] = this.Password[i];
                ++index;
                ++i;
            }
        }
        return buffer;
    }

    public byte[] getBytes_CAT() {
        int BufferLen = this.header.length;
        BufferLen += 14;
        BufferLen = this.UsernameUsed ? (BufferLen += this.Username.length + 2) : (BufferLen += 2);
        if (this.PasswordUsed) {
            BufferLen += this.Password.length + 2;
        }
        byte[] buffer = new byte[BufferLen];
        int index = 0;
        int i = 0;
        while (i < this.header.length) {
            buffer[index] = this.header[i];
            ++index;
            ++i;
        }
        i = 0;
        while (i < 14) {
            buffer[index] = this.argument[i];
            ++index;
            ++i;
        }
        if (this.UsernameUsed) {
            buffer[index] = 13;
            buffer[++index] = (byte)this.Username.length;
            ++index;
            i = 0;
            while (i < this.Username.length) {
                buffer[index] = this.Username[i];
                ++index;
                ++i;
            }
        } else {
            buffer[index] = 13;
            buffer[++index] = 0;
            ++index;
        }
        if (this.PasswordUsed) {
            buffer[index] = 14;
            buffer[++index] = (byte)this.Password.length;
            ++index;
            i = 0;
            while (i < this.Password.length) {
                buffer[index] = this.Password[i];
                ++index;
                ++i;
            }
        }
        return buffer;
    }

    public byte[] getBytes_ident() {
        int BufferLen = this.header.length;
        byte[] buffer = new byte[BufferLen += 6];
        int index = 0;
        int i = 0;
        while (i < this.header.length) {
            buffer[index] = this.header[i];
            ++index;
            ++i;
        }
        i = 0;
        while (i < 6) {
            buffer[index] = this.Iden_arg[i];
            ++index;
            ++i;
        }
        return buffer;
    }

    public byte[] getBytes_loc_CAT() {
        int BufferLen = this.header.length;
        byte[] buffer = new byte[BufferLen += 33];
        int index = 0;
        int i = 0;
        while (i < this.header.length) {
            buffer[index] = this.header[i];
            ++index;
            ++i;
        }
        i = 0;
        while (i < 33) {
            buffer[index] = this.Loc_arg[i];
            ++index;
            ++i;
        }
        return buffer;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] getArgument(int param) {
        index = 0;
        if (this.argument.length != 0) ** GOTO lbl20
        return null;
lbl-1000:
        // 1 sources

        {
            if (this.argument[index] == param) {
                ++index;
                size = this.argument[index];
                if (this.argument.length < size + ++index) {
                    return null;
                }
                value = new byte[size];
                i = 0;
                while (i < size) {
                    value[i] = this.argument[i + index];
                    ++i;
                }
                return value;
            }
            if (index + this.argument[index + 1] + 2 < this.argument.length) {
                index = index + this.argument[index + 1] + 2;
                continue;
            }
            return null;
lbl20:
            // 2 sources

            ** while (index < this.argument.length)
        }
lbl21:
        // 1 sources

        return null;
    }

    public String getDeviceName() {
        byte[] deviceByte;
        block3: {
            deviceByte = this.getArgument(2);
            try {
                if (deviceByte != null) break block3;
                return "";
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
                return new String(deviceByte);
            }
        }
        return new String(deviceByte, "UTF-8");
    }

    public String getDeviceTypeName() {
        byte[] deviceByte = this.getArgument(3);
        if (deviceByte == null) {
            return "";
        }
        return new String(deviceByte);
    }

    public String getMacAddress() {
        byte[] deviceByte = this.getArgument(1);
        if (deviceByte == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 6) {
            String s = Integer.toHexString(deviceByte[i] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
            if (i != 5) {
                sb.append(":");
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean IsDhcpEnable() {
        byte[] deviceByte = this.getArgument(4);
        if (deviceByte == null) {
            return false;
        }
        return deviceByte[0] != 0;
    }

    public String getIpAddress() {
        byte[] deviceByte = this.getArgument(5);
        if (deviceByte == null) {
            return "";
        }
        return this.getIp(deviceByte);
    }

    public String getSubnetMask() {
        byte[] deviceByte = this.getArgument(6);
        if (deviceByte == null) {
            return "";
        }
        return this.getIp(deviceByte);
    }

    public String getGateway() {
        byte[] deviceByte = this.getArgument(7);
        if (deviceByte == null) {
            return "";
        }
        return this.getIp(deviceByte);
    }

    public String getFirmwareId() {
        byte[] deviceByte = this.getArgument(8);
        if (deviceByte == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < deviceByte.length) {
            sb.append((char)deviceByte[i]);
            ++i;
        }
        return sb.toString();
    }

    public int getProductCode() {
        byte[] deviceByte = this.getArgument(9);
        int productCode = 0;
        if (deviceByte != null) {
            int shiftCount = 0;
            byte[] byArray = deviceByte;
            int n = deviceByte.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                productCode <<= shiftCount;
                productCode += b & 0xFF;
                shiftCount += 8;
                ++n2;
            }
            return productCode;
        }
        return -1;
    }

    public byte[] getHashCode() {
        return this.getArgument(12);
    }

    public boolean IsStandardNdm() {
        byte[] deviceByte = this.getArgument(10);
        if (deviceByte == null) {
            return false;
        }
        return deviceByte[0] != 0;
    }

    public int getErrorCode() {
        byte[] deviceByte = this.getArgument(11);
        if (deviceByte == null) {
            return -1;
        }
        return deviceByte[0];
    }

    private String getIp(byte[] buffer) {
        return String.valueOf(buffer[0] & 0xFF) + "." + (buffer[1] & 0xFF) + "." + (buffer[2] & 0xFF) + "." + (buffer[3] & 0xFF);
    }

    public void setDhcpEnable(boolean dhcp) {
        byte[] arg = new byte[]{dhcp ? (byte)1 : 0};
        this.setArgument(4, arg);
    }

    public void setIdent_arg(int timeout) {
        byte[] val_time = new byte[4];
        val_time[3] = (byte)(0xFF & timeout);
        val_time[2] = (byte)((0xFF00 & timeout) >> 8);
        val_time[1] = (byte)((0xFF0000 & timeout) >> 16);
        val_time[0] = (byte)((0xFF000000 & timeout) >> 24);
        this.Iden_arg[0] = 15;
        this.Iden_arg[1] = 4;
        int i = 0;
        while (i < 4) {
            this.Iden_arg[i + 2] = val_time[i];
            ++i;
        }
    }

    public void setLoc_arg(String loc) throws UnsupportedEncodingException {
        byte[] val_loc = loc.getBytes("UTF-8");
        int i = 0;
        while (i < val_loc.length) {
            this.Loc_arg[i] = val_loc[i];
            ++i;
        }
    }

    public void setRole_CAT(int role) {
        byte[] arg = new byte[1];
        if (role == 1) {
            arg[0] = 1;
        } else if (role == 0) {
            arg[0] = 0;
        }
        this.setArgument_CAT(17, arg);
    }

    public void setIpAddress(String ipAddress) {
        this.setArgument(5, this.ipToByteArray(ipAddress));
    }

    public void setSubnetMask(String subnetMask) {
        this.setArgument(6, this.ipToByteArray(subnetMask));
    }

    public void setGateway(String gateway) {
        this.setArgument(7, this.ipToByteArray(gateway));
    }

    public void setUsername(byte[] username) {
        this.Username = username;
        this.UsernameUsed = true;
    }

    public void setPassword(byte[] password) {
        this.Password = password;
        this.PasswordUsed = true;
    }

    private byte[] ipToByteArray(String ip) {
        byte[] address = new byte[4];
        String[] ipTab = ip.split("\\.");
        address[0] = (byte)Integer.parseInt(ipTab[0]);
        address[1] = (byte)Integer.parseInt(ipTab[1]);
        address[2] = (byte)Integer.parseInt(ipTab[2]);
        address[3] = (byte)Integer.parseInt(ipTab[3]);
        return address;
    }

    private void setArgument(int param, byte[] arg) {
        int index = 0;
        switch (param) {
            case 5: {
                index = 0;
                break;
            }
            case 6: {
                index = 4;
                break;
            }
            case 7: {
                index = 8;
                break;
            }
            case 4: {
                index = 12;
                break;
            }
            case 13: {
                this.argument[13] = 13;
                this.argument[14] = (byte)this.userNameLength;
                index = 15;
                break;
            }
            case 14: {
                this.argument[15 + this.userNameLength] = 14;
                this.argument[16 + this.userNameLength] = 16;
                index = 17 + this.userNameLength;
            }
        }
        int i = 0;
        while (i < arg.length) {
            this.argument[index + i] = arg[i];
            ++i;
        }
    }

    private void setArgument_CAT(int param, byte[] arg) {
        int index = 0;
        switch (param) {
            case 17: {
                index = 13;
                break;
            }
            case 13: {
                this.argument[14] = 13;
                this.argument[15] = (byte)this.userNameLength;
                index = 16;
                break;
            }
            case 14: {
                this.argument[16 + this.userNameLength] = 14;
                this.argument[17 + this.userNameLength] = 16;
                index = 18 + this.userNameLength;
            }
        }
        int i = 0;
        while (i < arg.length) {
            this.argument[index + i] = arg[i];
            ++i;
        }
    }
}

