/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.udap;

import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.config.TimeoutThread;
import fr.acksys.snmp.Oid;
import fr.acksys.udap.GetResponse;
import fr.acksys.udap.UdapResponse;
import fr.acksys.udap.UdapSocket;

public class Udap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConfig(Product targetProduct, boolean isuni) {
        String productMac = targetProduct.getUniqueIdString();
        String ipAddress = (String)targetProduct.getParam(Oid.IP_ADDRESS).getValue();
        if (productMac == null) {
            return;
        }
        boolean udapSuccess = false;
        UdapSocket udap = new UdapSocket(productMac);
        Object token = udap.getToken();
        udap.startReception(2);
        int i = 0;
        while (!udapSuccess && i < 3) {
            TimeoutThread timeOut1 = new TimeoutThread(token, 80);
            timeOut1.setName("Udap - updateConfig-tmo " + targetProduct.toString());
            timeOut1.start();
            Object object = token;
            synchronized (object) {
                if (isuni) {
                    udap.getConfig_unicast(productMac, ipAddress);
                } else {
                    udap.getConfig(productMac);
                }
                try {
                    token.wait();
                    while (!udap.IsEmpty()) {
                        UdapResponse response = udap.getResponse();
                        switch (response.getMethod()) {
                            case 2: {
                                GetResponse getResponse = (GetResponse)response;
                                if (!productMac.equalsIgnoreCase(getResponse.getSourceAddress())) break;
                                targetProduct.setParam(new Parameter(Oid.IP_ADDRESS, getResponse.getIpAddress()));
                                targetProduct.setParam(new Parameter(Oid.SUBNET_MASK, getResponse.getSubnetMask()));
                                targetProduct.setParam(new Parameter(Oid.GATEWAY, getResponse.getGateway()));
                                targetProduct.setParam(new Parameter(Oid.DHCP_STATE, getResponse.getDhcpEnabled()));
                                targetProduct.resetTTL();
                                timeOut1.stopTimeout();
                                udapSuccess = true;
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        udap.terminateReception(2);
    }
}

