/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.udap;

public class UdapDatagram {
    private byte[] buffer = new byte[20];

    public void setBytes(byte[] buffer) {
        int i = 0;
        while (i < 20) {
            this.buffer[i] = buffer[i];
            ++i;
        }
    }

    public String getDestinationAddress() {
        return String.valueOf(this.buffer[2] & 0xFF) + "." + (this.buffer[3] & 0xFF) + "." + (this.buffer[4] & 0xFF) + "." + (this.buffer[5] & 0xFF);
    }

    public String getSourceMacAddress() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 6) {
            String s = Integer.toHexString(this.buffer[10 + i] & 0xFF).toUpperCase();
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
            if (i != 5) {
                sb.append(":");
            }
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public void setDestinationAddress(byte[] address) {
        int i = 0;
        while (i < 8) {
            this.buffer[0 + i] = address[0 + i];
            ++i;
        }
    }

    public void setSourceAddress(byte[] address) {
        int i = 0;
        while (i < 8) {
            this.buffer[8 + i] = address[0 + i];
            ++i;
        }
    }

    public void setSequenceNumber(int seq) {
        this.buffer[16] = (byte)((seq & 0xFF00) >> 8);
        this.buffer[17] = (byte)(seq & 0xFF);
    }

    public void setType(int type) {
        this.buffer[18] = (byte)((type & 0xFF00) >> 8);
        this.buffer[19] = (byte)(type & 0xFF);
    }

    public byte[] getBytes() {
        return this.buffer;
    }
}

