/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.udap;

import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.discover.DatabaseDiscoverMethod;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.RememberableDialog;
import fr.acksys.udap.FrameBuilder;
import fr.acksys.udap.SocketedNetworkInterface;
import fr.acksys.udap.UcpDatagram;
import fr.acksys.udap.UdapDatagram;
import fr.acksys.udap.UdapResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class UdapSocket {
    public static final int UAP_CLASS = 65537;
    public static final int UDAP_DEFAULT_PORT = 17784;
    public static final int UDAP_TYPE_HOMEPLUG = 34939;
    public static final int UDAP_TYPE_UCP = 49153;
    public static final int UCP_METHOD_DISCOVER = 1;
    public static final int UCP_METHOD_GET_IP = 2;
    public static final int UCP_METHOD_SET_IP = 3;
    public static final int UCP_METHOD_IDEN_PRODUCT = 10;
    public static final int UCP_METHOD_SET_CAT = 11;
    public static final int UCP_METHOD_SET_CAT_LOC = 12;
    private static final LinkedList<UdapSocket> discoverList = new LinkedList();
    private static final LinkedList<UdapSocket> getIpList = new LinkedList();
    private static final LinkedList<UdapSocket> setIpList = new LinkedList();
    private static final LinkedList<UdapSocket> emptyList = new LinkedList();
    private static final LinkedList<UdapSocket> idenList = new LinkedList();
    private static final LinkedList<UdapSocket> catList = new LinkedList();
    private static final LinkedList<UdapSocket> locList = new LinkedList();
    private static Boolean firstInit = new Boolean(true);
    private ArrayList<UdapResponse> responseList = new ArrayList();
    private Object token;
    private String requesterMac;
    public static volatile boolean exit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UdapSocket(String mac) {
        this.requesterMac = mac;
        this.token = new Object();
        Boolean bl = firstInit;
        synchronized (bl) {
            if (firstInit.booleanValue()) {
                firstInit = false;
                SocketedNetworkInterface.setDefaultBroadcastPort(17784);
                SocketedNetworkInterface.setDefaultSocketTimeout(1000);
                SocketedNetworkInterface.initSocketsList();
                SocketedNetworkInterface.buildSocketsList();
            }
        }
    }

    private String udapSendBroadcast(final FrameBuilder trame, String destMac) {
        class SuccessCounter {
            private int count = 0;
            private String errMessages = "";

            public SuccessCounter(int i) {
                this.count = i;
            }

            public void increment() {
                ++this.count;
            }

            public void addErrorString(String s) {
                this.errMessages = String.valueOf(this.errMessages) + s + " - ";
            }

            public int getCount() {
                return this.count;
            }

            public String getErrorString() {
                return this.errMessages;
            }
        }
        final SuccessCounter successCount = new SuccessCounter(0);
        final UdapDatagram udap = new UdapDatagram();
        udap.setType(49153);
        if (destMac == null) {
            udap.setDestinationAddress(UdapSocket.createRAWAddr(true, "\u0000\u0000\u0000\u0000\u0000\u0000"));
        } else {
            udap.setDestinationAddress(UdapSocket.createEthernetAddr(false, destMac));
        }
        SocketedNetworkInterface.iterateKnownInterfaces(new NdmCallback(){
            {
            }

            @Override
            public void callback(Object ob) {
                SocketedNetworkInterface item = (SocketedNetworkInterface)ob;
                DatagramSocket socket = item.getTxSocket();
                udap.setSourceAddress(UdapSocket.createUDPAddr(false, item.getLocalAddress(), socket.getLocalPort()));
                trame.setUdapDatagram(udap);
                try {
                    byte[] tramebuf = trame.getBytes();
                    int tramebuf_len = tramebuf.length;
                    DatagramPacket dataSent = new DatagramPacket(tramebuf, tramebuf_len, item.getDestBroadcast());
                    item.send(dataSent);
                    successCount.increment();
                }
                catch (IOException e) {
                    successCount.addErrorString(e.getLocalizedMessage());
                    System.out.printf("==================UDP.SEND ==================\n", new Object[0]);
                    System.err.println(e + "   |" + item.getnetInterface().getName() + "|");
                }
            }
        });
        if (successCount.getCount() > 0) {
            return null;
        }
        return successCount.getErrorString();
    }

    private String udapSendUnicast(final FrameBuilder trame, final String destMac, final String IP) {
        class SuccessCounter {
            private int count = 0;
            private String errMessages = "";

            public SuccessCounter(int i) {
                this.count = i;
            }

            public void increment() {
                ++this.count;
            }

            public void addErrorString(String s) {
                this.errMessages = String.valueOf(this.errMessages) + s + " - ";
            }

            public int getCount() {
                return this.count;
            }

            public String getErrorString() {
                return this.errMessages;
            }
        }
        final SuccessCounter successCount = new SuccessCounter(0);
        final UdapDatagram udap = new UdapDatagram();
        udap.setType(49153);
        if (destMac == null) {
            udap.setDestinationAddress(UdapSocket.createRAWAddr(true, "\u0000\u0000\u0000\u0000\u0000\u0000"));
        } else {
            udap.setDestinationAddress(UdapSocket.createEthernetAddr(false, destMac));
        }
        SocketedNetworkInterface.iterateKnownInterfaces(new NdmCallback(){
            {
            }

            @Override
            public void callback(Object ob) {
                SocketedNetworkInterface item = (SocketedNetworkInterface)ob;
                DatagramSocket socket = item.getTxSocket();
                udap.setSourceAddress(UdapSocket.createUDPAddr(false, item.getLocalAddress(), socket.getLocalPort()));
                trame.setUdapDatagram(udap);
                try {
                    DatagramPacket dataSent;
                    byte[] tramebuf = trame.getBytes();
                    int tramebuf_len = tramebuf.length;
                    if (destMac == null) {
                        dataSent = new DatagramPacket(tramebuf, tramebuf_len, item.getDestBroadcast());
                    } else {
                        short PrefixLength = item.getnetInterface().getInterfaceAddresses().get(0).getNetworkPrefixLength();
                        if (UdapSocket.isValideIp(IP, item.getLocalAddress(), UdapSocket.calcMaskByPrefixLength(PrefixLength))) {
                            InetSocketAddress unicast = new InetSocketAddress(InetAddress.getByName(IP), 17784);
                            dataSent = new DatagramPacket(tramebuf, tramebuf_len, unicast);
                        } else {
                            dataSent = new DatagramPacket(tramebuf, tramebuf_len, item.getDestBroadcast());
                        }
                    }
                    item.send(dataSent);
                    successCount.increment();
                }
                catch (IOException e) {
                    successCount.addErrorString(e.getLocalizedMessage());
                    System.err.println(e + "   |" + item.getnetInterface().getName() + "|");
                }
            }
        });
        if (successCount.getCount() > 0) {
            return null;
        }
        return successCount.getErrorString();
    }

    public static boolean isValideIp(String ip, String ip2, String netmask2) {
        boolean resultat = false;
        String[] currentIp = ip.split("\\.");
        String[] currentNm2 = netmask2.split("\\.");
        String[] currentIp2 = ip2.split("\\.");
        int i = 0;
        while (i < 4) {
            int Ip2;
            int Nm;
            int Ip = Integer.parseInt(currentIp[i]);
            boolean bl = resultat = (Ip & (Nm = Integer.parseInt(currentNm2[i]))) == ((Ip2 = Integer.parseInt(currentIp2[i])) & Nm);
            if (!resultat) break;
            ++i;
        }
        return resultat;
    }

    private static String calcMaskByPrefixLength(int length) {
        int mask = -1 << 32 - length;
        int partsNum = 4;
        int bitsOfPart = 8;
        int[] maskParts = new int[partsNum];
        int selector = 255;
        int i = 0;
        while (i < maskParts.length) {
            int pos = maskParts.length - 1 - i;
            maskParts[pos] = mask >> i * bitsOfPart & selector;
            ++i;
        }
        String result = "";
        result = String.valueOf(result) + maskParts[0];
        int i2 = 1;
        while (i2 < maskParts.length) {
            result = String.valueOf(result) + "." + maskParts[i2];
            ++i2;
        }
        return result;
    }

    public void getConfig(String macAddress) {
        FrameBuilder trame = new FrameBuilder();
        UcpDatagram ucp = new UcpDatagram();
        ucp.setFlag(true);
        ucp.setInterfaceClass(65537);
        ucp.setMethod(2, null);
        trame.setUcpDatagram(ucp);
        final String localizedErrorMessage = this.udapSendBroadcast(trame, macAddress);
        if (localizedErrorMessage != null) {
            if (!DatabaseDiscoverMethod.ctr_message) {
                IgUtils.ExecuteOnSwingThread(new Runnable(){

                    @Override
                    public void run() {
                        new RememberableDialog(null, localizedErrorMessage).setVisible(true);
                    }
                });
            }
            DatabaseDiscoverMethod.ctr_message = true;
        }
    }

    public void getConfig_unicast(String macAddress, String IP) {
        FrameBuilder trame = new FrameBuilder();
        UcpDatagram ucp = new UcpDatagram();
        ucp.setFlag(true);
        ucp.setInterfaceClass(65537);
        ucp.setMethod(2, null);
        trame.setUcpDatagram(ucp);
        final String localizedErrorMessage = this.udapSendUnicast(trame, macAddress, IP);
        if (localizedErrorMessage != null) {
            if (!DatabaseDiscoverMethod.ctr_message) {
                IgUtils.ExecuteOnSwingThread(new Runnable(){

                    @Override
                    public void run() {
                        new RememberableDialog(null, localizedErrorMessage).setVisible(true);
                    }
                });
            }
            DatabaseDiscoverMethod.ctr_message = true;
        }
    }

    public String discover() {
        FrameBuilder trame = new FrameBuilder();
        UcpDatagram ucp = new UcpDatagram();
        ucp.setFlag(true);
        ucp.setInterfaceClass(65537);
        ucp.setMethod(1, null);
        trame.setUcpDatagram(ucp);
        String localizedErrorMessage = this.udapSendBroadcast(trame, null);
        return localizedErrorMessage;
    }

    public boolean IsEmpty() {
        return this.responseList.size() == 0;
    }

    public UdapResponse getResponse() {
        UdapResponse response = null;
        if (this.responseList.size() > 0) {
            response = this.responseList.remove(0);
        }
        return response;
    }

    public Object getToken() {
        return this.token;
    }

    private static byte[] createAddr(boolean broadcast, int type, byte[] address) {
        byte[] fullAddress = new byte[8];
        fullAddress[0] = broadcast ? (byte)1 : 0;
        fullAddress[1] = (byte)type;
        int i = 0;
        while (i < 6) {
            fullAddress[2 + i] = address[0 + i];
            ++i;
        }
        return fullAddress;
    }

    public static byte[] createUDPAddr(boolean broadcast, String IPAddress, int port) {
        byte[] address = new byte[6];
        StringTokenizer parse = new StringTokenizer(IPAddress, ".");
        address[0] = (byte)Integer.parseInt(parse.nextToken());
        address[1] = (byte)Integer.parseInt(parse.nextToken());
        address[2] = (byte)Integer.parseInt(parse.nextToken());
        address[3] = (byte)Integer.parseInt(parse.nextToken());
        address[4] = (byte)((port & 0xFF00) >> 8);
        address[5] = (byte)(port & 0xFF);
        return UdapSocket.createAddr(broadcast, 2, address);
    }

    public static byte[] createEthernetAddr(boolean broadcast, String macAddress) {
        byte[] macByte = new byte[6];
        String[] strList = macAddress.split(":");
        int i = 0;
        while (i < 6) {
            macByte[i] = (byte)Integer.parseInt(strList[i], 16);
            ++i;
        }
        return UdapSocket.createAddr(broadcast, 1, macByte);
    }

    public static byte[] createRAWAddr(boolean broadcast, String RawId) {
        return UdapSocket.createAddr(broadcast, 0, RawId.getBytes());
    }

    public void setIdent_udap(String macAddress, int timeout) {
        FrameBuilder frame = new FrameBuilder();
        UcpDatagram ucp = new UcpDatagram();
        ucp.setFlag(false);
        ucp.setInterfaceClass(65537);
        ucp.setMethod(10, null);
        ucp.setIdent_arg(timeout);
        frame.setUcpDatagram(ucp);
        final String localizedErrorMessage = this.udapSendBroadcast(frame, macAddress);
        if (localizedErrorMessage != null) {
            IgUtils.ExecuteOnSwingThread(new Runnable(){

                @Override
                public void run() {
                    new RememberableDialog(null, localizedErrorMessage).setVisible(true);
                }
            });
        }
    }

    public void UDAPLocConfig_CAT(String macAddress, String location) throws UnsupportedEncodingException {
        FrameBuilder frame = new FrameBuilder();
        UcpDatagram ucp = new UcpDatagram();
        ucp.setFlag(false);
        ucp.setInterfaceClass(65537);
        ucp.setMethod(12, null);
        ucp.setLoc_arg(location);
        frame.setUcpDatagram(ucp);
        final String localizedErrorMessage = this.udapSendBroadcast(frame, macAddress);
        if (localizedErrorMessage != null) {
            IgUtils.ExecuteOnSwingThread(new Runnable(){

                @Override
                public void run() {
                    new RememberableDialog(null, localizedErrorMessage).setVisible(true);
                }
            });
        }
    }

    public void setConfig(String macAddress, String ipAddress, String subnetMask, String gateway, int dhcpState, byte[] hashCode, char[] password) {
        FrameBuilder frame = new FrameBuilder();
        UcpDatagram ucp = new UcpDatagram();
        ucp.setFlag(true);
        ucp.setInterfaceClass(65537);
        if (hashCode != null && password != null) {
            ucp.setMethod(3, "");
        } else {
            ucp.setMethod(3, null);
        }
        ucp.setIpAddress(ipAddress);
        ucp.setSubnetMask(subnetMask);
        ucp.setGateway(gateway);
        ucp.setDhcpEnable(dhcpState == 2);
        if (hashCode != null && password != null) {
            byte[] tab = new byte[password.length + hashCode.length];
            int index = 0;
            int i = 0;
            while (i < password.length) {
                tab[index] = (byte)password[i];
                ++index;
                ++i;
            }
            i = 0;
            while (i < hashCode.length) {
                tab[index] = hashCode[i];
                ++index;
                ++i;
            }
            try {
                ucp.setPassword(MessageDigest.getInstance("MD5").digest(tab));
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("no MD5 support in this VM");
            }
        }
        frame.setUcpDatagram(ucp);
        final String localizedErrorMessage = this.udapSendBroadcast(frame, macAddress);
        if (localizedErrorMessage != null) {
            IgUtils.ExecuteOnSwingThread(new Runnable(){

                @Override
                public void run() {
                    new RememberableDialog(null, localizedErrorMessage).setVisible(true);
                }
            });
        }
    }

    public void setConfig_CAT(String macAddress, String ipAddress, String subnetMask, String gateway, int dhcpState, int role, byte[] hashCode, char[] password) {
        FrameBuilder frame = new FrameBuilder();
        UcpDatagram ucp = new UcpDatagram();
        ucp.setFlag(true);
        ucp.setInterfaceClass(65537);
        if (hashCode != null && password != null) {
            ucp.setMethod(11, "");
        } else {
            ucp.setMethod(11, null);
        }
        ucp.setIpAddress(ipAddress);
        ucp.setSubnetMask(subnetMask);
        ucp.setGateway(gateway);
        ucp.setDhcpEnable(dhcpState == 2);
        ucp.setRole_CAT(role);
        if (hashCode != null && password != null) {
            byte[] tab = new byte[password.length + hashCode.length];
            int index = 0;
            int i = 0;
            while (i < password.length) {
                tab[index] = (byte)password[i];
                ++index;
                ++i;
            }
            i = 0;
            while (i < hashCode.length) {
                tab[index] = hashCode[i];
                ++index;
                ++i;
            }
            try {
                ucp.setPassword(MessageDigest.getInstance("MD5").digest(tab));
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("no MD5 support in this VM");
            }
        }
        frame.setUcpDatagram(ucp);
        final String localizedErrorMessage = this.udapSendBroadcast(frame, macAddress);
        if (localizedErrorMessage != null) {
            IgUtils.ExecuteOnSwingThread(new Runnable(){

                @Override
                public void run() {
                    new RememberableDialog(null, localizedErrorMessage).setVisible(true);
                }
            });
        }
    }

    static Thread getReceiveThread(final SocketedNetworkInterface ifSocket) {
        return new Thread(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    private static FrameBuilder scanParseProduct(DatagramPacket datagram) {
        byte[] data = datagram.getData();
        if (datagram.getLength() == 0) {
            return null;
        }
        int length = datagram.getLength() - 20;
        byte[] udapByte = new byte[20];
        byte[] ucpByte = new byte[length];
        int i = 0;
        while (i < 20) {
            udapByte[i] = data[i];
            ++i;
        }
        i = 0;
        while (i < length) {
            ucpByte[i] = data[i + 20];
            ++i;
        }
        UdapDatagram udapData = new UdapDatagram();
        udapData.setBytes(udapByte);
        UcpDatagram ucpData = new UcpDatagram();
        ucpData.setBytes(ucpByte);
        FrameBuilder trameBuilder = new FrameBuilder();
        trameBuilder.setUcpDatagram(ucpData);
        trameBuilder.setUdapDatagram(udapData);
        trameBuilder.setInetAddress(datagram.getAddress());
        return trameBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateReception(int ucpMethod) {
        LinkedList<UdapSocket> udapSocketsList;
        switch (ucpMethod) {
            case 1: {
                udapSocketsList = discoverList;
                break;
            }
            case 3: {
                udapSocketsList = setIpList;
                break;
            }
            case 2: {
                udapSocketsList = getIpList;
                break;
            }
            case 10: {
                udapSocketsList = idenList;
                break;
            }
            case 11: {
                udapSocketsList = catList;
                break;
            }
            case 12: {
                udapSocketsList = locList;
                break;
            }
            default: {
                return;
            }
        }
        LinkedList<UdapSocket> linkedList = udapSocketsList;
        synchronized (linkedList) {
            udapSocketsList.remove(this);
        }
        this.responseList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReception(int ucpMethod) {
        LinkedList<UdapSocket> udapSocketsList;
        switch (ucpMethod) {
            case 1: {
                udapSocketsList = discoverList;
                break;
            }
            case 3: {
                udapSocketsList = setIpList;
                break;
            }
            case 2: {
                udapSocketsList = getIpList;
                break;
            }
            case 10: {
                udapSocketsList = idenList;
                break;
            }
            case 11: {
                udapSocketsList = catList;
                break;
            }
            case 12: {
                udapSocketsList = locList;
                break;
            }
            default: {
                return;
            }
        }
        LinkedList<UdapSocket> linkedList = udapSocketsList;
        synchronized (linkedList) {
            udapSocketsList.add(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkFirewall() {
        InetSocketAddress testDest;
        byte[] bcast = new byte[]{-1, -1, -1, -1};
        try {
            testDest = new InetSocketAddress(InetAddress.getByAddress(bcast), 17784);
        }
        catch (IOException e1) {
            System.out.println("Cannot build broadcast address -- JVM blocked by firewall?");
            return false;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> addr = networkInterface.getInetAddresses();
                while (addr.hasMoreElements()) {
                    InetAddress interfaceAddress = addr.nextElement();
                    if (interfaceAddress == null || !(interfaceAddress instanceof Inet4Address)) continue;
                    DatagramSocket socket = new DatagramSocket(null);
                    socket.bind(new InetSocketAddress(interfaceAddress, 0));
                    try {
                        DatagramPacket datagram = new DatagramPacket(bcast, bcast.length, testDest);
                        socket.send(datagram);
                    }
                    catch (Exception e) {
                        System.out.println("Cannot send to broadcast address -- JVM blocked by firewall?");
                        return false;
                    }
                }
            }
            return true;
        }
        catch (SocketException e) {
            e.printStackTrace();
            return false;
        }
    }

    static /* synthetic */ FrameBuilder access$1(DatagramPacket datagramPacket) {
        return UdapSocket.scanParseProduct(datagramPacket);
    }

    static /* synthetic */ LinkedList access$2() {
        return discoverList;
    }

    static /* synthetic */ LinkedList access$3() {
        return setIpList;
    }

    static /* synthetic */ LinkedList access$4() {
        return getIpList;
    }

    static /* synthetic */ LinkedList access$5() {
        return idenList;
    }

    static /* synthetic */ LinkedList access$6() {
        return catList;
    }

    static /* synthetic */ LinkedList access$7() {
        return locList;
    }

    static /* synthetic */ LinkedList access$8() {
        return emptyList;
    }

    static /* synthetic */ String access$9(UdapSocket udapSocket) {
        return udapSocket.requesterMac;
    }

    static /* synthetic */ Object access$10(UdapSocket udapSocket) {
        return udapSocket.token;
    }

    static /* synthetic */ ArrayList access$11(UdapSocket udapSocket) {
        return udapSocket.responseList;
    }
}

