/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.utils;

import fr.acksys.custom.Company;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.JLabel;

public class JSwitchBox
extends AbstractButton {
    private static final long serialVersionUID = 1L;
    private Color colorBright = new Color(220, 220, 220);
    private Color colorDark = new Color(150, 150, 150);
    private Color light = new Color(220, 220, 220);
    private Font font = new JLabel().getFont();
    private int gap = 0;
    private int globalWitdh = 0;
    private final String trueLabel;
    private final String falseLabel;
    private Dimension thumbBounds;
    private int max;

    public JSwitchBox(String trueLabel, String falseLabel) {
        this.trueLabel = trueLabel;
        this.falseLabel = falseLabel;
        double trueLenth = this.getFontMetrics(this.getFont()).stringWidth(trueLabel);
        double falseLenght = this.getFontMetrics(this.getFont()).stringWidth(falseLabel);
        this.max = (int)Math.max(trueLenth, falseLenght) / 2;
        this.gap = Math.max(1, 1 + (int)Math.abs(trueLenth - falseLenght));
        this.thumbBounds = new Dimension(this.max + this.gap * 2, 20);
        this.globalWitdh = this.max + this.thumbBounds.width + this.gap * 2;
        this.setModel(new DefaultButtonModel());
        this.setSelected(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (new Rectangle(JSwitchBox.this.getPreferredSize()).contains(e.getPoint())) {
                    JSwitchBox.this.setSelected(!JSwitchBox.this.isSelected());
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.globalWitdh, this.thumbBounds.height);
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setText(this.trueLabel);
            this.setBackground(Company.COLUMN_TITLE_COLOR1);
        } else {
            this.setBackground(Company.COLUMN_TITLE_COLOR2);
            this.setText(this.falseLabel);
        }
        super.setSelected(b);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        super.setHorizontalTextPosition(10);
        super.setVerticalTextPosition(0);
    }

    @Override
    public int getHeight() {
        return this.getPreferredSize().height;
    }

    @Override
    public int getWidth() {
        return this.getPreferredSize().width;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRoundRect(1, 1, this.getWidth() - 3, this.getHeight() - 2, 2, 2);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        g2.drawRoundRect(1, 1, this.getWidth() - 3, this.getHeight() - 3, 2, 2);
        g2.setColor(Color.white);
        g2.drawRoundRect(2, 2, this.getWidth() - 5, this.getHeight() - 5, 2, 2);
        int x = 0;
        int lx = 0;
        if (this.isSelected()) {
            lx = this.thumbBounds.width;
        } else {
            x = this.thumbBounds.width;
        }
        int y = 0;
        int w = this.thumbBounds.width;
        int h = this.thumbBounds.height;
        g2.setPaint(new GradientPaint(x, (int)((double)y - 0.1 * (double)h), this.colorDark, x, (int)((double)y + 1.2 * (double)h), this.light));
        g2.fillRect(x, y, w, h);
        g2.setPaint(new GradientPaint(x, (int)((double)y + 0.65 * (double)h), this.light, x, (int)((double)y + 1.3 * (double)h), this.colorDark));
        g2.fillRect(x, (int)((double)y + 0.65 * (double)h), w, (int)((double)h - 0.65 * (double)h));
        if (w > 14) {
            int size = 10;
            g2.setColor(this.colorBright);
            g2.fillRect(x + w / 2 - size / 2, y + h / 2 - size / 2, size, size);
            g2.setColor(new Color(120, 120, 120));
            g2.fillRect(x + w / 2 - 4, h / 2 - 4, 2, 2);
            g2.fillRect(x + w / 2 - 1, h / 2 - 4, 2, 2);
            g2.fillRect(x + w / 2 + 2, h / 2 - 4, 2, 2);
            g2.setColor(this.colorDark);
            g2.fillRect(x + w / 2 - 4, h / 2 - 2, 2, 6);
            g2.fillRect(x + w / 2 - 1, h / 2 - 2, 2, 6);
            g2.fillRect(x + w / 2 + 2, h / 2 - 2, 2, 6);
            g2.setColor(new Color(170, 170, 170));
            g2.fillRect(x + w / 2 - 4, h / 2 + 2, 2, 2);
            g2.fillRect(x + w / 2 - 1, h / 2 + 2, 2, 2);
            g2.fillRect(x + w / 2 + 2, h / 2 + 2, 2, 2);
        }
        g2.setColor(Color.black);
        g2.drawRoundRect(x, y, w - 1, h - 1, 2, 2);
        g2.setColor(Color.white);
        g2.drawRoundRect(x + 1, y + 1, w - 3, h - 3, 2, 2);
        g2.setColor(Color.black.darker());
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(this.getFont());
        g2.drawString(this.getText(), lx + this.gap, y + h / 2 + h / 4);
    }
}

