/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.net.io.FromNetASCIIOutputStream;
import org.apache.commons.net.io.ToNetASCIIInputStream;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPErrorPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPReadRequestPacket;
import org.apache.commons.net.tftp.TFTPWriteRequestPacket;

public class TFTPClient
extends TFTP {
    public static final int DEFAULT_MAX_TIMEOUTS = 5;
    private int __maxTimeouts = 5;
    private int __packetNumber = 0;

    public void setMaxTimeouts(int numTimeouts) {
        this.__maxTimeouts = numTimeouts < 1 ? 1 : numTimeouts;
    }

    public int getMaxTimeouts() {
        return this.__maxTimeouts;
    }

    public int receiveFile(String filename, int mode, OutputStream output, InetAddress host, int port) throws IOException {
        TFTPPacket received = null;
        TFTPAckPacket ack = new TFTPAckPacket(host, port, 0);
        this.beginBufferedOps(false);
        int bytesRead = 0;
        int hostPort = 0;
        int lastBlock = 0;
        int dataLength = 0;
        int block = 1;
        if (mode == 0) {
            output = new FromNetASCIIOutputStream(output);
        }
        TFTPPacket sent = new TFTPReadRequestPacket(host, port, filename, mode);
        block10: do {
            block17: {
                TFTPErrorPacket error;
                this.bufferedSend(sent);
                block11: while (true) {
                    int timeouts = 0;
                    while (timeouts < this.__maxTimeouts) {
                        try {
                            received = this.bufferedReceive();
                            break;
                        }
                        catch (SocketException e) {
                            if (++timeouts < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (InterruptedIOException e) {
                            if (++timeouts < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (TFTPPacketException e) {
                            this.endBufferedOps();
                            throw new IOException("Bad packet: " + e.getMessage());
                        }
                    }
                    if (lastBlock == 0) {
                        hostPort = received.getPort();
                        ack.setPort(hostPort);
                        if (!host.equals(received.getAddress())) {
                            host = received.getAddress();
                            ack.setAddress(host);
                            sent.setAddress(host);
                        }
                    }
                    if (!host.equals(received.getAddress()) || received.getPort() != hostPort) break;
                    switch (received.getType()) {
                        case 5: {
                            error = (TFTPErrorPacket)received;
                            this.endBufferedOps();
                            throw new IOException("Error code " + error.getError() + " received: " + error.getMessage());
                        }
                        case 3: {
                            TFTPDataPacket data = (TFTPDataPacket)received;
                            dataLength = data.getDataLength();
                            lastBlock = data.getBlockNumber();
                            if (lastBlock == block) {
                                try {
                                    output.write(data.getData(), data.getDataOffset(), dataLength);
                                }
                                catch (IOException e) {
                                    error = new TFTPErrorPacket(host, hostPort, 3, "File write failed.");
                                    this.bufferedSend(error);
                                    this.endBufferedOps();
                                    throw e;
                                }
                                ++block;
                                break block17;
                            }
                            this.discardPackets();
                            if (lastBlock != block - 1) continue block11;
                            continue block10;
                        }
                        default: {
                            this.endBufferedOps();
                            throw new IOException("Received unexpected packet type.");
                        }
                    }
                    break;
                }
                error = new TFTPErrorPacket(received.getAddress(), received.getPort(), 5, "Unexpected host or port.");
                this.bufferedSend(error);
                continue;
            }
            ack.setBlockNumber(lastBlock);
            sent = ack;
            bytesRead += dataLength;
        } while (dataLength == 512);
        this.bufferedSend(sent);
        this.endBufferedOps();
        return bytesRead;
    }

    public int receiveFile(String filename, int mode, OutputStream output, String hostname, int port) throws UnknownHostException, IOException {
        return this.receiveFile(filename, mode, output, InetAddress.getByName(hostname), port);
    }

    public int receiveFile(String filename, int mode, OutputStream output, InetAddress host) throws IOException {
        return this.receiveFile(filename, mode, output, host, 69);
    }

    public int receiveFile(String filename, int mode, OutputStream output, String hostname) throws UnknownHostException, IOException {
        return this.receiveFile(filename, mode, output, InetAddress.getByName(hostname), 69);
    }

    public void sendFile(String filename, int mode, InputStream input, InetAddress host, int port) throws IOException {
        TFTPPacket received = null;
        TFTPDataPacket data = new TFTPDataPacket(host, port, 0, this._sendBuffer, 4, 0);
        boolean justStarted = true;
        this.__packetNumber = 0;
        this.beginBufferedOps(this._tftpfast);
        int totalThisPacket = 0;
        int bytesRead = 0;
        int hostPort = 0;
        int lastBlock = 0;
        int dataLength = 0;
        int block = 0;
        boolean lastAckWait = false;
        if (mode == 0) {
            input = new ToNetASCIIInputStream(input);
        }
        TFTPPacket sent = new TFTPWriteRequestPacket(host, port, filename, mode);
        block9: do {
            block22: {
                TFTPErrorPacket error;
                this.bufferedSend(sent);
                block10: while (true) {
                    int timeouts = 0;
                    while (timeouts < this.__maxTimeouts) {
                        try {
                            received = this.bufferedReceive();
                            break;
                        }
                        catch (SocketException e) {
                            if (++timeouts >= this.__maxTimeouts) {
                                this.endBufferedOps();
                                throw new IOException("Connection timed out.");
                            }
                            this.bufferedSend(sent);
                        }
                        catch (InterruptedIOException e) {
                            if (++timeouts >= this.__maxTimeouts) {
                                this.endBufferedOps();
                                throw new IOException("Connection timed out.");
                            }
                            this.bufferedSend(sent);
                        }
                        catch (TFTPPacketException e) {
                            this.endBufferedOps();
                            throw new IOException("Bad packet: " + e.getMessage());
                        }
                    }
                    if (justStarted) {
                        justStarted = false;
                        hostPort = received.getPort();
                        data.setPort(hostPort);
                        if (!host.equals(received.getAddress())) {
                            host = received.getAddress();
                            data.setAddress(host);
                            sent.setAddress(host);
                        }
                    }
                    if (!host.equals(received.getAddress()) || received.getPort() != hostPort) break;
                    switch (received.getType()) {
                        case 5: {
                            error = (TFTPErrorPacket)received;
                            this.endBufferedOps();
                            throw new IOException("Error code " + error.getError() + " received: " + error.getMessage());
                        }
                        case 6: {
                            this._tftpfast = true;
                            ++block;
                            ++this.__packetNumber;
                            this.beginBufferedOps(this._tftpfast);
                            break block22;
                        }
                        case 4: {
                            TFTPAckPacket ack = (TFTPAckPacket)received;
                            lastBlock = ack.getBlockNumber();
                            if (block == 65536) {
                                block = 0;
                            }
                            if (lastBlock == block) {
                                ++block;
                                ++this.__packetNumber;
                                if (lastAckWait) {
                                    break block9;
                                }
                                break block22;
                            }
                            this.discardPackets();
                            if (lastBlock != block - 1) continue block10;
                            continue block9;
                        }
                        default: {
                            this.endBufferedOps();
                            throw new IOException("Received unexpected packet type.");
                        }
                    }
                    break;
                }
                error = new TFTPErrorPacket(received.getAddress(), received.getPort(), 5, "Unexpected host or port.");
                this.bufferedSend(error);
                continue;
            }
            int seg_size = this._tftpfast ? 1468 : 512;
            dataLength = seg_size;
            int offset = 4;
            totalThisPacket = 0;
            while (dataLength > 0 && (bytesRead = input.read(this._sendBuffer, offset, dataLength)) > 0) {
                offset += bytesRead;
                dataLength -= bytesRead;
                totalThisPacket += bytesRead;
            }
            if (totalThisPacket < seg_size) {
                lastAckWait = true;
            }
            data.setBlockNumber(block);
            data.setData(this._sendBuffer, 4, totalThisPacket, this._tftpfast);
            sent = data;
        } while (totalThisPacket > 0 || lastAckWait);
        this.endBufferedOps();
    }

    public void sendFile(String filename, int mode, InputStream input, String hostname, int port) throws UnknownHostException, IOException {
        this.sendFile(filename, mode, input, InetAddress.getByName(hostname), port);
    }

    public void sendFile(String filename, int mode, InputStream input, InetAddress host) throws IOException {
        this.sendFile(filename, mode, input, host, 69);
    }

    public void sendFile(String filename, int mode, InputStream input, String hostname) throws UnknownHostException, IOException {
        this.sendFile(filename, mode, input, InetAddress.getByName(hostname), 69);
    }

    public int getCurrentPacket() {
        int currentPacket = this.__packetNumber;
        if (this._tftpfast) {
            currentPacket = (int)Math.round((double)this.__packetNumber * 1468.0 / 512.0);
        }
        return currentPacket;
    }
}

