/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.commons.net.tftp.TFTPClient;

public class TFTPClientApp {
    private int intPort;
    private InetAddress inetAddr;
    private String strFileName;
    private static final int SLEEP_MILLISECS = 1000;
    private static final int GENERATE_BUF_SIZE = 1000;
    private TFTPClient tftp;
    private ByteArrayInputStream inputStream;
    private byte[] inputBuf;
    private ByteArrayOutputStream outputStream;

    public TFTPClientApp() {
        this("10.115.1.10", 2269, "dummySend.txt");
    }

    public TFTPClientApp(String addr, int port, String fName) {
        try {
            this.inetAddr = InetAddress.getByName(addr);
            this.strFileName = fName;
            this.intPort = port;
            this.tftp = new TFTPClient();
            this.tftp.open(this.intPort);
            this.inputBuf = new byte[1000];
            int i = 0;
            while (i < 999) {
                this.inputBuf[i] = (byte)(i % 26 + 97);
                ++i;
            }
            i = 52;
            while (i < 999) {
                this.inputBuf[i] = 10;
                i += 52;
            }
            this.inputBuf[999] = 0;
            this.inputStream = new ByteArrayInputStream(this.inputBuf);
            this.outputStream = new ByteArrayOutputStream();
        }
        catch (Exception e) {
            System.out.println("Exception in opening TFTP connection: " + e.getMessage());
        }
    }

    public void pause() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendFile() {
        try {
            this.tftp.sendFile(this.strFileName, 0, (InputStream)this.inputStream, this.inetAddr, this.intPort);
            System.out.println("File sent successfully");
            this.inputStream.reset();
        }
        catch (Exception e) {
            System.out.println("Exception in sending file: " + e.getMessage());
        }
    }

    public void receiveFile() {
        try {
            this.tftp.receiveFile(this.strFileName, 0, (OutputStream)this.outputStream, this.inetAddr, this.intPort);
            System.out.println("File received successfully:");
            System.out.println(this.outputStream.toString());
            this.outputStream.reset();
        }
        catch (Exception e) {
            System.out.println("Exception in receiving file: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        TFTPClientApp app = null;
        app = args.length >= 3 ? new TFTPClientApp(args[0], Integer.parseInt(args[1]), args[2]) : new TFTPClientApp();
        while (true) {
            app.sendFile();
            app.pause();
            app.receiveFile();
            app.pause();
        }
    }
}

