/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;

public final class TFTPOAckPacket
extends TFTPPacket {
    int _blockNumber;

    public TFTPOAckPacket(InetAddress destination, int port, int blockNumber) {
        super(6, destination, port);
        this._blockNumber = 0;
    }

    TFTPOAckPacket(DatagramPacket datagram) throws TFTPPacketException {
        super(6, datagram.getAddress(), datagram.getPort());
        byte[] data = datagram.getData();
        if (this.getType() != data[1]) {
            throw new TFTPPacketException("O TFTP operator code does not match type." + this.getType() + " > " + data[1]);
        }
        this._blockNumber = 0;
    }

    @Override
    DatagramPacket _newDatagram(DatagramPacket datagram, byte[] data) {
        data[0] = 0;
        data[1] = (byte)this._type;
        datagram.setAddress(this._address);
        datagram.setPort(this._port);
        datagram.setData(data);
        datagram.setLength(4);
        return datagram;
    }

    @Override
    public DatagramPacket newDatagram() {
        byte[] data = new byte[4];
        data[0] = 0;
        data[1] = (byte)this._type;
        return new DatagramPacket(data, data.length, this._address, this._port);
    }

    public int getBlockNumber() {
        return this._blockNumber;
    }

    public void setBlockNumber(int blockNumber) {
        this._blockNumber = blockNumber;
    }
}

