/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;

public abstract class TFTPRequestPacket
extends TFTPPacket {
    static final String[] _modeStrings = new String[]{"netascii", "octet"};
    static final byte[][] _modeBytes;
    int _mode;
    String _filename;
    static final byte[] _blkBytes;
    static final byte[] _octBytes;

    static {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[9];
        byArray[0] = 110;
        byArray[1] = 101;
        byArray[2] = 116;
        byArray[3] = 97;
        byArray[4] = 115;
        byArray[5] = 99;
        byArray[6] = 105;
        byArray[7] = 105;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[0] = 111;
        byArray2[1] = 99;
        byArray2[2] = 116;
        byArray2[3] = 101;
        byArray2[4] = 116;
        byArrayArray[1] = byArray2;
        _modeBytes = byArrayArray;
        byte[] byArray3 = new byte[8];
        byArray3[0] = 98;
        byArray3[1] = 108;
        byArray3[2] = 107;
        byArray3[3] = 115;
        byArray3[4] = 105;
        byArray3[5] = 122;
        byArray3[6] = 101;
        _blkBytes = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[0] = 49;
        byArray4[1] = 52;
        byArray4[2] = 54;
        byArray4[3] = 56;
        _octBytes = byArray4;
    }

    TFTPRequestPacket(InetAddress destination, int port, int type, String filename, int mode) {
        super(type, destination, port);
        this._filename = filename;
        this._mode = mode;
    }

    TFTPRequestPacket(int type, DatagramPacket datagram) throws TFTPPacketException {
        super(type, datagram.getAddress(), datagram.getPort());
        byte[] data = datagram.getData();
        if (this.getType() != data[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        StringBuffer buffer = new StringBuffer();
        int index = 2;
        int length = datagram.getLength();
        while (index < length && data[index] != 0) {
            buffer.append((char)data[index]);
            ++index;
        }
        this._filename = buffer.toString();
        if (index >= length) {
            throw new TFTPPacketException("Bad filename and mode format.");
        }
        buffer.setLength(0);
        ++index;
        while (index < length && data[index] != 0) {
            buffer.append((char)data[index]);
            ++index;
        }
        String mode = buffer.toString().toLowerCase();
        length = _modeStrings.length;
        index = 0;
        while (index < length) {
            if (mode.equals(_modeStrings[index])) {
                this._mode = index;
                break;
            }
            ++index;
        }
        if (index >= length) {
            throw new TFTPPacketException("Unrecognized TFTP transfer mode: " + mode);
        }
    }

    @Override
    final DatagramPacket _newDatagram(DatagramPacket datagram, byte[] data) {
        int fileLength = this._filename.length();
        int modeLength = _modeBytes[this._mode].length;
        int blkLength = _blkBytes.length;
        int octLength = _octBytes.length;
        data[0] = 0;
        data[1] = (byte)this._type;
        System.arraycopy(this._filename.getBytes(), 0, data, 2, fileLength);
        data[fileLength + 2] = 0;
        System.arraycopy(_modeBytes[this._mode], 0, data, fileLength + 3, modeLength);
        System.arraycopy(_blkBytes, 0, data, fileLength + modeLength + 3, blkLength);
        System.arraycopy(_octBytes, 0, data, fileLength + modeLength + blkLength + 3, octLength);
        datagram.setAddress(this._address);
        datagram.setPort(this._port);
        datagram.setData(data);
        datagram.setLength(fileLength + modeLength + blkLength + octLength + 3);
        return datagram;
    }

    @Override
    public final DatagramPacket newDatagram() {
        int fileLength = this._filename.length();
        int modeLength = _modeBytes[this._mode].length;
        int blkLength = _blkBytes.length;
        int octLength = _octBytes.length;
        byte[] data = new byte[fileLength + modeLength + blkLength + octLength + 4];
        data[0] = 0;
        data[1] = (byte)this._type;
        System.arraycopy(this._filename.getBytes(), 0, data, 2, fileLength);
        data[fileLength + 2] = 0;
        System.arraycopy(_modeBytes[this._mode], 0, data, fileLength + 3, modeLength);
        System.arraycopy(_blkBytes[this._mode], 0, data, fileLength + modeLength + 3, blkLength);
        System.arraycopy(_octBytes[this._mode], 0, data, fileLength + modeLength + blkLength + 3, octLength);
        return new DatagramPacket(data, data.length, this._address, this._port);
    }

    public final int getMode() {
        return this._mode;
    }

    public final String getFilename() {
        return this._filename;
    }
}

