/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPErrorPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPRequestPacket;

public class TFTPServerApp {
    private int intPort;
    private static final int GENERATE_BUF_SIZE = 1000;
    private byte[] inputBuf;
    private TFTP tftp;
    private ByteArrayOutputStream outputStream;

    public TFTPServerApp() {
        this(2269);
    }

    public TFTPServerApp(int port) {
        try {
            this.intPort = port;
            this.tftp = new TFTP();
            this.tftp.open(this.intPort);
            this.inputBuf = new byte[1000];
            int i = 0;
            while (i < 999) {
                this.inputBuf[i] = (byte)(i % 10 + 48);
                ++i;
            }
            i = 70;
            while (i < 999) {
                this.inputBuf[i] = 10;
                i += 70;
            }
            this.inputBuf[999] = 0;
            this.outputStream = new ByteArrayOutputStream();
        }
        catch (Exception e) {
            System.out.println("Exception in opening TFTP connection: " + e.getMessage());
        }
    }

    private void sendFile(InetAddress addr, int port) {
        try {
            int toSend;
            int blockNum = 1;
            for (int bytesSent = 0; bytesSent < this.inputBuf.length; bytesSent += toSend) {
                toSend = 512;
                if (bytesSent + 512 > this.inputBuf.length) {
                    toSend = this.inputBuf.length - bytesSent;
                }
                TFTPDataPacket dPack = new TFTPDataPacket(addr, port, blockNum, this.inputBuf, bytesSent, toSend);
                this.tftp.send(dPack);
                ++blockNum;
                TFTPPacket pack = this.tftp.receive();
                if (pack.getType() == 4) continue;
                this.printPacketError(pack, "read file request");
                return;
            }
            System.out.println("File sent successfully");
        }
        catch (Exception e) {
            System.out.println("Exception in sending file: " + e.getMessage());
        }
    }

    private void receiveFile(InetAddress addr, int port) {
        try {
            boolean lastAck = false;
            int blockNum = 0;
            TFTPAckPacket ackPack = new TFTPAckPacket(addr, port, blockNum);
            while (true) {
                this.tftp.send(ackPack);
                if (lastAck) break;
                ackPack.setBlockNumber(++blockNum);
                TFTPPacket pack = this.tftp.receive();
                if (pack.getType() != 3) {
                    this.printPacketError(pack, "write file request");
                    return;
                }
                TFTPDataPacket dPack = (TFTPDataPacket)pack;
                if (dPack.getDataLength() < 1) break;
                this.outputStream.write(dPack.getData(), dPack.getDataOffset(), dPack.getDataLength());
                if (dPack.getDataLength() >= 512) continue;
                lastAck = true;
            }
            System.out.println("File received successfully: ");
            System.out.println(this.outputStream.toString());
            this.outputStream.reset();
        }
        catch (Exception e) {
            System.out.println("Exception in receiving file: " + e.getMessage());
        }
    }

    private void printPacketError(TFTPPacket pack, String msg) {
        System.out.print("Unexpected packet received in " + msg + ": ");
        switch (pack.getType()) {
            case 4: {
                System.out.println("ACK packet received");
                break;
            }
            case 3: {
                System.out.println("Data packet received");
                break;
            }
            case 5: {
                TFTPErrorPacket ePack = (TFTPErrorPacket)pack;
                System.out.println("Error packet received: " + ePack.getMessage());
                break;
            }
            case 1: {
                System.out.println("Read Request packet received");
                break;
            }
            case 2: {
                System.out.println("Write Request received");
            }
        }
    }

    public void checkForRequests() {
        TFTPPacket pack = null;
        try {
            pack = this.tftp.receive();
        }
        catch (Exception e) {
            return;
        }
        switch (pack.getType()) {
            case 1: {
                TFTPRequestPacket rPack = (TFTPRequestPacket)pack;
                System.out.println("Read request received for file " + rPack.getFilename() + " from address " + rPack.getPort());
                this.sendFile(pack.getAddress(), pack.getPort());
                break;
            }
            case 2: {
                TFTPRequestPacket wPack = (TFTPRequestPacket)pack;
                System.out.println("Write request received for file " + wPack.getFilename() + " from address " + wPack.getPort());
                this.receiveFile(pack.getAddress(), pack.getPort());
                break;
            }
            default: {
                this.printPacketError(pack, "checking for requests");
            }
        }
    }

    public static void main(String[] args) {
        TFTPServerApp app = null;
        app = args.length >= 1 ? new TFTPServerApp(Integer.parseInt(args[1])) : new TFTPServerApp();
        while (true) {
            app.checkForRequests();
        }
    }
}

