/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt;

import java.awt.Graphics;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.experimental.chart.swt.editor.SWTChartEditor;
import org.jfree.experimental.swt.SWTGraphics2D;
import org.jfree.experimental.swt.SWTUtils;

public class ChartComposite
extends Composite
implements ChartChangeListener,
ChartProgressListener,
PaintListener,
SelectionListener,
MouseListener,
MouseMoveListener,
Printable {
    public static final boolean DEFAULT_BUFFER_USED = false;
    public static final int DEFAULT_WIDTH = 680;
    public static final int DEFAULT_HEIGHT = 420;
    public static final int DEFAULT_MINIMUM_DRAW_WIDTH = 300;
    public static final int DEFAULT_MINIMUM_DRAW_HEIGHT = 200;
    public static final int DEFAULT_MAXIMUM_DRAW_WIDTH = 800;
    public static final int DEFAULT_MAXIMUM_DRAW_HEIGHT = 600;
    public static final int DEFAULT_ZOOM_TRIGGER_DISTANCE = 10;
    public static final String PROPERTIES_COMMAND = "PROPERTIES";
    public static final String SAVE_COMMAND = "SAVE";
    public static final String PRINT_COMMAND = "PRINT";
    public static final String ZOOM_IN_BOTH_COMMAND = "ZOOM_IN_BOTH";
    public static final String ZOOM_IN_DOMAIN_COMMAND = "ZOOM_IN_DOMAIN";
    public static final String ZOOM_IN_RANGE_COMMAND = "ZOOM_IN_RANGE";
    public static final String ZOOM_OUT_BOTH_COMMAND = "ZOOM_OUT_BOTH";
    public static final String ZOOM_OUT_DOMAIN_COMMAND = "ZOOM_DOMAIN_BOTH";
    public static final String ZOOM_OUT_RANGE_COMMAND = "ZOOM_RANGE_BOTH";
    public static final String ZOOM_RESET_BOTH_COMMAND = "ZOOM_RESET_BOTH";
    public static final String ZOOM_RESET_DOMAIN_COMMAND = "ZOOM_RESET_DOMAIN";
    public static final String ZOOM_RESET_RANGE_COMMAND = "ZOOM_RESET_RANGE";
    private JFreeChart chart;
    private Canvas canvas;
    private EventListenerList chartMouseListeners;
    private boolean useBuffer;
    private boolean refreshBuffer;
    private boolean displayToolTips;
    private Image chartBuffer;
    private int chartBufferHeight;
    private int chartBufferWidth;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private Menu popup;
    private ChartRenderingInfo info;
    private Point2D anchor;
    private double scaleX;
    private double scaleY;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private boolean domainZoomable = false;
    private boolean rangeZoomable = false;
    private Point zoomPoint = null;
    private transient Rectangle zoomRectangle = null;
    private int zoomTriggerDistance;
    private boolean horizontalAxisTrace = false;
    private boolean verticalAxisTrace = false;
    private transient int verticalTraceLineX;
    private transient int horizontalTraceLineY;
    private MenuItem zoomInBothMenuItem;
    private MenuItem zoomInDomainMenuItem;
    private MenuItem zoomInRangeMenuItem;
    private MenuItem zoomOutBothMenuItem;
    private MenuItem zoomOutDomainMenuItem;
    private MenuItem zoomOutRangeMenuItem;
    private MenuItem zoomResetBothMenuItem;
    private MenuItem zoomResetDomainMenuItem;
    private MenuItem zoomResetRangeMenuItem;
    private boolean enforceFileExtensions;
    private double zoomInFactor = 0.5;
    private double zoomOutFactor = 2.0;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.LocalizationBundle");
    static /* synthetic */ Class class$org$jfree$chart$ChartMouseListener;

    public ChartComposite(Composite comp, int style) {
        this(comp, style, null, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true);
    }

    public ChartComposite(Composite comp, int style, JFreeChart chart) {
        this(comp, style, chart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true);
    }

    public ChartComposite(Composite comp, int style, JFreeChart chart, boolean useBuffer) {
        this(comp, style, chart, 680, 420, 300, 200, 800, 600, useBuffer, true, true, true, true, true);
    }

    public ChartComposite(Composite comp, int style, JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this(comp, style, chart, 680, 420, 300, 200, 800, 600, false, properties, save, print, zoom, tooltips);
    }

    public ChartComposite(Composite comp, int style, JFreeChart jfreechart, int width, int height, int minimumDrawW, int minimumDrawH, int maximumDrawW, int maximumDrawH, boolean usingBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(comp, style);
        this.setChart(jfreechart);
        this.chartMouseListeners = new EventListenerList();
        this.setLayout((Layout)new FillLayout());
        this.info = new ChartRenderingInfo();
        this.useBuffer = usingBuffer;
        this.refreshBuffer = false;
        this.minimumDrawWidth = minimumDrawW;
        this.minimumDrawHeight = minimumDrawH;
        this.maximumDrawWidth = maximumDrawW;
        this.maximumDrawHeight = maximumDrawH;
        this.zoomTriggerDistance = 10;
        this.setDisplayToolTips(tooltips);
        this.canvas = new Canvas((Composite)this, 0x20040000);
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
        this.popup = null;
        if (properties || save || print || zoom) {
            this.popup = this.createPopupMenu(properties, save, print, zoom);
        }
        this.enforceFileExtensions = true;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public Point2D getAnchor() {
        return this.anchor;
    }

    protected void setAnchor(Point2D anchor) {
        this.anchor = anchor;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
            this.chart.removeProgressListener(this);
        }
        this.chart = chart;
        if (chart != null) {
            this.chart.addChangeListener(this);
            this.chart.addProgressListener(this);
            Plot plot = chart.getPlot();
            this.domainZoomable = false;
            this.rangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)plot);
                this.domainZoomable = z.isDomainZoomable();
                this.rangeZoomable = z.isRangeZoomable();
                this.orientation = z.getOrientation();
            }
        } else {
            this.domainZoomable = false;
            this.rangeZoomable = false;
        }
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    public boolean isDomainZoomable() {
        return this.domainZoomable;
    }

    public void setDomainZoomable(boolean flag) {
        if (flag) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)plot);
                this.domainZoomable = flag && z.isDomainZoomable();
            }
        } else {
            this.domainZoomable = false;
        }
    }

    public boolean isRangeZoomable() {
        return this.rangeZoomable;
    }

    public void setRangeZoomable(boolean flag) {
        if (flag) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)plot);
                this.rangeZoomable = flag && z.isRangeZoomable();
            }
        } else {
            this.rangeZoomable = false;
        }
    }

    public double getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(double factor) {
        this.zoomInFactor = factor;
    }

    public double getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(double factor) {
        this.zoomOutFactor = factor;
    }

    private void attemptEditChartProperties() {
        SWTChartEditor editor = new SWTChartEditor(this.canvas.getDisplay(), this.chart);
        editor.open();
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean enforce) {
        this.enforceFileExtensions = enforce;
    }

    public void doSaveAs() throws IOException {
        FileDialog fileDialog = new FileDialog(this.canvas.getShell(), 8192);
        String[] extensions = new String[]{"*.png"};
        fileDialog.setFilterExtensions(extensions);
        String filename = fileDialog.open();
        if (filename != null) {
            if (this.isEnforceFileExtensions() && !filename.endsWith(".png")) {
                filename = filename + ".png";
            }
            ChartUtilities.saveChartAsPNG(new File(filename), this.chart, this.canvas.getSize().x, this.canvas.getSize().y);
        }
    }

    private Point getPointInRectangle(int x, int y, Rectangle area) {
        x = Math.max(area.x, Math.min(x, area.x + area.width));
        y = Math.max(area.y, Math.min(y, area.y + area.height));
        return new Point(x, y);
    }

    public void zoomInBoth(double x, double y) {
        this.zoomInDomain(x, y);
        this.zoomInRange(x, y);
    }

    public void zoomInDomain(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable plot = (Zoomable)((Object)p);
            plot.zoomDomainAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new java.awt.Point((int)x, (int)y)));
        }
    }

    public void zoomInRange(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            z.zoomRangeAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new java.awt.Point((int)x, (int)y)));
        }
    }

    public void zoomOutBoth(double x, double y) {
        this.zoomOutDomain(x, y);
        this.zoomOutRange(x, y);
    }

    public void zoomOutDomain(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            z.zoomDomainAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new java.awt.Point((int)x, (int)y)));
        }
    }

    public void zoomOutRange(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            z.zoomRangeAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new java.awt.Point((int)x, (int)y)));
        }
    }

    public void zoom(Rectangle selection) {
        Point2D selectOrigin = this.translateScreenToJava2D(new java.awt.Point(selection.x, selection.y));
        PlotRenderingInfo plotInfo = this.info.getPlotInfo();
        Rectangle scaledDataArea = this.getScreenDataArea(selection.x + selection.width / 2, selection.y + selection.height / 2);
        if (selection.height > 0 && selection.width > 0) {
            double hLower = (double)(selection.x - scaledDataArea.x) / (double)scaledDataArea.width;
            double hUpper = (double)(selection.x + selection.width - scaledDataArea.x) / (double)scaledDataArea.width;
            double vLower = (double)(scaledDataArea.y + scaledDataArea.height - selection.y - selection.height) / (double)scaledDataArea.height;
            double vUpper = (double)(scaledDataArea.y + scaledDataArea.height - selection.y) / (double)scaledDataArea.height;
            Plot p = this.chart.getPlot();
            if (p instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)p);
                if (z.getOrientation() == PlotOrientation.HORIZONTAL) {
                    z.zoomDomainAxes(vLower, vUpper, plotInfo, selectOrigin);
                    z.zoomRangeAxes(hLower, hUpper, plotInfo, selectOrigin);
                } else {
                    z.zoomDomainAxes(hLower, hUpper, plotInfo, selectOrigin);
                    z.zoomRangeAxes(vLower, vUpper, plotInfo, selectOrigin);
                }
            }
        }
    }

    public void chartChanged(ChartChangeEvent event) {
        this.refreshBuffer = true;
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)plot);
            this.orientation = z.getOrientation();
        }
        this.canvas.redraw();
    }

    public void forceRedraw() {
        Event ev = new Event();
        ev.gc = new GC((Drawable)this.canvas);
        ev.x = 0;
        ev.y = 0;
        ev.width = this.canvas.getBounds().width;
        ev.height = this.canvas.getBounds().height;
        ev.count = 0;
        this.canvas.notifyListeners(9, ev);
        ev.gc.dispose();
    }

    public void addChartMouseListener(ChartMouseListener listener) {
        this.chartMouseListeners.add(class$org$jfree$chart$ChartMouseListener == null ? (class$org$jfree$chart$ChartMouseListener = ChartComposite.class$("org.jfree.chart.ChartMouseListener")) : class$org$jfree$chart$ChartMouseListener, listener);
    }

    public void removeChartMouseListener(ChartMouseListener listener) {
        this.chartMouseListeners.remove(class$org$jfree$chart$ChartMouseListener == null ? (class$org$jfree$chart$ChartMouseListener = ChartComposite.class$("org.jfree.chart.ChartMouseListener")) : class$org$jfree$chart$ChartMouseListener, listener);
    }

    public void chartProgress(ChartProgressEvent event) {
    }

    public void restoreAutoBounds() {
        this.restoreAutoDomainBounds();
        this.restoreAutoRangeBounds();
    }

    public void restoreAutoDomainBounds() {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            Point zp = this.zoomPoint != null ? this.zoomPoint : new Point(0, 0);
            z.zoomDomainAxes(0.0, this.info.getPlotInfo(), SWTUtils.toAwtPoint(zp));
        }
    }

    public void restoreAutoRangeBounds() {
        Plot p = this.chart.getPlot();
        if (p instanceof ValueAxisPlot) {
            Zoomable z = (Zoomable)((Object)p);
            Point zp = this.zoomPoint != null ? this.zoomPoint : new Point(0, 0);
            z.zoomRangeAxes(0.0, this.info.getPlotInfo(), SWTUtils.toAwtPoint(zp));
        }
    }

    public Rectangle scale(Rectangle2D rect) {
        Rectangle insets = this.getClientArea();
        int x = (int)Math.round(rect.getX() * this.getScaleX()) + insets.x;
        int y = (int)Math.round(rect.getY() * this.getScaleY()) + insets.y;
        int w = (int)Math.round(rect.getWidth() * this.getScaleX());
        int h = (int)Math.round(rect.getHeight() * this.getScaleY());
        return new Rectangle(x, y, w, h);
    }

    public Rectangle getScreenDataArea() {
        Rectangle2D dataArea = this.info.getPlotInfo().getDataArea();
        Rectangle clientArea = this.getClientArea();
        int x = (int)(dataArea.getX() * this.scaleX + (double)clientArea.x);
        int y = (int)(dataArea.getY() * this.scaleY + (double)clientArea.y);
        int w = (int)(dataArea.getWidth() * this.scaleX);
        int h = (int)(dataArea.getHeight() * this.scaleY);
        return new Rectangle(x, y, w, h);
    }

    public Rectangle getScreenDataArea(int x, int y) {
        Rectangle result;
        PlotRenderingInfo plotInfo = this.info.getPlotInfo();
        if (plotInfo.getSubplotCount() == 0) {
            result = this.getScreenDataArea();
        } else {
            Point2D selectOrigin = this.translateScreenToJava2D(new java.awt.Point(x, y));
            int subplotIndex = plotInfo.getSubplotIndex(selectOrigin);
            if (subplotIndex == -1) {
                return null;
            }
            result = this.scale(plotInfo.getSubplotInfo(subplotIndex).getDataArea());
        }
        return result;
    }

    public java.awt.Point translateJava2DToScreen(Point2D java2DPoint) {
        Rectangle insets = this.getClientArea();
        int x = (int)(java2DPoint.getX() * this.scaleX + (double)insets.x);
        int y = (int)(java2DPoint.getY() * this.scaleY + (double)insets.y);
        return new java.awt.Point(x, y);
    }

    public java.awt.Point translateScreenToJavaSWT(java.awt.Point screenPoint) {
        Rectangle insets = this.getClientArea();
        int x = (int)((double)(screenPoint.x - insets.x) / this.scaleX);
        int y = (int)((double)(screenPoint.y - insets.y) / this.scaleY);
        return new java.awt.Point(x, y);
    }

    public Point2D translateScreenToJava2D(java.awt.Point screenPoint) {
        Rectangle insets = this.getClientArea();
        int x = (int)((double)(screenPoint.x - insets.x) / this.scaleX);
        int y = (int)((double)(screenPoint.y - insets.y) / this.scaleY);
        return new Point2D.Double(x, y);
    }

    public boolean getHorizontalAxisTrace() {
        return this.horizontalAxisTrace;
    }

    public void setHorizontalAxisTrace(boolean flag) {
        this.horizontalAxisTrace = flag;
    }

    public boolean getVerticalAxisTrace() {
        return this.verticalAxisTrace;
    }

    public void setVerticalAxisTrace(boolean flag) {
        this.verticalAxisTrace = flag;
    }

    public void setDisplayToolTips(boolean displayToolTips) {
        this.displayToolTips = displayToolTips;
    }

    public String getToolTipText(org.eclipse.swt.events.MouseEvent e) {
        EntityCollection entities;
        String result = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            Rectangle insets = this.getClientArea();
            ChartEntity entity = entities.getEntity((int)((double)(e.x - insets.x) / this.scaleX), (int)((double)(e.y - insets.y) / this.scaleY));
            if (entity != null) {
                result = entity.getToolTipText();
            }
        }
        return result;
    }

    protected void displayPopupMenu(int x, int y) {
        if (this.popup != null) {
            Plot plot = this.chart.getPlot();
            boolean isDomainZoomable = false;
            boolean isRangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)plot);
                isDomainZoomable = z.isDomainZoomable();
                isRangeZoomable = z.isRangeZoomable();
            }
            if (this.zoomInDomainMenuItem != null) {
                this.zoomInDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomOutDomainMenuItem != null) {
                this.zoomOutDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomResetDomainMenuItem != null) {
                this.zoomResetDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomInRangeMenuItem != null) {
                this.zoomInRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomOutRangeMenuItem != null) {
                this.zoomOutRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomResetRangeMenuItem != null) {
                this.zoomResetRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomInBothMenuItem != null) {
                this.zoomInBothMenuItem.setEnabled(isDomainZoomable & isRangeZoomable);
            }
            if (this.zoomOutBothMenuItem != null) {
                this.zoomOutBothMenuItem.setEnabled(isDomainZoomable & isRangeZoomable);
            }
            if (this.zoomResetBothMenuItem != null) {
                this.zoomResetBothMenuItem.setEnabled(isDomainZoomable & isRangeZoomable);
            }
            this.popup.setLocation(x, y);
            this.popup.setVisible(true);
        }
    }

    public void createChartPrintJob() {
        PageFormat pf;
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf2 = job.pageDialog(pf = job.defaultPage());
        if (pf2 != pf) {
            job.setPrintable(this, pf2);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    MessageBox messageBox = new MessageBox(this.canvas.getShell(), 33);
                    messageBox.setMessage(e.getMessage());
                    messageBox.open();
                }
            }
        }
    }

    protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
        Menu result = new Menu((Control)this);
        boolean separator = false;
        if (properties) {
            MenuItem propertiesItem = new MenuItem(result, 8);
            propertiesItem.setText(localizationResources.getString("Properties..."));
            propertiesItem.setData((Object)PROPERTIES_COMMAND);
            propertiesItem.addSelectionListener((SelectionListener)this);
            separator = true;
        }
        if (save) {
            if (separator) {
                new MenuItem(result, 2);
                separator = false;
            }
            MenuItem saveItem = new MenuItem(result, 0);
            saveItem.setText(localizationResources.getString("Save_as..."));
            saveItem.setData((Object)SAVE_COMMAND);
            saveItem.addSelectionListener((SelectionListener)this);
            separator = true;
        }
        if (print) {
            if (separator) {
                new MenuItem(result, 2);
                separator = false;
            }
            MenuItem printItem = new MenuItem(result, 0);
            printItem.setText(localizationResources.getString("Print..."));
            printItem.setData((Object)PRINT_COMMAND);
            printItem.addSelectionListener((SelectionListener)this);
            separator = true;
        }
        if (zoom) {
            if (separator) {
                new MenuItem(result, 2);
                separator = false;
            }
            Menu zoomInMenu = new Menu(result);
            MenuItem zoomInMenuItem = new MenuItem(result, 64);
            zoomInMenuItem.setText(localizationResources.getString("Zoom_In"));
            zoomInMenuItem.setMenu(zoomInMenu);
            this.zoomInBothMenuItem = new MenuItem(zoomInMenu, 8);
            this.zoomInBothMenuItem.setText(localizationResources.getString("All_Axes"));
            this.zoomInBothMenuItem.setData((Object)ZOOM_IN_BOTH_COMMAND);
            this.zoomInBothMenuItem.addSelectionListener((SelectionListener)this);
            new MenuItem(zoomInMenu, 2);
            this.zoomInDomainMenuItem = new MenuItem(zoomInMenu, 8);
            this.zoomInDomainMenuItem.setText(localizationResources.getString("Domain_Axis"));
            this.zoomInDomainMenuItem.setData((Object)ZOOM_IN_DOMAIN_COMMAND);
            this.zoomInDomainMenuItem.addSelectionListener((SelectionListener)this);
            this.zoomInRangeMenuItem = new MenuItem(zoomInMenu, 8);
            this.zoomInRangeMenuItem.setText(localizationResources.getString("Range_Axis"));
            this.zoomInRangeMenuItem.setData((Object)ZOOM_IN_RANGE_COMMAND);
            this.zoomInRangeMenuItem.addSelectionListener((SelectionListener)this);
            Menu zoomOutMenu = new Menu(result);
            MenuItem zoomOutMenuItem = new MenuItem(result, 64);
            zoomOutMenuItem.setText(localizationResources.getString("Zoom_Out"));
            zoomOutMenuItem.setMenu(zoomOutMenu);
            this.zoomOutBothMenuItem = new MenuItem(zoomOutMenu, 8);
            this.zoomOutBothMenuItem.setText(localizationResources.getString("All_Axes"));
            this.zoomOutBothMenuItem.setData((Object)ZOOM_OUT_BOTH_COMMAND);
            this.zoomOutBothMenuItem.addSelectionListener((SelectionListener)this);
            new MenuItem(zoomOutMenu, 2);
            this.zoomOutDomainMenuItem = new MenuItem(zoomOutMenu, 8);
            this.zoomOutDomainMenuItem.setText(localizationResources.getString("Domain_Axis"));
            this.zoomOutDomainMenuItem.setData((Object)ZOOM_OUT_DOMAIN_COMMAND);
            this.zoomOutDomainMenuItem.addSelectionListener((SelectionListener)this);
            this.zoomOutRangeMenuItem = new MenuItem(zoomOutMenu, 8);
            this.zoomOutRangeMenuItem.setText(localizationResources.getString("Range_Axis"));
            this.zoomOutRangeMenuItem.setData((Object)ZOOM_OUT_RANGE_COMMAND);
            this.zoomOutRangeMenuItem.addSelectionListener((SelectionListener)this);
            Menu autoRangeMenu = new Menu(result);
            MenuItem autoRangeMenuItem = new MenuItem(result, 64);
            autoRangeMenuItem.setText(localizationResources.getString("Auto_Range"));
            autoRangeMenuItem.setMenu(autoRangeMenu);
            this.zoomResetBothMenuItem = new MenuItem(autoRangeMenu, 8);
            this.zoomResetBothMenuItem.setText(localizationResources.getString("All_Axes"));
            this.zoomResetBothMenuItem.setData((Object)ZOOM_RESET_BOTH_COMMAND);
            this.zoomResetBothMenuItem.addSelectionListener((SelectionListener)this);
            new MenuItem(autoRangeMenu, 2);
            this.zoomResetDomainMenuItem = new MenuItem(autoRangeMenu, 8);
            this.zoomResetDomainMenuItem.setText(localizationResources.getString("Domain_Axis"));
            this.zoomResetDomainMenuItem.setData((Object)ZOOM_RESET_DOMAIN_COMMAND);
            this.zoomResetDomainMenuItem.addSelectionListener((SelectionListener)this);
            this.zoomResetRangeMenuItem = new MenuItem(autoRangeMenu, 8);
            this.zoomResetRangeMenuItem.setText(localizationResources.getString("Range_Axis"));
            this.zoomResetRangeMenuItem.setData((Object)ZOOM_RESET_RANGE_COMMAND);
            this.zoomResetRangeMenuItem.addSelectionListener((SelectionListener)this);
        }
        return result;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        String command = (String)((MenuItem)e.getSource()).getData();
        if (command.equals(PROPERTIES_COMMAND)) {
            this.attemptEditChartProperties();
        } else if (command.equals(SAVE_COMMAND)) {
            try {
                this.doSaveAs();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (command.equals(PRINT_COMMAND)) {
            this.createChartPrintJob();
        } else if (command.equals(ZOOM_IN_BOTH_COMMAND)) {
            this.zoomInBoth(e.x, e.y);
        } else if (command.equals(ZOOM_IN_DOMAIN_COMMAND)) {
            this.zoomInDomain(e.x, e.y);
        } else if (command.equals(ZOOM_IN_RANGE_COMMAND)) {
            this.zoomInRange(e.x, e.y);
        } else if (command.equals(ZOOM_OUT_BOTH_COMMAND)) {
            this.zoomOutBoth(e.x, e.y);
        } else if (command.equals(ZOOM_OUT_DOMAIN_COMMAND)) {
            this.zoomOutDomain(e.x, e.y);
        } else if (command.equals(ZOOM_OUT_RANGE_COMMAND)) {
            this.zoomOutRange(e.x, e.y);
        } else if (command.equals(ZOOM_RESET_BOTH_COMMAND)) {
            this.restoreAutoBounds();
        } else if (command.equals(ZOOM_RESET_DOMAIN_COMMAND)) {
            this.restoreAutoDomainBounds();
        } else if (command.equals(ZOOM_RESET_RANGE_COMMAND)) {
            this.restoreAutoRangeBounds();
        }
        this.forceRedraw();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex != 0) {
            return 1;
        }
        return 0;
    }

    public void addSWTListener(EventListener listener) {
        if (listener instanceof ControlListener) {
            this.canvas.addControlListener((ControlListener)listener);
        } else if (listener instanceof DisposeListener) {
            this.canvas.addDisposeListener((DisposeListener)listener);
        } else if (listener instanceof FocusListener) {
            this.canvas.addFocusListener((FocusListener)listener);
        } else if (listener instanceof HelpListener) {
            this.canvas.addHelpListener((HelpListener)listener);
        } else if (listener instanceof KeyListener) {
            this.canvas.addKeyListener((KeyListener)listener);
        } else if (listener instanceof MouseListener) {
            this.canvas.addMouseListener((MouseListener)listener);
        } else if (listener instanceof MouseMoveListener) {
            this.canvas.addMouseMoveListener((MouseMoveListener)listener);
        } else if (listener instanceof MouseTrackListener) {
            this.canvas.addMouseTrackListener((MouseTrackListener)listener);
        } else if (listener instanceof PaintListener) {
            this.canvas.addPaintListener((PaintListener)listener);
        } else if (listener instanceof TraverseListener) {
            this.canvas.addTraverseListener((TraverseListener)listener);
        }
    }

    public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent event) {
    }

    public void mouseDown(org.eclipse.swt.events.MouseEvent event) {
        EventListener[] listeners;
        EntityCollection entities;
        Rectangle scaledDataArea = this.getScreenDataArea(event.x, event.y);
        if (scaledDataArea == null) {
            return;
        }
        this.zoomPoint = this.getPointInRectangle(event.x, event.y, scaledDataArea);
        int x = (int)((double)(event.x - this.getClientArea().x) / this.scaleX);
        int y = (int)((double)(event.y - this.getClientArea().y) / this.scaleY);
        this.anchor = new Point2D.Double(x, y);
        this.chart.setNotify(true);
        this.canvas.redraw();
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity(x, y);
        }
        if ((listeners = this.chartMouseListeners.getListeners(class$org$jfree$chart$ChartMouseListener == null ? (class$org$jfree$chart$ChartMouseListener = ChartComposite.class$("org.jfree.chart.ChartMouseListener")) : class$org$jfree$chart$ChartMouseListener)).length == 0) {
            return;
        }
        MouseEvent mouseEvent = SWTUtils.toAwtMouseEvent(event);
        ChartMouseEvent chartEvent = new ChartMouseEvent(this.getChart(), mouseEvent, entity);
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ChartMouseListener)listeners[i]).chartMouseClicked(chartEvent);
        }
    }

    public void mouseUp(org.eclipse.swt.events.MouseEvent event) {
        if (this.zoomRectangle == null) {
            Rectangle screenDataArea = this.getScreenDataArea(event.x, event.y);
            if (screenDataArea != null) {
                this.zoomPoint = this.getPointInRectangle(event.x, event.y, screenDataArea);
            }
            if (this.popup != null && event.button == 3) {
                Point pt = this.canvas.toDisplay(event.x, event.y);
                this.displayPopupMenu(pt.x, pt.y);
            }
        } else {
            boolean zoomTrigger2;
            boolean hZoom = false;
            boolean vZoom = false;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                hZoom = this.rangeZoomable;
                vZoom = this.domainZoomable;
            } else {
                hZoom = this.domainZoomable;
                vZoom = this.rangeZoomable;
            }
            boolean zoomTrigger1 = hZoom && Math.abs(this.zoomRectangle.width) >= this.zoomTriggerDistance;
            boolean bl = zoomTrigger2 = vZoom && Math.abs(this.zoomRectangle.height) >= this.zoomTriggerDistance;
            if (zoomTrigger1 || zoomTrigger2) {
                if (hZoom && this.zoomRectangle.x + this.zoomRectangle.width < this.zoomPoint.x || vZoom && this.zoomRectangle.y + this.zoomRectangle.height < this.zoomPoint.y) {
                    this.restoreAutoBounds();
                } else {
                    this.zoom(this.zoomRectangle);
                }
                this.canvas.redraw();
            }
        }
        this.zoomPoint = null;
        this.zoomRectangle = null;
    }

    public void mouseMove(org.eclipse.swt.events.MouseEvent event) {
        EventListener[] listeners;
        EntityCollection entities;
        String s;
        if (this.horizontalAxisTrace || this.verticalAxisTrace) {
            this.horizontalTraceLineY = event.y;
            this.verticalTraceLineX = event.x;
            this.canvas.redraw();
        }
        if (this.displayToolTips && ((s = this.getToolTipText(event)) == null && this.canvas.getToolTipText() != null || s != null && !s.equals(this.canvas.getToolTipText()))) {
            this.canvas.setToolTipText(s);
        }
        if (this.zoomPoint != null) {
            boolean vZoom;
            boolean hZoom;
            Rectangle scaledDataArea = this.getScreenDataArea(this.zoomPoint.x, this.zoomPoint.y);
            Point movingPoint = this.getPointInRectangle(event.x, event.y, scaledDataArea);
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                hZoom = this.rangeZoomable;
                vZoom = this.domainZoomable;
            } else {
                hZoom = this.domainZoomable;
                vZoom = this.rangeZoomable;
            }
            if (hZoom && vZoom) {
                this.zoomRectangle = new Rectangle(this.zoomPoint.x, this.zoomPoint.y, movingPoint.x - this.zoomPoint.x, movingPoint.y - this.zoomPoint.y);
            } else if (hZoom) {
                this.zoomRectangle = new Rectangle(this.zoomPoint.x, scaledDataArea.y, movingPoint.x - this.zoomPoint.x, scaledDataArea.height);
            } else if (vZoom) {
                int ymax = Math.max(movingPoint.y, scaledDataArea.y);
                this.zoomRectangle = new Rectangle(scaledDataArea.x, this.zoomPoint.y, scaledDataArea.width, ymax - this.zoomPoint.y);
            }
            this.canvas.redraw();
        }
        ChartEntity entity = null;
        int x = (int)((double)(event.x - this.getClientArea().x) / this.scaleX);
        int y = (int)((double)(event.y - this.getClientArea().y) / this.scaleY);
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity(x, y);
        }
        if ((listeners = this.chartMouseListeners.getListeners(class$org$jfree$chart$ChartMouseListener == null ? (class$org$jfree$chart$ChartMouseListener = ChartComposite.class$("org.jfree.chart.ChartMouseListener")) : class$org$jfree$chart$ChartMouseListener)).length == 0) {
            return;
        }
        MouseEvent mouseEvent = SWTUtils.toAwtMouseEvent(event);
        ChartMouseEvent chartEvent = new ChartMouseEvent(this.getChart(), mouseEvent, entity);
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((ChartMouseListener)listeners[i]).chartMouseMoved(chartEvent);
        }
    }

    public void paintControl(PaintEvent e) {
        Rectangle available = this.getBounds();
        if (this.chart == null) {
            this.canvas.drawBackground(e.gc, available.x, available.y, available.width, available.height);
            return;
        }
        SWTGraphics2D sg2 = new SWTGraphics2D(e.gc);
        boolean scale = false;
        int drawWidth = available.width;
        int drawHeight = available.height;
        if ((double)drawWidth == 0.0 || (double)drawHeight == 0.0) {
            return;
        }
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (drawWidth < this.minimumDrawWidth) {
            this.scaleX = (double)drawWidth / (double)this.minimumDrawWidth;
            drawWidth = this.minimumDrawWidth;
            scale = true;
        } else if (drawWidth > this.maximumDrawWidth) {
            this.scaleX = (double)drawWidth / (double)this.maximumDrawWidth;
            drawWidth = this.maximumDrawWidth;
            scale = true;
        }
        if (drawHeight < this.minimumDrawHeight) {
            this.scaleY = (double)drawHeight / (double)this.minimumDrawHeight;
            drawHeight = this.minimumDrawHeight;
            scale = true;
        } else if (drawHeight > this.maximumDrawHeight) {
            this.scaleY = (double)drawHeight / (double)this.maximumDrawHeight;
            drawHeight = this.maximumDrawHeight;
            scale = true;
        }
        if (this.useBuffer) {
            this.chartBuffer = (Image)this.canvas.getData("double-buffer-image");
            if (this.chartBuffer == null || this.chartBufferWidth != available.width || this.chartBufferHeight != available.height) {
                this.chartBufferWidth = available.width;
                this.chartBufferHeight = available.height;
                if (this.chartBuffer != null) {
                    this.chartBuffer.dispose();
                }
                this.chartBuffer = new Image((Device)this.getDisplay(), this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                GC gci = new GC((Drawable)this.chartBuffer);
                if (this.chart.getAntiAlias()) {
                    gci.setAntialias(1);
                }
                if (this.chart.getTextAntiAlias() == RenderingHints.KEY_TEXT_ANTIALIASING) {
                    gci.setTextAntialias(1);
                }
                SWTGraphics2D sg2d = new SWTGraphics2D(gci);
                if (scale) {
                    sg2d.scale(this.scaleX, this.scaleY);
                    this.chart.draw(sg2d, new Rectangle2D.Double(0.0, 0.0, drawWidth, drawHeight), this.getAnchor(), this.info);
                } else {
                    this.chart.draw(sg2d, new Rectangle2D.Double(0.0, 0.0, drawWidth, drawHeight), this.getAnchor(), this.info);
                }
                this.canvas.setData("double-buffer-image", (Object)this.chartBuffer);
                sg2d.dispose();
                gci.dispose();
                this.refreshBuffer = false;
            }
            sg2.drawImage(this.chartBuffer, 0, 0);
        } else {
            if (this.chart.getAntiAlias()) {
                e.gc.setAntialias(1);
            }
            if (this.chart.getTextAntiAlias() == RenderingHints.KEY_TEXT_ANTIALIASING) {
                e.gc.setTextAntialias(1);
            }
            this.chart.draw(sg2, new Rectangle2D.Double(0.0, 0.0, this.getBounds().width, this.getBounds().height), this.getAnchor(), this.info);
        }
        Rectangle area = this.getScreenDataArea();
        if (this.horizontalAxisTrace && area.x < this.verticalTraceLineX && area.x + area.width > this.verticalTraceLineX) {
            e.gc.drawLine(this.verticalTraceLineX, area.y, this.verticalTraceLineX, area.y + area.height);
        }
        if (this.verticalAxisTrace && area.y < this.horizontalTraceLineY && area.y + area.height > this.horizontalTraceLineY) {
            e.gc.drawLine(area.x, this.horizontalTraceLineY, area.x + area.width, this.horizontalTraceLineY);
        }
        this.verticalTraceLineX = 0;
        this.horizontalTraceLineY = 0;
        if (this.zoomRectangle != null) {
            e.gc.drawRectangle(this.zoomRectangle);
        }
        sg2.dispose();
    }

    public void dispose() {
        if (this.chartBuffer != null) {
            this.chartBuffer.dispose();
        }
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
            this.chart.removeProgressListener(this);
        }
        super.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

