/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

public class ByteArrayWindow {
    private byte[] value;
    private int offset;
    private int length;

    public ByteArrayWindow(byte[] value, int offset, int length) {
        this.value = value;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public int getOffset() {
        return this.offset;
    }

    public void set(int i, byte b) {
        if (i >= this.length) {
            throw new IndexOutOfBoundsException(i + " >= " + this.length);
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("" + i);
        }
        this.value[i + this.offset] = b;
    }

    public byte get(int i) {
        if (i >= this.length) {
            throw new IndexOutOfBoundsException(i + " >= " + this.length);
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("" + i);
        }
        return this.value[i + this.offset];
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArrayWindow) {
            ByteArrayWindow other = (ByteArrayWindow)obj;
            if (other.length != this.length) {
                return false;
            }
            int i = 0;
            while (i < this.length) {
                if (other.value[i] != this.value[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean equals(ByteArrayWindow other, int maxBytesToCompare) {
        if (other.length < maxBytesToCompare || this.length < maxBytesToCompare) {
            return false;
        }
        int i = 0;
        while (i < maxBytesToCompare) {
            if (this.value[this.offset + i] != other.value[other.offset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

