/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.UsmUserEvent;
import org.snmp4j.event.UsmUserListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.ByteArrayWindow;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SNMPv3SecurityModel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.security.UsmSecurityParameters;
import org.snmp4j.security.UsmSecurityStateReference;
import org.snmp4j.security.UsmTimeEntry;
import org.snmp4j.security.UsmTimeTable;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.security.UsmUserTable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class USM
extends SNMPv3SecurityModel {
    private static final int MAXLEN_USMUSERNAME = 32;
    private static final LogAdapter logger = LogFactory.getLogger(USM.class);
    private UsmUserTable userTable;
    private UsmTimeTable timeTable;
    private boolean engineDiscoveryEnabled = true;
    private SecurityProtocols securityProtocols;
    private transient Vector<UsmUserListener> usmUserListeners;
    private CounterSupport counterSupport;

    public USM(SecurityProtocols securityProtocols, OctetString localEngineID, int engineBoots) {
        this.localEngineID = localEngineID;
        this.timeTable = new UsmTimeTable(localEngineID, engineBoots);
        this.userTable = new UsmUserTable();
        this.securityProtocols = securityProtocols;
        this.counterSupport = CounterSupport.getInstance();
    }

    @Override
    public int getID() {
        return 3;
    }

    @Override
    public boolean supportsEngineIdDiscovery() {
        return true;
    }

    @Override
    public boolean hasAuthoritativeEngineID() {
        return true;
    }

    public void setLocalEngine(OctetString localEngineID, int engineBoots, int engineTime) {
        this.localEngineID = localEngineID;
        this.timeTable.setLocalTime(new UsmTimeEntry(localEngineID, engineBoots, engineTime));
    }

    public void setEngineBoots(int engineBoots) {
        this.timeTable.setEngineBoots(engineBoots);
    }

    public int getEngineBoots() {
        return this.timeTable.getEngineBoots();
    }

    public int getEngineTime() {
        return this.timeTable.getEngineTime();
    }

    @Override
    public SecurityParameters newSecurityParametersInstance() {
        return new UsmSecurityParameters();
    }

    @Override
    public SecurityStateReference newSecurityStateReference() {
        return new UsmSecurityStateReference();
    }

    @Override
    public int generateRequestMessage(int snmpVersion, byte[] globalData, int maxMessageSize, int securityModel, byte[] securityEngineID, byte[] securityName, int securityLevel, BERInputStream scopedPDU, SecurityParameters securityParameters, BEROutputStream wholeMsg, TransportStateReference tmStateReference) throws IOException {
        return this.generateResponseMessage(snmpVersion, globalData, maxMessageSize, securityModel, securityEngineID, securityName, securityLevel, scopedPDU, null, securityParameters, wholeMsg);
    }

    public boolean hasUser(OctetString engineID, OctetString securityName) {
        UsmUserEntry entry = this.userTable.getUser(engineID, securityName);
        return entry != null || (entry = this.userTable.getUser(securityName)) != null || securityName.length() <= 0;
    }

    public UsmUserEntry getUser(OctetString engineID, OctetString securityName) {
        UsmUserEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("getUser(engineID=" + engineID.toHexString() + ", securityName=" + securityName.toString() + ")")));
        }
        if ((entry = this.userTable.getUser(engineID, securityName)) == null) {
            entry = this.userTable.getUser(securityName);
            if (entry == null && securityName.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("USM.getUser - User '" + securityName + "' unknown")));
                }
                return null;
            }
            if (entry == null || engineID.length() == 0) {
                entry = new UsmUserEntry();
                entry.setUserName(securityName);
                entry.setUsmUser(new UsmUser(securityName, null, null, null, null));
                return entry;
            }
            OID authProtocolOID = entry.getUsmUser().getAuthenticationProtocol();
            OID privProtocolOID = entry.getUsmUser().getPrivacyProtocol();
            if (authProtocolOID != null) {
                byte[] authKey = entry.getUsmUser().isLocalized() ? entry.getUsmUser().getAuthenticationPassphrase().getValue() : this.securityProtocols.passwordToKey(authProtocolOID, entry.getUsmUser().getAuthenticationPassphrase(), engineID.getValue());
                byte[] privKey = null;
                if (privProtocolOID != null) {
                    privKey = entry.getUsmUser().isLocalized() ? entry.getUsmUser().getPrivacyPassphrase().getValue() : this.securityProtocols.passwordToKey(privProtocolOID, authProtocolOID, entry.getUsmUser().getPrivacyPassphrase(), engineID.getValue());
                }
                entry = this.addLocalizedUser(engineID.getValue(), securityName, authProtocolOID, authKey, privProtocolOID, privKey);
            }
        }
        return entry;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int generateResponseMessage(int snmpVersion, byte[] globalData, int maxMessageSize, int securityModel, byte[] securityEngineID, byte[] securityName, int securityLevel, BERInputStream scopedPDU, SecurityStateReference securityStateReference, SecurityParameters securityParameters, BEROutputStream wholeMsg) throws IOException {
        byte[] wholeMessage;
        OctetString secEngineID;
        UsmSecurityParameters usmSecurityParams;
        block30: {
            UsmUserEntry user;
            OctetString secName;
            block32: {
                block31: {
                    block29: {
                        usmSecurityParams = (UsmSecurityParameters)securityParameters;
                        if (securityStateReference == null) break block29;
                        UsmSecurityStateReference usmSecurityStateReference = (UsmSecurityStateReference)securityStateReference;
                        if (usmSecurityStateReference.getSecurityEngineID() == null) {
                            usmSecurityParams.setAuthoritativeEngineID(securityEngineID);
                            usmSecurityStateReference.setSecurityEngineID(securityEngineID);
                        }
                        if (usmSecurityStateReference.getSecurityName() == null) {
                            OctetString userName = new OctetString(securityName);
                            usmSecurityStateReference.setSecurityName(userName.getValue());
                            usmSecurityParams.setUserName(userName);
                            OctetString secName2 = this.getSecurityName(new OctetString(securityEngineID), userName);
                            if (secName2 != null && secName2.length() <= 32) {
                                usmSecurityParams.setUserName(secName2);
                            }
                        } else {
                            usmSecurityParams.setUserName(new OctetString(usmSecurityStateReference.getSecurityName()));
                        }
                        usmSecurityParams.setAuthenticationProtocol(usmSecurityStateReference.getAuthenticationProtocol());
                        usmSecurityParams.setPrivacyProtocol(usmSecurityStateReference.getPrivacyProtocol());
                        usmSecurityParams.setAuthenticationKey(usmSecurityStateReference.getAuthenticationKey());
                        usmSecurityParams.setPrivacyKey(usmSecurityStateReference.getPrivacyKey());
                        break block30;
                    }
                    secEngineID = new OctetString();
                    if (securityEngineID != null) {
                        secEngineID.setValue(securityEngineID);
                    }
                    secName = new OctetString(securityName);
                    user = null;
                    if (secEngineID.length() != 0) break block31;
                    if (this.isEngineDiscoveryEnabled()) {
                        if (this.hasUser(null, secName)) {
                            user = new UsmUserEntry();
                        }
                        break block32;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)"Engine ID unknown and discovery disabled"));
                        }
                        return 1410;
                    }
                }
                user = this.getUser(secEngineID, secName);
            }
            if (user == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Security name not found for engineID=" + secEngineID.toHexString() + ", securityName=" + secName.toHexString())));
                }
                return 1404;
            }
            AuthenticationProtocol auth = this.securityProtocols.getAuthenticationProtocol(user.getUsmUser().getAuthenticationProtocol());
            PrivacyProtocol priv = this.securityProtocols.getPrivacyProtocol(user.getUsmUser().getPrivacyProtocol());
            usmSecurityParams.setAuthenticationProtocol(auth);
            usmSecurityParams.setPrivacyProtocol(priv);
            usmSecurityParams.setAuthenticationKey(user.getAuthenticationKey());
            usmSecurityParams.setPrivacyKey(user.getPrivacyKey());
            usmSecurityParams.setUserName(user.getUsmUser().getSecurityName());
            usmSecurityParams.setAuthoritativeEngineID(secEngineID.getValue());
        }
        if (usmSecurityParams.getAuthoritativeEngineID().length > 32) {
            logger.error((Serializable)((Object)("Engine ID too long: " + usmSecurityParams.getAuthoritativeEngineID().length + ">" + 32 + " for " + new OctetString(usmSecurityParams.getAuthoritativeEngineID()).toHexString())));
            return 1401;
        }
        if (securityName.length > 32) {
            logger.error((Serializable)((Object)("Security name too long: " + usmSecurityParams.getAuthoritativeEngineID().length + ">" + 32 + " for " + new OctetString(securityName).toHexString())));
            return 1401;
        }
        if (securityLevel >= 2) {
            if (securityStateReference != null) {
                usmSecurityParams.setAuthoritativeEngineBoots(this.getEngineBoots());
                usmSecurityParams.setAuthoritativeEngineTime(this.getEngineTime());
            } else {
                secEngineID = new OctetString(securityEngineID);
                UsmTimeEntry entry = this.timeTable.getTime(secEngineID);
                if (entry == null) {
                    entry = new UsmTimeEntry(secEngineID, usmSecurityParams.getAuthoritativeEngineBoots(), usmSecurityParams.getAuthoritativeEngineTime());
                    this.timeTable.addEntry(entry);
                } else {
                    usmSecurityParams.setAuthoritativeEngineBoots(entry.getEngineBoots());
                    usmSecurityParams.setAuthoritativeEngineTime(entry.getLatestReceivedTime());
                }
            }
        }
        if (securityLevel >= 2 && usmSecurityParams.getAuthenticationProtocol() == null) {
            return 1403;
        }
        byte[] scopedPduBytes = USM.buildMessageBuffer(scopedPDU);
        if (securityLevel == 3) {
            if (usmSecurityParams.getPrivacyProtocol() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Unsupported security level (missing or unsupported privacy protocol): Security params are " + usmSecurityParams)));
                }
                return 1403;
            }
            logger.debug((Serializable)((Object)"RFC3414 \u00a73.1.4.a Outgoing message needs to be encrypted"));
            DecryptParams decryptParams = new DecryptParams();
            byte[] encryptedScopedPdu = usmSecurityParams.getPrivacyProtocol().encrypt(scopedPduBytes, 0, scopedPduBytes.length, usmSecurityParams.getPrivacyKey(), usmSecurityParams.getAuthoritativeEngineBoots(), usmSecurityParams.getAuthoritativeEngineTime(), decryptParams);
            if (encryptedScopedPdu == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)"Encryption error"));
                }
                return 1405;
            }
            usmSecurityParams.setPrivacyParameters(new OctetString(decryptParams.array));
            OctetString encryptedString = new OctetString(encryptedScopedPdu);
            BEROutputStream os = new BEROutputStream(ByteBuffer.allocate(encryptedString.getBERLength()));
            encryptedString.encodeBER(os);
            scopedPduBytes = os.getBuffer().array();
        } else {
            logger.debug((Serializable)((Object)"RFC3414 \u00a73.1.4.b Outgoing message is not encrypted"));
            usmSecurityParams.setPrivacyParameters(new OctetString());
        }
        if (securityLevel >= 2) {
            byte[] blank = new byte[12];
            usmSecurityParams.setAuthenticationParameters(new OctetString(blank));
            wholeMessage = USM.buildWholeMessage(new Integer32(snmpVersion), scopedPduBytes, globalData, usmSecurityParams);
            int authParamsPos = usmSecurityParams.getAuthParametersPosition() + usmSecurityParams.getSecurityParametersPosition();
            boolean authOK = usmSecurityParams.getAuthenticationProtocol().authenticate(usmSecurityParams.getAuthenticationKey(), wholeMessage, 0, wholeMessage.length, new ByteArrayWindow(wholeMessage, authParamsPos, 12));
            if (!authOK) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)"Outgoing message could not be authenticated"));
                }
                return 1407;
            }
        } else {
            usmSecurityParams.setAuthoritativeEngineBoots(0);
            usmSecurityParams.setAuthenticationParameters(new OctetString());
            usmSecurityParams.setAuthoritativeEngineTime(0);
            wholeMessage = USM.buildWholeMessage(new Integer32(snmpVersion), scopedPduBytes, globalData, usmSecurityParams);
        }
        ByteBuffer buf = (ByteBuffer)ByteBuffer.wrap(wholeMessage).position(wholeMessage.length);
        wholeMsg.setBuffer(buf);
        return 0;
    }

    private OctetString getSecurityName(OctetString engineID, OctetString userName) {
        if (userName.length() == 0) {
            return userName;
        }
        UsmUserEntry user = this.userTable.getUser(engineID, userName);
        if (user != null) {
            return user.getUsmUser().getSecurityName();
        }
        if (this.isEngineDiscoveryEnabled() && (user = this.userTable.getUser(userName)) != null) {
            return user.getUsmUser().getSecurityName();
        }
        return null;
    }

    @Override
    public int processIncomingMsg(int snmpVersion, int maxMessageSize, SecurityParameters securityParameters, SecurityModel securityModel, int securityLevel, BERInputStream wholeMsg, TransportStateReference tmStateReference, OctetString securityEngineID, OctetString securityName, BEROutputStream scopedPDU, Integer32 maxSizeResponseScopedPDU, SecurityStateReference securityStateReference, StatusInformation statusInfo) throws IOException {
        UsmSecurityParameters usmSecurityParameters = (UsmSecurityParameters)securityParameters;
        UsmSecurityStateReference usmSecurityStateReference = (UsmSecurityStateReference)securityStateReference;
        securityEngineID.setValue(usmSecurityParameters.getAuthoritativeEngineID());
        byte[] message = USM.buildMessageBuffer(wholeMsg);
        if (securityEngineID.length() == 0 || this.timeTable.checkEngineID(securityEngineID, this.isEngineDiscoveryEnabled()) != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.3 Unknown engine ID: " + securityEngineID.toHexString())));
            }
            securityEngineID.setValue(usmSecurityParameters.getAuthoritativeEngineID());
            securityName.setValue(usmSecurityParameters.getUserName().getValue());
            if (statusInfo != null) {
                CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsUnknownEngineIDs);
                this.fireIncrementCounter(event);
                statusInfo.setSecurityLevel(new Integer32(securityLevel));
                statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
            }
            return 1410;
        }
        securityName.setValue(usmSecurityParameters.getUserName().getValue());
        int scopedPDUPosition = usmSecurityParameters.getScopedPduPosition();
        if (usmSecurityParameters.getUserName().length() > 0 || securityLevel > 1) {
            OctetString secName = this.getSecurityName(securityEngineID, usmSecurityParameters.getUserName());
            if (secName == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.4 Unknown security name: " + securityName.toHexString())));
                }
                if (statusInfo != null) {
                    CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsUnknownUserNames);
                    this.fireIncrementCounter(event);
                    statusInfo.setSecurityLevel(new Integer32(1));
                    statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                }
                return 1404;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)"Accepting zero length security name"));
            }
            securityName.setValue(new byte[0]);
        }
        if (usmSecurityParameters.getUserName().length() > 0 || securityLevel > 1) {
            UsmUserEntry user = this.getUser(securityEngineID, securityName);
            if (user == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.4 Unknown security name: " + securityName.toHexString() + " for engine ID " + securityEngineID.toHexString())));
                }
                CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsUnknownUserNames);
                this.fireIncrementCounter(event);
                if (statusInfo != null) {
                    if (SNMP4JSettings.getReportSecurityLevelStrategy() == SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded) {
                        statusInfo.setSecurityLevel(new Integer32(1));
                    }
                    statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                }
                return 1404;
            }
            usmSecurityStateReference.setUserName(user.getUserName().getValue());
            AuthenticationProtocol auth = this.securityProtocols.getAuthenticationProtocol(user.getUsmUser().getAuthenticationProtocol());
            PrivacyProtocol priv = this.securityProtocols.getPrivacyProtocol(user.getUsmUser().getPrivacyProtocol());
            usmSecurityStateReference.setAuthenticationKey(user.getAuthenticationKey());
            usmSecurityStateReference.setPrivacyKey(user.getPrivacyKey());
            usmSecurityStateReference.setAuthenticationProtocol(auth);
            usmSecurityStateReference.setPrivacyProtocol(priv);
            if (securityLevel >= 2 && auth == null || securityLevel >= 3 && priv == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.5 - Unsupported security level: " + securityLevel + " by user " + user)));
                }
                CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsUnsupportedSecLevels);
                this.fireIncrementCounter(event);
                if (SNMP4JSettings.getReportSecurityLevelStrategy() == SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded) {
                    statusInfo.setSecurityLevel(new Integer32(1));
                }
                statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                return 1403;
            }
            if (securityLevel >= 2) {
                if (statusInfo != null) {
                    int authParamsPos = usmSecurityParameters.getAuthParametersPosition() + usmSecurityParameters.getSecurityParametersPosition();
                    boolean authentic = auth.isAuthentic(user.getAuthenticationKey(), message, 0, message.length, new ByteArrayWindow(message, authParamsPos, 12));
                    if (!authentic) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.6 Wrong digest -> authentication failure: " + usmSecurityParameters.getAuthenticationParameters().toHexString())));
                        }
                        CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsWrongDigests);
                        this.fireIncrementCounter(event);
                        if (SNMP4JSettings.getReportSecurityLevelStrategy() == SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded) {
                            statusInfo.setSecurityLevel(new Integer32(1));
                        }
                        statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                        return 1408;
                    }
                    int status = this.timeTable.checkTime(new UsmTimeEntry(securityEngineID, usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime()));
                    switch (status) {
                        case 1411: {
                            logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.7.a Not in time window; engineID='" + securityEngineID + "', engineBoots=" + usmSecurityParameters.getAuthoritativeEngineBoots() + ", engineTime=" + usmSecurityParameters.getAuthoritativeEngineTime())));
                            CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsNotInTimeWindows);
                            this.fireIncrementCounter(event);
                            statusInfo.setSecurityLevel(new Integer32(2));
                            statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                            return status;
                        }
                        case 1410: {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("RFC3414 \u00a73.2.7.b - Unkown engine ID: " + securityEngineID)));
                            }
                            CounterEvent event = new CounterEvent(this, SnmpConstants.usmStatsUnknownEngineIDs);
                            this.fireIncrementCounter(event);
                            if (SNMP4JSettings.getReportSecurityLevelStrategy() == SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded) {
                                statusInfo.setSecurityLevel(new Integer32(1));
                            }
                            statusInfo.setErrorIndication(new VariableBinding(event.getOid(), event.getCurrentValue()));
                            return status;
                        }
                    }
                }
                if (securityLevel >= 3) {
                    OctetString privParams = usmSecurityParameters.getPrivacyParameters();
                    DecryptParams decryptParams = new DecryptParams(privParams.getValue(), 0, privParams.length());
                    try {
                        int scopedPDUHeaderLength = message.length - scopedPDUPosition;
                        ByteBuffer bis = ByteBuffer.wrap(message, scopedPDUPosition, scopedPDUHeaderLength);
                        BERInputStream scopedPDUHeader = new BERInputStream(bis);
                        long headerStartingPosition = scopedPDUHeader.getPosition();
                        int scopedPDULength = BER.decodeHeader(scopedPDUHeader, new BER.MutableByte());
                        int scopedPDUPayloadPosition = scopedPDUPosition + (int)(scopedPDUHeader.getPosition() - headerStartingPosition);
                        scopedPDUHeader.close();
                        scopedPDUHeader = null;
                        byte[] scopedPduBytes = priv.decrypt(message, scopedPDUPayloadPosition, scopedPDULength, user.getPrivacyKey(), usmSecurityParameters.getAuthoritativeEngineBoots(), usmSecurityParameters.getAuthoritativeEngineTime(), decryptParams);
                        ByteBuffer buf = ByteBuffer.wrap(scopedPduBytes);
                        scopedPDU.setFilledBuffer(buf);
                    }
                    catch (Exception ex) {
                        logger.debug((Serializable)((Object)("RFC 3414 \u00a73.2.8 Decryption error: " + ex.getMessage())));
                        return 1406;
                    }
                } else {
                    int scopedPduLength = message.length - scopedPDUPosition;
                    ByteBuffer buf = ByteBuffer.wrap(message, scopedPDUPosition, scopedPduLength);
                    scopedPDU.setFilledBuffer(buf);
                }
            } else {
                int scopedPduLength = message.length - scopedPDUPosition;
                ByteBuffer buf = ByteBuffer.wrap(message, scopedPDUPosition, scopedPduLength);
                scopedPDU.setFilledBuffer(buf);
            }
        } else {
            int scopedPduLength = message.length - scopedPDUPosition;
            ByteBuffer buf = ByteBuffer.wrap(message, scopedPDUPosition, scopedPduLength);
            scopedPDU.setFilledBuffer(buf);
        }
        int maxSecParamsOverhead = usmSecurityParameters.getBERMaxLength(securityLevel);
        maxSizeResponseScopedPDU.setValue(maxMessageSize - maxSecParamsOverhead);
        usmSecurityStateReference.setSecurityName(securityName.getValue());
        return 0;
    }

    protected void fireIncrementCounter(CounterEvent e) {
        this.counterSupport.fireIncrementCounter(e);
    }

    public void addUser(OctetString userName, UsmUser user) {
        this.addUser(userName, new OctetString(), user);
    }

    public void addUser(UsmUser user) {
        this.addUser(user.getSecurityName(), new OctetString(), user);
    }

    public void addUser(OctetString userName, OctetString engineID, UsmUser user) {
        byte[] authKey = null;
        byte[] privKey = null;
        if (engineID != null && engineID.length() > 0 && user.getAuthenticationProtocol() != null) {
            authKey = user.isLocalized() ? user.getAuthenticationPassphrase().getValue() : this.securityProtocols.passwordToKey(user.getAuthenticationProtocol(), user.getAuthenticationPassphrase(), engineID.getValue());
            if (user.getPrivacyProtocol() != null) {
                privKey = user.isLocalized() ? user.getPrivacyPassphrase().getValue() : this.securityProtocols.passwordToKey(user.getPrivacyProtocol(), user.getAuthenticationProtocol(), user.getPrivacyPassphrase(), engineID.getValue());
            }
        }
        OctetString userEngineID = user.isLocalized() ? user.getLocalizationEngineID() : (engineID == null ? new OctetString() : engineID);
        UsmUserEntry entry = new UsmUserEntry(userName, userEngineID, user);
        entry.setAuthenticationKey(authKey);
        entry.setPrivacyKey(privKey);
        this.userTable.addUser(entry);
        this.fireUsmUserChange(new UsmUserEvent(this, entry, 1));
    }

    public void updateUser(UsmUserEntry entry) {
        UsmUserEntry oldEntry = this.userTable.addUser(entry);
        this.fireUsmUserChange(new UsmUserEvent(this, entry, oldEntry == null ? 1 : 3));
    }

    public void setUsers(UsmUser[] users) {
        if (users == null || users.length == 0) {
            this.userTable.clear();
        } else {
            Vector<UsmUserEntry> v = new Vector<UsmUserEntry>(users.length);
            UsmUser[] usmUserArray = users;
            int n = users.length;
            int n2 = 0;
            while (n2 < n) {
                UsmUser user = usmUserArray[n2];
                UsmUserEntry entry = new UsmUserEntry(user.getSecurityName(), (UsmUser)user.clone());
                v.add(entry);
                ++n2;
            }
            this.userTable.setUsers(v);
        }
    }

    public UsmUserTable getUserTable() {
        return this.userTable;
    }

    public UsmTimeTable getTimeTable() {
        return this.timeTable;
    }

    public List<UsmUser> removeAllUsers(OctetString userName, OctetString engineID) {
        List<UsmUserEntry> entries = this.userTable.removeAllUsers(userName, engineID);
        if (!entries.isEmpty()) {
            ArrayList<UsmUser> users = new ArrayList<UsmUser>();
            for (UsmUserEntry entry : entries) {
                users.add(entry.getUsmUser());
                this.fireUsmUserChange(new UsmUserEvent(this, entry, 2));
            }
            return users;
        }
        return Collections.emptyList();
    }

    public List<UsmUser> removeAllUsers(OctetString userName) {
        return this.removeAllUsers(userName, null);
    }

    public UsmUser removeUser(OctetString engineID, OctetString userName) {
        UsmUserEntry entry = this.userTable.removeUser(engineID, userName);
        if (entry != null) {
            this.fireUsmUserChange(new UsmUserEvent(this, entry, 2));
            return entry.getUsmUser();
        }
        return null;
    }

    public void removeAllUsers() {
        this.userTable.clear();
        this.fireUsmUserChange(new UsmUserEvent(this, null, 2));
    }

    public UsmUserEntry addLocalizedUser(byte[] engineID, OctetString userName, OID authProtocol, byte[] authKey, OID privProtocol, byte[] privKey) {
        UsmUserEntry newEntry = new UsmUserEntry(engineID, userName, authProtocol, authKey, privProtocol, privKey);
        this.userTable.addUser(newEntry);
        this.fireUsmUserChange(new UsmUserEvent(this, newEntry, 1));
        return newEntry;
    }

    public boolean isEngineDiscoveryEnabled() {
        return this.engineDiscoveryEnabled;
    }

    public void setEngineDiscoveryEnabled(boolean engineDiscoveryEnabled) {
        this.engineDiscoveryEnabled = engineDiscoveryEnabled;
    }

    public synchronized void removeUsmUserListener(UsmUserListener l) {
        if (this.usmUserListeners != null && this.usmUserListeners.contains(l)) {
            this.usmUserListeners.remove(l);
        }
    }

    public synchronized void addUsmUserListener(UsmUserListener l) {
        if (this.usmUserListeners == null) {
            this.usmUserListeners = new Vector(2);
        }
        if (!this.usmUserListeners.contains(l)) {
            this.usmUserListeners.add(l);
        }
    }

    public void removeEngineTime(OctetString engineID) {
        this.timeTable.removeEntry(engineID);
    }

    protected void fireUsmUserChange(UsmUserEvent e) {
        if (this.usmUserListeners != null) {
            Vector<UsmUserListener> listeners = this.usmUserListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                listeners.get(i).usmUserChange(e);
                ++i;
            }
        }
    }

    public CounterSupport getCounterSupport() {
        return this.counterSupport;
    }

    public SecurityProtocols getSecurityProtocols() {
        return this.securityProtocols;
    }

    public void setCounterSupport(CounterSupport counterSupport) {
        if (counterSupport == null) {
            throw new NullPointerException();
        }
        this.counterSupport = counterSupport;
    }
}

