/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportMapping;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.transport.TLSTM;

public class TransportMappings {
    private static final LogAdapter logger = LogFactory.getLogger(TransportMappings.class);
    public static final String TRANSPORT_MAPPINGS = "org.snmp4j.transportMappings";
    private static final String TRANSPORT_MAPPINGS_DEFAULT = "transports.properties";
    private static TransportMappings instance = null;
    private Hashtable<String, Class<? extends TransportMapping>> transportMappings = null;

    protected TransportMappings() {
    }

    public static TransportMappings getInstance() {
        if (instance == null) {
            instance = new TransportMappings();
        }
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    public TransportMapping createTransportMapping(Address transportAddress) {
        if (this.transportMappings == null) {
            this.registerTransportMappings();
        }
        if ((c = this.transportMappings.get(transportAddress.getClass().getName())) == null) {
            return null;
        }
        params = new Class[]{transportAddress.getClass()};
        try {
            try {
                constructor = c.getConstructor(params);
                return constructor.newInstance(new Object[]{transportAddress});
            }
            catch (NoSuchMethodException nsme) {
                var10_9 = cs = c.getConstructors();
                var9_10 = cs.length;
                var8_11 = 0;
                ** while (var8_11 < var9_10)
            }
lbl-1000:
            // 1 sources

            {
                cons = var10_9[var8_11];
                params2 = cons.getParameterTypes();
                if (params2.length == 1 && params2[0].isAssignableFrom(params[0])) {
                    return (TransportMapping)cons.newInstance(new Object[]{transportAddress});
                }
                ++var8_11;
                continue;
            }
lbl21:
            // 1 sources

            TransportMappings.logger.error("NoSuchMethodException while instantiating " + c.getName(), nsme);
            return null;
        }
        catch (InvocationTargetException ite) {
            if (TransportMappings.logger.isDebugEnabled()) {
                ite.printStackTrace();
            }
            TransportMappings.logger.error(ite);
            throw new RuntimeException(ite.getTargetException());
        }
        catch (Exception ex) {
            if (TransportMappings.logger.isDebugEnabled()) {
                ex.printStackTrace();
            }
            TransportMappings.logger.error(ex);
            return null;
        }
    }

    protected synchronized void registerTransportMappings() {
        block14: {
            if (SNMP4JSettings.isExtensibilityEnabled()) {
                String transports = System.getProperty(TRANSPORT_MAPPINGS, TRANSPORT_MAPPINGS_DEFAULT);
                InputStream is = TransportMappings.class.getResourceAsStream(transports);
                if (is == null) {
                    throw new InternalError("Could not read '" + transports + "' from classpath!");
                }
                Properties props = new Properties();
                try {
                    try {
                        props.load(is);
                        Hashtable t = new Hashtable(props.size());
                        Enumeration<?> en = props.propertyNames();
                        while (en.hasMoreElements()) {
                            String addressClassName = en.nextElement().toString();
                            String className = props.getProperty(addressClassName);
                            try {
                                Class<?> c = Class.forName(className);
                                t.put(addressClassName, c);
                            }
                            catch (ClassNotFoundException cnfe) {
                                logger.error(cnfe);
                            }
                        }
                        this.transportMappings = t;
                        break block14;
                    }
                    catch (IOException iox) {
                        String txt = "Could not read '" + transports + "': " + iox.getMessage();
                        logger.error((Serializable)((Object)txt));
                        throw new InternalError(txt);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        logger.warn(ex);
                    }
                }
            }
            Hashtable<String, Class<TLSTM>> t = new Hashtable<String, Class<TLSTM>>(2);
            t.put(UdpAddress.class.getName(), DefaultUdpTransportMapping.class);
            t.put(TcpAddress.class.getName(), DefaultTcpTransportMapping.class);
            t.put(TlsAddress.class.getName(), TLSTM.class);
            this.transportMappings = t;
        }
    }
}

