/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.text.ParseException;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.VariableTextFormat;

public class SimpleVariableTextFormat
implements VariableTextFormat {
    @Override
    public String format(OID instanceOID, Variable variable, boolean withOID) {
        return withOID ? String.valueOf(SNMP4JSettings.getOIDTextFormat().format(instanceOID.getValue())) + " = " + variable : variable.toString();
    }

    @Override
    public Variable parse(int smiSyntax, String text) throws ParseException {
        Variable v = AbstractVariable.createFromSyntax(smiSyntax);
        if (v instanceof AssignableFromString) {
            ((AssignableFromString)((Object)v)).setValue(text);
        }
        return v;
    }

    @Override
    public Variable parse(OID classOrInstanceOID, String text) throws ParseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public VariableBinding parseVariableBinding(String text) throws ParseException {
        int assignmentPos = text.indexOf(" = ");
        if (assignmentPos <= 0) {
            throw new ParseException("Could not locate assignment ' = ' string in '" + text, 0);
        }
        OID oid = new OID(SNMP4JSettings.getOIDTextFormat().parse(text.substring(0, assignmentPos)));
        Variable var = this.parse(oid, text.substring(assignmentPos + 3));
        return new VariableBinding(oid, var);
    }
}

