#!/bin/sh
# Copyright (c) 2014, The Linux Foundation. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of The Linux Foundation nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
# ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# find_partitions        init.d script to dynamically find partitions
#

FindAndMountUBI () {

# quectel modification 20160802 add 
# if define(CONFIG_QUECTEL_MODEM_BOOT_TIME) && define (QUECTEL_MODEM_BACKUP), mark the follow script,it is not need now 
if false ;then
   partition=$1
   dir=$2

  mtd_block_number=`cat $mtd_file | grep -i $partition | sed 's/^mtd//' | awk -F ':' '{print $1}'`
   echo "MTD : Detected block device : $dir for $partition"
   mkdir -p $dir

  ubiattach -m $mtd_block_number -d 1 /dev/ubi_ctrl
  device=/dev/ubi1_0
  while [ 1 ]
   do
      if [ -c $device ]
      then
          mount -t ubifs -o ro /dev/ubi1_0 $dir -o bulk_read
           break
       else
          sleep 0.010
       fi
   done
fi	

# quectel modification 20160802 add start 
# if  define (QUECTEL_MODEM_BACKUP) , the follow script is use to restore the modem file if it is lost or modem system bad
	QuecMRstTimes=0
	Var1=0
	Var2=1
	
	if [ -e /firmware/image ] && [ ! -f /data/modem_restoring_flag ]; then  
	     # modem 目录加载正常，且restoring_flag 不存在，说明modem文件系统正常。
		echo -n "@Ramos modem file check ok !!!!"
	else
		echo -n "@Ramos modem abnormal and restore the modem beging !!!"
		if [ -f  /data/modem_backup_flag ]; then
			 #开始进入还原过程，做好标记，等还原完成，再清除，防止中途断电等意外
			echo -n 1 > "/data/modem_restoring_flag"
			sync
			umount /firmware
			ubidetach -p /dev/mtd9
			ubiformat /dev/mtd9 -y
			ubiattach -p /dev/mtd9
			if [ $? -eq 0 ];then
			echo -n "ubiattach success !!!\r" > "/data/restore_log"
			else
			sys_reboot
			fi
			ubimkvol /dev/ubi1 -s 62MiB -N modem
			if [ $? -eq 0 ];then
			echo -n "ubimkvol success !!!\r" > "/data/restore_log"
			else
			sys_reboot
			fi
			mount -t ubifs ubi1:modem /firmware
			if [ $? -eq 0 ];then
			echo -n "mount modem success !!!\r" > "/data/restore_log"
			else
			sys_reboot
			fi
			mount -t ubifs ubi0:cachefs /cache -o bulk_read
			if [ $? -eq 0 ];then
			echo -n "mount cache success !!!\r" > "/data/restore_log"
			else
			sys_reboot
			fi
			cp -arf /cache/image /firmware
			if [ $? -eq 0 ];then
			echo -n "cp retore file to modem success!!!\r" > "/data/restore_log"
			else
			sys_reboot
			fi
			sync
			#删除还原的flag， 还原全部完成。
			if [ -f /data/Modem_Restore_times ]; then
				Var1=`cat  /data/Modem_Restore_times`
			fi
			QuecMRstTimes=$(($Var1+$Var2))
			echo  -n  $QuecMRstTimes  >  "/data/Modem_Restore_times"
			rm -rf /data/modem_restoring_flag
			sync
			echo -n "@Ramos modem restore end !!!!"
		else
			echo -n "@Ramos modem not backup !!!!!"
		fi
	fi
# quectel modification 20160802 add end
}

FindAndMountVolumeUBI () {
   volume_name=$1
   dir=$2
   if [ ! -d $dir ]
   then
       mkdir -p $dir
   fi
   mount -t ubifs ubi0:$volume_name $dir -o bulk_read
}

mtd_file=/proc/mtd

fstype="UBI"
eval FindAndMountVolume${fstype} usrfs /data

eval FindAndMount${fstype} modem /firmware

#jacky 2018/04/16 Mount /cache as default when use EC21KL_KT project. For KT FOTA feature.
if [ `grep -c "EC21KL_KT" /etc/quectel-project-version` -eq '1' ]; then
    mount -t ubifs ubi0:cachefs /cache -o bulk_read
fi

# quectel modification 20160802 add
wait 

exit 0
