#!/bin/bash -e

ACKSYS_WAVEMANAGER_PATH="/opt/acksys/bin/"

# Use the following variables to control your install:
# STEP 01 :  Read the password for the postgres user (required)
echo "Enter the postgres administration password : this will be used to connect to the PostgreSQL server"
read -s -p "Password: " POSTGRESQL_ADMIN_PASSWORD

# Version of postgresql server you're installing
POSTGRESQL_VERSION='16'

if [ -z POSTGRESQL_ADMIN_PASSWORD ]
then
  echo "PostgreSQL server administration password must be set for unattended install"
  exit 1
fi

# Step 02 : Start the postgresql server
sudo systemctl start postgresql

# Step 03 : Configure the postgresql server using the specified password
echo "Configuring PostgreSQL Server..."
sudo -u postgres psql -c "ALTER USER postgres PASSWORD '$POSTGRESQL_ADMIN_PASSWORD';"

# Step 04 : Configure firewall to allow TCP port 5432
echo "Configuring UFW to allow traffic on port 5432..."
sudo ufw allow 5432/tcp
sudo ufw reload

# Step 05 : Restart postgresql server after installing
echo "Restarting PostgreSQL Server..."
sudo systemctl restart postgresql

# Step 06 : Configure the postgresql appsettings with the specified arguments
# Update the database engine field in the JSON file
sudo sed -i "s/\"DataBaseEngine\": \".*\"/\"DataBaseEngine\": \"PostgreSql\"/" $ACKSYS_WAVEMANAGER_PATH/appsettings.json

# Update the "os related fields" field in the JSON file
EncryptedConnectionData=`echo -n "Host=127.0.0.1;Port=5432;Username=postgres;Password=$POSTGRESQL_ADMIN_PASSWORD;" |  base64 -w0`
sudo sed -i "s/\"OsRelatedOperationalContext\": \".*\"/\"OsRelatedOperationalContext\": \"$EncryptedConnectionData\"/" $ACKSYS_WAVEMANAGER_PATH/appsettings.json
sudo sed -i "s/\"OsRelatedSyslogContext\": \".*\"/\"OsRelatedSyslogContext\": \"$EncryptedConnectionData\"/" $ACKSYS_WAVEMANAGER_PATH/appsettings.json