﻿(() => {
    /**
     * Stores the reference to the .NET instance for interop
     */
    window.InitConnectionDotNetReference = function (dotNetReference) {
        window.ConnectionDotNetReference = dotNetReference;
    };

    /**
     * Checks for general internet connectivity by trying to reach Google.
     * Note: Due to 'no-cors' mode, we can't inspect the response body or status.
     */
    window.CheckInternetConnection = async function () {
        try {
            const response = await fetch('https://www.google.com', { mode: 'no-cors' });
            return response ? true : false;
        } catch {
            return false;
        }
    };

    /**
     * Attempts to reach the provided IP address with a timeout.
     */
    window.IsHttpWebServerReachable = async function (ipAddress) {

        // Normalize IP (browser requires [] for IPv6 literal)
        const formatIp = (ip) => ip.includes(":") ? `[${ip}]` : ip;

        const controller = new AbortController();
        const timeout = setTimeout(() => controller.abort(), 800);

        try {
            // no-cors ensures request won't fail due to CORS policy
            await fetch(`http://${formatIp(ipAddress)}/`, {
                method: "GET",
                mode: "no-cors",
                signal: controller.signal,
                cache: "no-store" // avoids cached results
            });

            clearTimeout(timeout);
            return true;
        } catch (err) {
            clearTimeout(timeout);
            return false;
        }
    };

    /**
     * Opens the given URL in a new browser tab.
     */
    window.OpenInNewTab = function (url) {
        window.open(url, '_blank');
    };
})();
