﻿window.ApplyInputMask = () => {
	$('[ip-mask]').inputmask({
		alias: "ip",
		greedy: false
	});
};

window.SaveFileUsingContent = (filename, bytesBase64) => {
	var link = document.createElement('a');
	link.download = filename;
	link.href = "data:text/html;base64," + bytesBase64;
	document.body.appendChild(link); // Needed for Firefox
	link.click();
	document.body.removeChild(link);
}

window.SaveFileUsingTypedContent = (fileName, byteArray, mimeType) => {
	const uint8Array = new Uint8Array(byteArray);

	// Create blob from the bytes
	const blob = new Blob([uint8Array], { type: mimeType });

	// Create download link
	const link = document.createElement('a');
	link.href = URL.createObjectURL(blob);
	link.download = fileName;
	link.style.display = 'none';

	// Trigger download
	document.body.appendChild(link);
	link.click();

	// Cleanup
	setTimeout(() => {
		document.body.removeChild(link);
		URL.revokeObjectURL(link.href);
	}, 100);
};


window.SaveFileUsingPresignedURL = (presignedUrl) => {
	var iframe = document.createElement('iframe');
	iframe.src = presignedUrl;
	iframe.style.display = 'none';
	document.body.appendChild(iframe);
	setTimeout(() => document.body.removeChild(iframe), 10000);
}

//Javascript method to replace the navigation manager in the dashboard page
function navigateto(url) {
	window.location.href = url;
}

//Jquery gere lui même la propagation des evenements JS
// Si les evenements JS sont catché et réenvoyé avec un $.trigger, alors Blazor ne les vois pas.
//Se code surcharge donc la fonction trigger de JQuery pour réenvoyer un veritable evenement JS
jQuery.fn.extend({
	trigger: function (evt) {
		this.each(function () {
			this.dispatchEvent(new Event(evt));
		});
	}
});